/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ExposureState;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.ForwardingCameraInfo;
import androidx.camera.core.impl.RestrictedCameraControl;
import androidx.camera.core.internal.ImmutableZoomState;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;

@RequiresApi(value=21)
public class RestrictedCameraInfo
extends ForwardingCameraInfo {
    private final CameraInfoInternal mCameraInfo;
    private final RestrictedCameraControl mRestrictedCameraControl;
    private boolean mIsPostviewSupported = false;
    private boolean mIsCaptureProcessProgressSupported = false;

    public RestrictedCameraInfo(@NonNull CameraInfoInternal cameraInfo, @NonNull RestrictedCameraControl restrictedCameraControl) {
        super(cameraInfo);
        this.mCameraInfo = cameraInfo;
        this.mRestrictedCameraControl = restrictedCameraControl;
    }

    @Override
    @NonNull
    public CameraInfoInternal getImplementation() {
        return this.mCameraInfo;
    }

    @Override
    public boolean hasFlashUnit() {
        if (!this.mRestrictedCameraControl.isOperationSupported(5)) {
            return false;
        }
        return this.mCameraInfo.hasFlashUnit();
    }

    @Override
    @NonNull
    public LiveData<Integer> getTorchState() {
        if (!this.mRestrictedCameraControl.isOperationSupported(6)) {
            return new MutableLiveData((Object)0);
        }
        return this.mCameraInfo.getTorchState();
    }

    @Override
    @NonNull
    public LiveData<ZoomState> getZoomState() {
        if (!this.mRestrictedCameraControl.isOperationSupported(0)) {
            return new MutableLiveData((Object)ImmutableZoomState.create(1.0f, 1.0f, 1.0f, 0.0f));
        }
        return this.mCameraInfo.getZoomState();
    }

    @Override
    @NonNull
    public ExposureState getExposureState() {
        if (!this.mRestrictedCameraControl.isOperationSupported(7)) {
            return new ExposureState(){

                @Override
                public int getExposureCompensationIndex() {
                    return 0;
                }

                @Override
                @NonNull
                public Range<Integer> getExposureCompensationRange() {
                    return new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
                }

                @Override
                @NonNull
                public Rational getExposureCompensationStep() {
                    return Rational.ZERO;
                }

                @Override
                public boolean isExposureCompensationSupported() {
                    return false;
                }
            };
        }
        return this.mCameraInfo.getExposureState();
    }

    @Override
    public boolean isFocusMeteringSupported(@NonNull FocusMeteringAction action) {
        if (this.mRestrictedCameraControl.getModifiedFocusMeteringAction(action) == null) {
            return false;
        }
        return this.mCameraInfo.isFocusMeteringSupported(action);
    }

    public void setPostviewSupported(boolean isPostviewSupported) {
        this.mIsPostviewSupported = isPostviewSupported;
    }

    public void setCaptureProcessProgressSupported(boolean isCaptureProcessProgressSupported) {
        this.mIsCaptureProcessProgressSupported = isCaptureProcessProgressSupported;
    }

    @Override
    public boolean isPostviewSupported() {
        return this.mIsPostviewSupported;
    }

    @Override
    public boolean isCaptureProcessProgressSupported() {
        return this.mIsCaptureProcessProgressSupported;
    }
}

