/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.compat;

import android.media.EncoderProfiles;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.EncoderProfilesProxy;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=31)
class EncoderProfilesProxyCompatApi31Impl {
    @NonNull
    public static EncoderProfilesProxy from(@NonNull EncoderProfiles encoderProfiles) {
        return EncoderProfilesProxy.ImmutableEncoderProfilesProxy.create(encoderProfiles.getDefaultDurationSeconds(), encoderProfiles.getRecommendedFileFormat(), EncoderProfilesProxyCompatApi31Impl.fromAudioProfiles(encoderProfiles.getAudioProfiles()), EncoderProfilesProxyCompatApi31Impl.fromVideoProfiles(encoderProfiles.getVideoProfiles()));
    }

    @NonNull
    private static List<EncoderProfilesProxy.VideoProfileProxy> fromVideoProfiles(@NonNull List<EncoderProfiles.VideoProfile> profiles) {
        ArrayList<EncoderProfilesProxy.VideoProfileProxy> proxies = new ArrayList<EncoderProfilesProxy.VideoProfileProxy>();
        for (EncoderProfiles.VideoProfile profile : profiles) {
            proxies.add(EncoderProfilesProxy.VideoProfileProxy.create(profile.getCodec(), profile.getMediaType(), profile.getBitrate(), profile.getFrameRate(), profile.getWidth(), profile.getHeight(), profile.getProfile(), 8, 0, 0));
        }
        return proxies;
    }

    @NonNull
    private static List<EncoderProfilesProxy.AudioProfileProxy> fromAudioProfiles(@NonNull List<EncoderProfiles.AudioProfile> profiles) {
        ArrayList<EncoderProfilesProxy.AudioProfileProxy> proxies = new ArrayList<EncoderProfilesProxy.AudioProfileProxy>();
        for (EncoderProfiles.AudioProfile profile : profiles) {
            proxies.add(EncoderProfilesProxy.AudioProfileProxy.create(profile.getCodec(), profile.getMediaType(), profile.getBitrate(), profile.getSampleRate(), profile.getChannels(), profile.getProfile()));
        }
        return proxies;
    }

    private EncoderProfilesProxyCompatApi31Impl() {
    }
}

