/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils.executor;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=21)
final class HandlerScheduledExecutorService
extends AbstractExecutorService
implements ScheduledExecutorService {
    private static ThreadLocal<ScheduledExecutorService> sThreadLocalInstance = new ThreadLocal<ScheduledExecutorService>(){

        @Override
        public ScheduledExecutorService initialValue() {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                return CameraXExecutors.mainThreadExecutor();
            }
            if (Looper.myLooper() != null) {
                Handler handler = new Handler(Looper.myLooper());
                return new HandlerScheduledExecutorService(handler);
            }
            return null;
        }
    };
    private final Handler mHandler;

    HandlerScheduledExecutorService(@NonNull Handler handler) {
        this.mHandler = handler;
    }

    static ScheduledExecutorService currentThreadExecutor() {
        ScheduledExecutorService executor = sThreadLocalInstance.get();
        if (executor == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalStateException("Current thread has no looper!");
            }
            executor = new HandlerScheduledExecutorService(new Handler(looper));
            sThreadLocalInstance.set(executor);
        }
        return executor;
    }

    @Override
    public ScheduledFuture<?> schedule(final @NonNull Runnable command, long delay, @NonNull TimeUnit unit) {
        Callable<Void> wrapper = new Callable<Void>(){

            @Override
            public Void call() {
                command.run();
                return null;
            }
        };
        return this.schedule(wrapper, delay, unit);
    }

    @Override
    @NonNull
    public <V> ScheduledFuture<V> schedule(@NonNull Callable<V> callable, long delay, @NonNull TimeUnit unit) {
        long runAtMillis = SystemClock.uptimeMillis() + TimeUnit.MILLISECONDS.convert(delay, unit);
        HandlerScheduledFuture<V> future = new HandlerScheduledFuture<V>(this.mHandler, runAtMillis, callable);
        if (this.mHandler.postAtTime(future, runAtMillis)) {
            return future;
        }
        return Futures.immediateFailedScheduledFuture(this.createPostFailedException());
    }

    @Override
    @NonNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NonNull Runnable command, long initialDelay, long period, @NonNull TimeUnit unit) {
        throw new UnsupportedOperationException(HandlerScheduledExecutorService.class.getSimpleName() + " does not yet support fixed-rate scheduling.");
    }

    @Override
    @NonNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NonNull Runnable command, long initialDelay, long delay, @NonNull TimeUnit unit) {
        throw new UnsupportedOperationException(HandlerScheduledExecutorService.class.getSimpleName() + " does not yet support fixed-delay scheduling.");
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException(HandlerScheduledExecutorService.class.getSimpleName() + " cannot be shut down. Use Looper.quitSafely().");
    }

    @Override
    @NonNull
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException(HandlerScheduledExecutorService.class.getSimpleName() + " cannot be shut down. Use Looper.quitSafely().");
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, @NonNull TimeUnit unit) {
        throw new UnsupportedOperationException(HandlerScheduledExecutorService.class.getSimpleName() + " cannot be shut down. Use Looper.quitSafely().");
    }

    @Override
    public void execute(@NonNull Runnable command) {
        if (!this.mHandler.post(command)) {
            throw this.createPostFailedException();
        }
    }

    private RejectedExecutionException createPostFailedException() {
        return new RejectedExecutionException(this.mHandler + " is shutting down");
    }

    private static class HandlerScheduledFuture<V>
    implements RunnableScheduledFuture<V> {
        final AtomicReference<CallbackToFutureAdapter.Completer<V>> mCompleter = new AtomicReference<Object>(null);
        private final long mRunAtMillis;
        private final Callable<V> mTask;
        private final ListenableFuture<V> mDelegate;

        HandlerScheduledFuture(final Handler handler, long runAtMillis, final Callable<V> task) {
            this.mRunAtMillis = runAtMillis;
            this.mTask = task;
            this.mDelegate = CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<V>(){

                public Object attachCompleter(@NonNull CallbackToFutureAdapter.Completer<V> completer) throws RejectedExecutionException {
                    completer.addCancellationListener(new Runnable(){

                        @Override
                        public void run() {
                            if (mCompleter.getAndSet(null) != null) {
                                handler.removeCallbacks((Runnable)this);
                            }
                        }
                    }, CameraXExecutors.directExecutor());
                    mCompleter.set(completer);
                    return "HandlerScheduledFuture-" + task.toString();
                }
            });
        }

        @Override
        public boolean isPeriodic() {
            return false;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.mRunAtMillis - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
        }

        @Override
        public void run() {
            CallbackToFutureAdapter.Completer completer = this.mCompleter.getAndSet(null);
            if (completer != null) {
                try {
                    completer.set(this.mTask.call());
                }
                catch (Exception e) {
                    completer.setException((Throwable)e);
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.mDelegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.mDelegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.mDelegate.isDone();
        }

        @Override
        public V get() throws ExecutionException, InterruptedException {
            return (V)this.mDelegate.get();
        }

        @Override
        public V get(long timeout, @NonNull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            return (V)this.mDelegate.get(timeout, unit);
        }
    }
}

