/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.utils;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.CameraOrientationUtil;

@RequiresApi(value=21)
public final class UseCaseConfigUtil {
    private UseCaseConfigUtil() {
    }

    public static void updateTargetRotationAndRelatedConfigs(@NonNull UseCaseConfig.Builder<?, ?, ?> builder, int newRotation) {
        Size targetResolution;
        ImageOutputConfig config = (ImageOutputConfig)builder.getUseCaseConfig();
        int oldRotation = config.getTargetRotation(-1);
        if (oldRotation == -1 || oldRotation != newRotation) {
            ((ImageOutputConfig.Builder)((Object)builder)).setTargetRotation(newRotation);
        }
        if (oldRotation == -1 || newRotation == -1 || oldRotation == newRotation) {
            return;
        }
        int oldRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(oldRotation);
        int newRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(newRotation);
        if (Math.abs(newRotationDegrees - oldRotationDegrees) % 180 == 90 && (targetResolution = config.getTargetResolution(null)) != null) {
            ((ImageOutputConfig.Builder)((Object)builder)).setTargetResolution(new Size(targetResolution.getHeight(), targetResolution.getWidth()));
        }
    }
}

