/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import android.util.Pair;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.UseCaseConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@RequiresApi(api=21)
class ResolutionUtils {
    private ResolutionUtils() {
    }

    static List<Size> getMergedResolutions(@NonNull List<Size> cameraSupportedResolutions, @NonNull Size sensorSize, @NonNull MutableConfig parentConfig, @NonNull Set<UseCaseConfig<?>> childrenConfigs) {
        List parentSupportedResolutions;
        List<Size> result = ResolutionUtils.mergeChildrenResolutions(childrenConfigs);
        if (result == null) {
            result = cameraSupportedResolutions;
        }
        if ((parentSupportedResolutions = (List)parentConfig.retrieveOption(ImageOutputConfig.OPTION_SUPPORTED_RESOLUTIONS, null)) != null) {
            result = ResolutionUtils.filterOutUnsupportedResolutions(result, parentSupportedResolutions, 34);
        }
        return result;
    }

    @Nullable
    private static List<Size> mergeChildrenResolutions(@NonNull Set<UseCaseConfig<?>> childrenConfigs) {
        for (UseCaseConfig<?> childConfig : childrenConfigs) {
            List customOrderedResolutions = childConfig.retrieveOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS, null);
            if (customOrderedResolutions == null) continue;
            return customOrderedResolutions;
        }
        return null;
    }

    @NonNull
    private static List<Size> filterOutUnsupportedResolutions(@NonNull List<Size> resolutionsToFilter, @NonNull List<Pair<Integer, Size[]>> supportedResolutions, int format) {
        HashSet<Object> resolutionsToKeep = new HashSet();
        for (Pair<Integer, Size[]> pair : supportedResolutions) {
            if (!((Integer)pair.first).equals(format)) continue;
            resolutionsToKeep = new HashSet<Size>(Arrays.asList((Size[])pair.second));
            break;
        }
        ArrayList<Size> result = new ArrayList<Size>();
        for (Size resolution : resolutionsToFilter) {
            if (!resolutionsToKeep.contains(resolution)) continue;
            result.add(resolution);
        }
        return result;
    }
}

