/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.internal.SupportedOutputSizesSorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@RequiresApi(value=21)
public class ResolutionsMerger {
    private static final String TAG = "ResolutionsMerger";
    private static final double SAME_AREA_WIDTH_HEIGHT_RATIO = Math.sqrt(2.3703703703703702);
    @NonNull
    private final Rational mSensorAspectRatio;
    @NonNull
    private final Rational mFallbackAspectRatio;
    @NonNull
    private final Set<UseCaseConfig<?>> mChildrenConfigs;
    @NonNull
    private final SupportedOutputSizesSorter mSizeSorter;
    @NonNull
    private final List<Size> mCameraSupportedSizes;
    @NonNull
    private final Map<UseCaseConfig<?>, List<Size>> mChildSizesCache = new HashMap();

    ResolutionsMerger(@NonNull CameraInternal cameraInternal, @NonNull Set<UseCaseConfig<?>> childrenConfigs) {
        this(TransformUtils.rectToSize(cameraInternal.getCameraControlInternal().getSensorRect()), cameraInternal.getCameraInfoInternal(), childrenConfigs);
    }

    private ResolutionsMerger(@NonNull Size sensorSize, @NonNull CameraInfoInternal cameraInfo, @NonNull Set<UseCaseConfig<?>> childrenConfigs) {
        this(sensorSize, childrenConfigs, new SupportedOutputSizesSorter(cameraInfo, sensorSize), cameraInfo.getSupportedResolutions(34));
    }

    @VisibleForTesting
    ResolutionsMerger(@NonNull Size sensorSize, @NonNull Set<UseCaseConfig<?>> childrenConfigs, @NonNull SupportedOutputSizesSorter supportedOutputSizesSorter, @NonNull List<Size> cameraSupportedResolutions) {
        this.mSensorAspectRatio = ResolutionsMerger.getSensorAspectRatio(sensorSize);
        this.mFallbackAspectRatio = ResolutionsMerger.getFallbackAspectRatio(this.mSensorAspectRatio);
        this.mChildrenConfigs = childrenConfigs;
        this.mSizeSorter = supportedOutputSizesSorter;
        this.mCameraSupportedSizes = cameraSupportedResolutions;
    }

    @NonNull
    List<Size> getMergedResolutions(@NonNull MutableConfig parentConfig) {
        List<Size> candidateSizes = this.mCameraSupportedSizes;
        List parentSupportedSizesMap = parentConfig.retrieveOption(ImageOutputConfig.OPTION_SUPPORTED_RESOLUTIONS, null);
        if (parentSupportedSizesMap != null) {
            candidateSizes = ResolutionsMerger.getSupportedPrivResolutions(parentSupportedSizesMap);
        }
        return this.mergeChildrenResolutions(candidateSizes);
    }

    @NonNull
    Size getPreferredChildSize(@NonNull Size parentSize, @NonNull UseCaseConfig<?> childConfig) {
        boolean isParentCropped = !this.isSensorAspectRatio(parentSize);
        List<Size> candidateChildSizes = this.getSortedChildSizes(childConfig);
        for (Size childSize : candidateChildSizes) {
            boolean needAnotherCropping;
            if (isParentCropped && (needAnotherCropping = !this.isFallbackAspectRatio(parentSize) || !this.isFallbackAspectRatio(childSize)) || ResolutionsMerger.hasUpscaling(childSize, parentSize)) continue;
            return childSize;
        }
        return parentSize;
    }

    @NonNull
    private List<Size> mergeChildrenResolutions(@NonNull List<Size> candidateParentResolutions) {
        ArrayList<Size> result = new ArrayList<Size>();
        if (this.needToAddSensorResolutions()) {
            result.addAll(this.mergeChildrenResolutionsByAspectRatio(this.mSensorAspectRatio, candidateParentResolutions));
        }
        if (this.needToAddFallbackResolutions()) {
            result.addAll(this.mergeChildrenResolutionsByAspectRatio(this.mFallbackAspectRatio, candidateParentResolutions));
        }
        Logger.d(TAG, "Parent resolutions: " + result);
        return result;
    }

    private List<Size> mergeChildrenResolutionsByAspectRatio(@NonNull Rational aspectRatio, @NonNull List<Size> candidateParentResolutions) {
        List<Size> candidates = ResolutionsMerger.filterResolutionsByAspectRatio(aspectRatio, candidateParentResolutions);
        ResolutionsMerger.sortInDescendingOrder(candidates);
        HashSet<Size> sizesTooLarge = new HashSet<Size>(candidates);
        for (UseCaseConfig<?> childConfig : this.mChildrenConfigs) {
            List<Size> childSizes = this.getSortedChildSizes(childConfig);
            candidates = ResolutionsMerger.filterOutParentSizeThatIsTooSmall(childSizes, candidates);
            sizesTooLarge.retainAll(ResolutionsMerger.getParentSizesThatAreTooLarge(childSizes, candidates));
        }
        ArrayList<Size> result = new ArrayList<Size>();
        for (Size candidate : candidates) {
            if (sizesTooLarge.contains(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    @NonNull
    private List<Size> getSortedChildSizes(@NonNull UseCaseConfig<?> childConfig) {
        if (!this.mChildrenConfigs.contains(childConfig)) {
            throw new IllegalArgumentException("Invalid child config: " + childConfig);
        }
        if (this.mChildSizesCache.containsKey(childConfig)) {
            return Objects.requireNonNull(this.mChildSizesCache.get(childConfig));
        }
        List<Size> childSizes = this.mSizeSorter.getSortedSupportedOutputSizes(childConfig);
        if (childSizes.isEmpty()) {
            throw new IllegalArgumentException("No supported resolution for child config: " + childConfig);
        }
        this.mChildSizesCache.put(childConfig, childSizes);
        return childSizes;
    }

    private boolean needToAddSensorResolutions() {
        for (Size size : this.getChildrenRequiredResolutions()) {
            if (AspectRatioUtil.hasMatchingAspectRatio(size, this.mFallbackAspectRatio)) continue;
            return true;
        }
        return false;
    }

    private boolean needToAddFallbackResolutions() {
        for (Size size : this.getChildrenRequiredResolutions()) {
            if (!AspectRatioUtil.hasMatchingAspectRatio(size, this.mFallbackAspectRatio)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    private Set<Size> getChildrenRequiredResolutions() {
        HashSet<Size> result = new HashSet<Size>();
        for (UseCaseConfig<?> childConfig : this.mChildrenConfigs) {
            List<Size> childSizes = this.getSortedChildSizes(childConfig);
            result.addAll(childSizes);
        }
        return result;
    }

    private boolean isSensorAspectRatio(@NonNull Size size) {
        return AspectRatioUtil.hasMatchingAspectRatio(size, this.mSensorAspectRatio);
    }

    private boolean isFallbackAspectRatio(@NonNull Size size) {
        return AspectRatioUtil.hasMatchingAspectRatio(size, this.mFallbackAspectRatio);
    }

    @NonNull
    private static List<Size> getSupportedPrivResolutions(@NonNull List<Pair<Integer, Size[]>> supportedResolutionsMap) {
        for (Pair<Integer, Size[]> pair : supportedResolutionsMap) {
            if (!((Integer)pair.first).equals(34)) continue;
            return Arrays.asList((Size[])pair.second);
        }
        return new ArrayList<Size>();
    }

    @NonNull
    private static Rational getSensorAspectRatio(@NonNull Size sensorSize) {
        Rational result = ResolutionsMerger.findCloserAspectRatio(sensorSize);
        Logger.d(TAG, "The closer aspect ratio to the sensor size (" + sensorSize + ") is " + result + ".");
        return result;
    }

    @NonNull
    private static Rational findCloserAspectRatio(@NonNull Size size) {
        double widthHeightRatio = (double)size.getWidth() / (double)size.getHeight();
        if (widthHeightRatio > SAME_AREA_WIDTH_HEIGHT_RATIO) {
            return AspectRatioUtil.ASPECT_RATIO_16_9;
        }
        return AspectRatioUtil.ASPECT_RATIO_4_3;
    }

    @NonNull
    private static Rational getFallbackAspectRatio(@NonNull Rational sensorAspectRatio) {
        if (sensorAspectRatio.equals((Object)AspectRatioUtil.ASPECT_RATIO_4_3)) {
            return AspectRatioUtil.ASPECT_RATIO_16_9;
        }
        if (sensorAspectRatio.equals((Object)AspectRatioUtil.ASPECT_RATIO_16_9)) {
            return AspectRatioUtil.ASPECT_RATIO_4_3;
        }
        throw new IllegalArgumentException("Invalid sensor aspect-ratio: " + sensorAspectRatio);
    }

    @VisibleForTesting
    static void sortInDescendingOrder(@NonNull List<Size> resolutions) {
        Collections.sort(resolutions, new CompareSizesByArea(true));
    }

    @VisibleForTesting
    @NonNull
    static List<Size> filterResolutionsByAspectRatio(@NonNull Rational aspectRatio, @NonNull List<Size> resolutionsToFilter) {
        ArrayList<Size> result = new ArrayList<Size>();
        for (Size resolution : resolutionsToFilter) {
            if (!AspectRatioUtil.hasMatchingAspectRatio(resolution, aspectRatio)) continue;
            result.add(resolution);
        }
        return result;
    }

    @VisibleForTesting
    @NonNull
    static List<Size> filterOutParentSizeThatIsTooSmall(@NonNull Collection<Size> childSizes, @NonNull List<Size> sortedParentSizes) {
        int n = sortedParentSizes.size();
        int lo = 0;
        int hi = n - 1;
        while (lo < hi) {
            int mid = lo + (hi - lo + 1) / 2;
            Size parentSize = sortedParentSizes.get(mid);
            if (ResolutionsMerger.isAnyChildSizeCanBeCroppedOutWithoutUpscalingParent(childSizes, parentSize)) {
                lo = mid;
                continue;
            }
            hi = mid - 1;
        }
        ArrayList<Size> result = new ArrayList<Size>();
        for (int i = 0; i <= lo; ++i) {
            result.add(sortedParentSizes.get(i));
        }
        return result;
    }

    private static boolean isAnyChildSizeCanBeCroppedOutWithoutUpscalingParent(@NonNull Collection<Size> childSizes, @NonNull Size parentSize) {
        for (Size childSize : childSizes) {
            if (ResolutionsMerger.hasUpscaling(childSize, parentSize)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @NonNull
    static List<Size> getParentSizesThatAreTooLarge(@NonNull Collection<Size> childSizes, @NonNull List<Size> sortedParentSizes) {
        int n = sortedParentSizes.size();
        int lo = 0;
        int hi = n - 1;
        while (lo < hi) {
            int mid = lo + (hi - lo + 1) / 2;
            Size parentSize = sortedParentSizes.get(mid);
            if (ResolutionsMerger.isAllChildSizesCanBeCroppedOutWithoutUpscalingParent(childSizes, parentSize)) {
                lo = mid;
                continue;
            }
            hi = mid - 1;
        }
        ArrayList<Size> result = new ArrayList<Size>();
        for (int i = 0; i < lo; ++i) {
            result.add(sortedParentSizes.get(i));
        }
        return result;
    }

    private static boolean isAllChildSizesCanBeCroppedOutWithoutUpscalingParent(@NonNull Collection<Size> childSizes, @NonNull Size parentSize) {
        for (Size childSize : childSizes) {
            if (!ResolutionsMerger.hasUpscaling(childSize, parentSize)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean hasUpscaling(@NonNull Size childSize, @NonNull Size parentSize) {
        return childSize.getHeight() > parentSize.getHeight() || childSize.getWidth() > parentSize.getWidth();
    }
}

