/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import android.util.Size;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.SurfaceProcessorNode;
import androidx.camera.core.streamsharing.DynamicRangeUtils;
import androidx.camera.core.streamsharing.ResolutionUtils;
import androidx.camera.core.streamsharing.StreamSharing;
import androidx.camera.core.streamsharing.VirtualCamera;
import androidx.camera.core.streamsharing.VirtualCameraCaptureResult;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@RequiresApi(api=21)
class VirtualCameraAdapter
implements UseCase.StateChangeCallback {
    @NonNull
    final Set<UseCase> mChildren;
    @NonNull
    final Map<UseCase, SurfaceEdge> mChildrenEdges = new HashMap<UseCase, SurfaceEdge>();
    @NonNull
    private final Map<UseCase, VirtualCamera> mChildrenVirtualCameras = new HashMap<UseCase, VirtualCamera>();
    @NonNull
    final Map<UseCase, Boolean> mChildrenActiveState = new HashMap<UseCase, Boolean>();
    @NonNull
    private final UseCaseConfigFactory mUseCaseConfigFactory;
    @NonNull
    private final CameraInternal mParentCamera;
    @NonNull
    private final CameraCaptureCallback mParentMetadataCallback = this.createCameraCaptureCallback();

    VirtualCameraAdapter(@NonNull CameraInternal parentCamera, @NonNull Set<UseCase> children, @NonNull UseCaseConfigFactory useCaseConfigFactory, @NonNull StreamSharing.Control streamSharingControl) {
        this.mParentCamera = parentCamera;
        this.mUseCaseConfigFactory = useCaseConfigFactory;
        this.mChildren = children;
        for (UseCase child : children) {
            this.mChildrenActiveState.put(child, false);
            this.mChildrenVirtualCameras.put(child, new VirtualCamera(parentCamera, this, streamSharingControl));
        }
    }

    void mergeChildrenConfigs(@NonNull MutableConfig mutableConfig) {
        HashSet childrenConfigs = new HashSet();
        for (UseCase useCase : this.mChildren) {
            childrenConfigs.add(useCase.mergeConfigs(this.mParentCamera.getCameraInfoInternal(), null, useCase.getDefaultConfig(true, this.mUseCaseConfigFactory)));
        }
        ArrayList<Size> cameraSupportedResolutions = new ArrayList<Size>(this.mParentCamera.getCameraInfoInternal().getSupportedResolutions(34));
        Size sensorSize = TransformUtils.rectToSize(this.mParentCamera.getCameraControlInternal().getSensorRect());
        List<Size> mergedResolutions = ResolutionUtils.getMergedResolutions(cameraSupportedResolutions, sensorSize, mutableConfig, childrenConfigs);
        mutableConfig.insertOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS, mergedResolutions);
        mutableConfig.insertOption(UseCaseConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, VirtualCameraAdapter.getHighestSurfacePriority(childrenConfigs));
        DynamicRange dynamicRange = DynamicRangeUtils.resolveDynamicRange(childrenConfigs);
        if (dynamicRange == null) {
            throw new IllegalArgumentException("Failed to merge child dynamic ranges, can not find a dynamic range that satisfies all children.");
        }
        mutableConfig.insertOption(ImageInputConfig.OPTION_INPUT_DYNAMIC_RANGE, dynamicRange);
        for (UseCase useCase : this.mChildren) {
            if (useCase.getCurrentConfig().getVideoStabilizationMode() != 0) {
                mutableConfig.insertOption(UseCaseConfig.OPTION_VIDEO_STABILIZATION_MODE, useCase.getCurrentConfig().getVideoStabilizationMode());
            }
            if (useCase.getCurrentConfig().getPreviewStabilizationMode() == 0) continue;
            mutableConfig.insertOption(UseCaseConfig.OPTION_PREVIEW_STABILIZATION_MODE, useCase.getCurrentConfig().getPreviewStabilizationMode());
        }
    }

    void bindChildren() {
        for (UseCase useCase : this.mChildren) {
            useCase.bindToCamera(Objects.requireNonNull(this.mChildrenVirtualCameras.get(useCase)), null, useCase.getDefaultConfig(true, this.mUseCaseConfigFactory));
        }
    }

    void unbindChildren() {
        for (UseCase useCase : this.mChildren) {
            useCase.unbindFromCamera(Objects.requireNonNull(this.mChildrenVirtualCameras.get(useCase)));
        }
    }

    void notifyStateAttached() {
        for (UseCase useCase : this.mChildren) {
            useCase.onStateAttached();
        }
    }

    void notifyStateDetached() {
        for (UseCase useCase : this.mChildren) {
            useCase.onStateDetached();
        }
    }

    @NonNull
    Set<UseCase> getChildren() {
        return this.mChildren;
    }

    @NonNull
    Map<UseCase, SurfaceProcessorNode.OutConfig> getChildrenOutConfigs(@NonNull SurfaceEdge cameraEdge, int parentTargetRotation) {
        HashMap<UseCase, SurfaceProcessorNode.OutConfig> outConfigs = new HashMap<UseCase, SurfaceProcessorNode.OutConfig>();
        int parentRotationDegrees = this.mParentCamera.getCameraInfo().getSensorRotationDegrees(parentTargetRotation);
        for (UseCase useCase : this.mChildren) {
            int childRotationDegrees = this.getChildRotationDegrees(useCase);
            Objects.requireNonNull(this.mChildrenVirtualCameras.get(useCase)).setRotationDegrees(childRotationDegrees);
            int childParentDelta = TransformUtils.within360(cameraEdge.getRotationDegrees() + childRotationDegrees - parentRotationDegrees);
            outConfigs.put(useCase, SurfaceProcessorNode.OutConfig.of(VirtualCameraAdapter.getChildTargetType(useCase), VirtualCameraAdapter.getChildFormat(useCase), cameraEdge.getCropRect(), TransformUtils.getRotatedSize(cameraEdge.getCropRect(), childParentDelta), childParentDelta, useCase.isMirroringRequired(this.mParentCamera)));
        }
        return outConfigs;
    }

    void setChildrenEdges(@NonNull Map<UseCase, SurfaceEdge> childrenEdges) {
        this.mChildrenEdges.clear();
        this.mChildrenEdges.putAll(childrenEdges);
        for (Map.Entry<UseCase, SurfaceEdge> entry : this.mChildrenEdges.entrySet()) {
            UseCase useCase = entry.getKey();
            SurfaceEdge surfaceEdge = entry.getValue();
            useCase.setViewPortCropRect(surfaceEdge.getCropRect());
            useCase.setSensorToBufferTransformMatrix(surfaceEdge.getSensorToBufferTransform());
            useCase.updateSuggestedStreamSpec(surfaceEdge.getStreamSpec());
            useCase.notifyState();
        }
    }

    void resetChildren() {
        Threads.checkMainThread();
        for (UseCase useCase : this.mChildren) {
            this.onUseCaseReset(useCase);
        }
    }

    @NonNull
    CameraCaptureCallback getParentMetadataCallback() {
        return this.mParentMetadataCallback;
    }

    @Override
    @MainThread
    public void onUseCaseActive(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        if (this.isUseCaseActive(useCase)) {
            return;
        }
        this.mChildrenActiveState.put(useCase, true);
        DeferrableSurface childSurface = VirtualCameraAdapter.getChildSurface(useCase);
        if (childSurface != null) {
            VirtualCameraAdapter.forceSetProvider(this.getUseCaseEdge(useCase), childSurface, useCase.getSessionConfig());
        }
    }

    @Override
    @MainThread
    public void onUseCaseInactive(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        if (!this.isUseCaseActive(useCase)) {
            return;
        }
        this.mChildrenActiveState.put(useCase, false);
        this.getUseCaseEdge(useCase).disconnect();
    }

    @Override
    @MainThread
    public void onUseCaseUpdated(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        if (!this.isUseCaseActive(useCase)) {
            return;
        }
        SurfaceEdge edge = this.getUseCaseEdge(useCase);
        DeferrableSurface childSurface = VirtualCameraAdapter.getChildSurface(useCase);
        if (childSurface != null) {
            VirtualCameraAdapter.forceSetProvider(edge, childSurface, useCase.getSessionConfig());
        } else {
            edge.disconnect();
        }
    }

    @Override
    @MainThread
    public void onUseCaseReset(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        SurfaceEdge edge = this.getUseCaseEdge(useCase);
        edge.invalidate();
        if (!this.isUseCaseActive(useCase)) {
            return;
        }
        DeferrableSurface childSurface = VirtualCameraAdapter.getChildSurface(useCase);
        if (childSurface != null) {
            VirtualCameraAdapter.forceSetProvider(edge, childSurface, useCase.getSessionConfig());
        }
    }

    @IntRange(from=0L, to=359L)
    private int getChildRotationDegrees(@NonNull UseCase child) {
        int childTargetRotation = ((ImageOutputConfig)((Object)child.getCurrentConfig())).getTargetRotation(0);
        return this.mParentCamera.getCameraInfo().getSensorRotationDegrees(childTargetRotation);
    }

    private static int getChildFormat(@NonNull UseCase useCase) {
        return useCase instanceof ImageCapture ? 256 : 34;
    }

    private static int getChildTargetType(@NonNull UseCase useCase) {
        if (useCase instanceof Preview) {
            return 1;
        }
        if (useCase instanceof ImageCapture) {
            return 4;
        }
        return 2;
    }

    private static int getHighestSurfacePriority(Set<UseCaseConfig<?>> childrenConfigs) {
        int highestPriority = 0;
        for (UseCaseConfig<?> childConfig : childrenConfigs) {
            highestPriority = Math.max(highestPriority, childConfig.getSurfaceOccupancyPriority(0));
        }
        return highestPriority;
    }

    @NonNull
    private SurfaceEdge getUseCaseEdge(@NonNull UseCase useCase) {
        return Objects.requireNonNull(this.mChildrenEdges.get(useCase));
    }

    private boolean isUseCaseActive(@NonNull UseCase useCase) {
        return Objects.requireNonNull(this.mChildrenActiveState.get(useCase));
    }

    private static void forceSetProvider(@NonNull SurfaceEdge edge, @NonNull DeferrableSurface childSurface, @NonNull SessionConfig childSessionConfig) {
        edge.invalidate();
        try {
            edge.setProvider(childSurface);
        }
        catch (DeferrableSurface.SurfaceClosedException e) {
            for (SessionConfig.ErrorListener listener : childSessionConfig.getErrorListeners()) {
                listener.onError(childSessionConfig, SessionConfig.SessionError.SESSION_ERROR_SURFACE_NEEDS_RESET);
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static DeferrableSurface getChildSurface(@NonNull UseCase child) {
        List<DeferrableSurface> surfaces = child instanceof ImageCapture ? child.getSessionConfig().getSurfaces() : child.getSessionConfig().getRepeatingCaptureConfig().getSurfaces();
        Preconditions.checkState((surfaces.size() <= 1 ? 1 : 0) != 0);
        if (surfaces.size() == 1) {
            return surfaces.get(0);
        }
        return null;
    }

    CameraCaptureCallback createCameraCaptureCallback() {
        return new CameraCaptureCallback(){

            @Override
            public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
                super.onCaptureCompleted(cameraCaptureResult);
                for (UseCase child : VirtualCameraAdapter.this.mChildren) {
                    VirtualCameraAdapter.sendCameraCaptureResultToChild(cameraCaptureResult, child.getSessionConfig());
                }
            }
        };
    }

    static void sendCameraCaptureResultToChild(@NonNull CameraCaptureResult cameraCaptureResult, @NonNull SessionConfig sessionConfig) {
        for (CameraCaptureCallback callback : sessionConfig.getRepeatingCameraCaptureCallbacks()) {
            callback.onCaptureCompleted(new VirtualCameraCaptureResult(sessionConfig.getRepeatingCaptureConfig().getTagBundle(), cameraCaptureResult));
        }
    }
}

