/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.media.Image;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import androidx.camera.camera2.impl.Camera2CameraCaptureResultConverter;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraCaptureResults;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.ImageProxyBundle;
import androidx.camera.extensions.impl.CaptureProcessorImpl;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class AdaptingCaptureProcessor
implements CaptureProcessor {
    private final CaptureProcessorImpl mImpl;

    AdaptingCaptureProcessor(CaptureProcessorImpl impl) {
        this.mImpl = impl;
    }

    public void onOutputSurface(Surface surface, int imageFormat) {
        this.mImpl.onOutputSurface(surface, imageFormat);
        this.mImpl.onImageFormatUpdate(imageFormat);
    }

    @ExperimentalGetImage
    public void process(ImageProxyBundle bundle) {
        List ids = bundle.getCaptureIds();
        HashMap<Integer, Pair> bundleMap = new HashMap<Integer, Pair>();
        for (Integer id : ids) {
            ListenableFuture imageProxyListenableFuture = bundle.getImageProxy(id.intValue());
            try {
                ImageProxy imageProxy = (ImageProxy)imageProxyListenableFuture.get(5L, TimeUnit.SECONDS);
                Image image = imageProxy.getImage();
                if (image == null) {
                    return;
                }
                ImageInfo imageInfo = imageProxy.getImageInfo();
                CameraCaptureResult result = CameraCaptureResults.retrieveCameraCaptureResult((ImageInfo)imageInfo);
                if (result == null) {
                    return;
                }
                CaptureResult captureResult = Camera2CameraCaptureResultConverter.getCaptureResult((CameraCaptureResult)result);
                if (captureResult == null) {
                    return;
                }
                TotalCaptureResult totalCaptureResult = (TotalCaptureResult)captureResult;
                if (totalCaptureResult == null) {
                    return;
                }
                Pair imageCapturePair = new Pair((Object)imageProxy.getImage(), (Object)totalCaptureResult);
                bundleMap.put(id, imageCapturePair);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                return;
            }
        }
        this.mImpl.process(bundleMap);
    }

    public void onResolutionUpdate(Size size) {
        this.mImpl.onResolutionUpdate(size);
    }
}

