/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.hardware.camera2.CaptureRequest;
import android.util.Pair;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.Config;
import androidx.camera.extensions.impl.CaptureStageImpl;

final class AdaptingCaptureStage
implements CaptureStage {
    private final CaptureConfig mCaptureRequestConfiguration;
    private final int mId;

    AdaptingCaptureStage(CaptureStageImpl impl) {
        this.mId = impl.getId();
        Camera2ImplConfig.Builder camera2ConfigurationBuilder = new Camera2ImplConfig.Builder();
        for (Pair captureParameter : impl.getParameters()) {
            camera2ConfigurationBuilder.setCaptureRequestOption((CaptureRequest.Key)captureParameter.first, captureParameter.second);
        }
        CaptureConfig.Builder captureConfigBuilder = new CaptureConfig.Builder();
        captureConfigBuilder.addImplementationOptions((Config)camera2ConfigurationBuilder.build());
        captureConfigBuilder.setTag((Object)this.mId);
        this.mCaptureRequestConfiguration = captureConfigBuilder.build();
    }

    public int getId() {
        return this.mId;
    }

    public CaptureConfig getCaptureConfig() {
        return this.mCaptureRequestConfiguration;
    }
}

