/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageCapture;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.ImageCaptureExtender;
import androidx.camera.extensions.impl.BeautyImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;

public class BeautyImageCaptureExtender
extends ImageCaptureExtender {
    private static final String TAG = "BeautyICExtender";

    public static BeautyImageCaptureExtender create(ImageCapture.Builder builder) {
        if (ExtensionVersion.isExtensionVersionSupported()) {
            try {
                return new VendorBeautyImageCaptureExtender(builder);
            }
            catch (NoClassDefFoundError e) {
                Log.d((String)TAG, (String)"No beauty image capture extender found. Falling back to default.");
            }
        }
        return new DefaultBeautyImageCaptureExtender();
    }

    private BeautyImageCaptureExtender() {
    }

    static class VendorBeautyImageCaptureExtender
    extends BeautyImageCaptureExtender {
        private final BeautyImageCaptureExtenderImpl mImpl = new BeautyImageCaptureExtenderImpl();

        VendorBeautyImageCaptureExtender(ImageCapture.Builder builder) {
            this.init(builder, (ImageCaptureExtenderImpl)this.mImpl, ExtensionsManager.EffectMode.BEAUTY);
        }
    }

    static class DefaultBeautyImageCaptureExtender
    extends BeautyImageCaptureExtender {
        DefaultBeautyImageCaptureExtender() {
        }

        @Override
        public boolean isExtensionAvailable(@NonNull CameraSelector selector) {
            return false;
        }

        @Override
        public void enableExtension(@NonNull CameraSelector selector) {
        }
    }
}

