/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Preview;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.impl.NightPreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;

public class NightPreviewExtender
extends PreviewExtender {
    private static final String TAG = "NightPreviewExtender";

    public static NightPreviewExtender create(Preview.Builder builder) {
        if (ExtensionVersion.isExtensionVersionSupported()) {
            try {
                return new VendorNightPreviewExtender(builder);
            }
            catch (NoClassDefFoundError e) {
                Log.d((String)TAG, (String)"No night preview extender found. Falling back to default.");
            }
        }
        return new DefaultNightPreviewExtender();
    }

    private NightPreviewExtender() {
    }

    static class VendorNightPreviewExtender
    extends NightPreviewExtender {
        private final NightPreviewExtenderImpl mImpl = new NightPreviewExtenderImpl();

        VendorNightPreviewExtender(Preview.Builder builder) {
            this.init(builder, (PreviewExtenderImpl)this.mImpl, ExtensionsManager.EffectMode.NIGHT);
        }
    }

    static class DefaultNightPreviewExtender
    extends NightPreviewExtender {
        DefaultNightPreviewExtender() {
        }

        @Override
        public boolean isExtensionAvailable(@NonNull CameraSelector selector) {
            return false;
        }

        @Override
        public void enableExtension(@NonNull CameraSelector selector) {
        }
    }
}

