/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.impl.HdrPreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;

public class HdrPreviewExtender
extends PreviewExtender {
    private static final String TAG = "HdrPreviewExtender";

    @NonNull
    public static HdrPreviewExtender create(@NonNull Preview.Builder builder) {
        if (ExtensionVersion.isExtensionVersionSupported()) {
            try {
                return new VendorHdrPreviewExtender(builder);
            }
            catch (NoClassDefFoundError e) {
                Logger.d((String)TAG, (String)"No HDR preview extender found. Falling back to default.");
            }
        }
        return new DefaultHdrPreviewExtender();
    }

    private HdrPreviewExtender() {
    }

    static class VendorHdrPreviewExtender
    extends HdrPreviewExtender {
        private final HdrPreviewExtenderImpl mImpl = new HdrPreviewExtenderImpl();

        VendorHdrPreviewExtender(Preview.Builder builder) {
            this.init(builder, (PreviewExtenderImpl)this.mImpl, ExtensionsManager.EffectMode.HDR);
        }
    }

    static class DefaultHdrPreviewExtender
    extends HdrPreviewExtender {
        DefaultHdrPreviewExtender() {
        }

        @Override
        public boolean isExtensionAvailable(@NonNull CameraSelector selector) {
            return false;
        }

        @Override
        public void enableExtension(@NonNull CameraSelector selector) {
        }
    }
}

