/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import androidx.annotation.NonNull;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.extensions.ExtensionVersion;
import androidx.camera.extensions.ExtensionsManager;
import androidx.camera.extensions.ImageCaptureExtender;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.NightImageCaptureExtenderImpl;

public class NightImageCaptureExtender
extends ImageCaptureExtender {
    private static final String TAG = "NightICExtender";

    @NonNull
    public static NightImageCaptureExtender create(@NonNull ImageCapture.Builder builder) {
        if (ExtensionVersion.isExtensionVersionSupported()) {
            try {
                return new VendorNightImageCaptureExtender(builder);
            }
            catch (NoClassDefFoundError e) {
                Logger.d((String)TAG, (String)"No night image capture extender found. Falling back to default.");
            }
        }
        return new DefaultNightImageCaptureExtender();
    }

    private NightImageCaptureExtender() {
    }

    static class VendorNightImageCaptureExtender
    extends NightImageCaptureExtender {
        private final NightImageCaptureExtenderImpl mImpl = new NightImageCaptureExtenderImpl();

        VendorNightImageCaptureExtender(ImageCapture.Builder builder) {
            this.init(builder, (ImageCaptureExtenderImpl)this.mImpl, ExtensionsManager.EffectMode.NIGHT);
        }
    }

    static class DefaultNightImageCaptureExtender
    extends NightImageCaptureExtender {
        DefaultNightImageCaptureExtender() {
        }

        @Override
        public boolean isExtensionAvailable(@NonNull CameraSelector selector) {
            return false;
        }

        @Override
        public void enableExtension(@NonNull CameraSelector selector) {
        }
    }
}

