/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.impl.CameraEventCallback;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.extensions.ImageCaptureExtender;
import androidx.camera.extensions.impl.AutoImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.BeautyImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.BokehImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.CaptureProcessorImpl;
import androidx.camera.extensions.impl.HdrImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.NightImageCaptureExtenderImpl;
import androidx.camera.extensions.internal.AdaptingCaptureProcessor;
import java.util.List;

public class ImageCaptureConfigProvider
implements ConfigProvider<ImageCaptureConfig> {
    private ImageCaptureExtenderImpl mImpl;
    private Context mContext;

    @UseExperimental(markerClass=ExperimentalCamera2Interop.class)
    public ImageCaptureConfigProvider(int mode, @NonNull CameraInfo cameraInfo, @NonNull Context context) {
        try {
            switch (mode) {
                case 1: {
                    this.mImpl = new BokehImageCaptureExtenderImpl();
                    break;
                }
                case 2: {
                    this.mImpl = new HdrImageCaptureExtenderImpl();
                    break;
                }
                case 3: {
                    this.mImpl = new NightImageCaptureExtenderImpl();
                    break;
                }
                case 4: {
                    this.mImpl = new BeautyImageCaptureExtenderImpl();
                    break;
                }
                case 5: {
                    this.mImpl = new AutoImageCaptureExtenderImpl();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalArgumentException("Extension mode does not exist: " + mode);
        }
        this.mContext = context;
        String cameraId = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraId();
        CameraCharacteristics cameraCharacteristics = Camera2CameraInfo.extractCameraCharacteristics((CameraInfo)cameraInfo);
        this.mImpl.init(cameraId, cameraCharacteristics);
    }

    @NonNull
    public ImageCaptureConfig getConfig() {
        if (this.mImpl == null) {
            return new ImageCaptureConfig(OptionsBundle.emptyBundle());
        }
        ImageCapture.Builder builder = new ImageCapture.Builder();
        CaptureProcessorImpl captureProcessor = this.mImpl.getCaptureProcessor();
        if (captureProcessor != null) {
            builder.setCaptureProcessor((CaptureProcessor)new AdaptingCaptureProcessor(captureProcessor));
        }
        if (this.mImpl.getMaxCaptureStage() > 0) {
            builder.setMaxCaptureStages(this.mImpl.getMaxCaptureStage());
        }
        ImageCaptureExtender.ImageCaptureAdapter imageCaptureAdapter = new ImageCaptureExtender.ImageCaptureAdapter(this.mImpl, this.mContext);
        new Camera2ImplConfig.Extender((ExtendableBuilder)builder).setCameraEventCallback(new CameraEventCallbacks(new CameraEventCallback[]{imageCaptureAdapter}));
        builder.setUseCaseEventCallback((UseCase.EventCallback)imageCaptureAdapter);
        builder.setCaptureBundle((CaptureBundle)imageCaptureAdapter);
        List<Pair<Integer, Size[]>> supportedResolutions = ImageCaptureExtender.getSupportedResolutions(this.mImpl);
        if (supportedResolutions != null) {
            builder.setSupportedResolutions(supportedResolutions);
        }
        return builder.getUseCaseConfig();
    }
}

