/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.extensions.Version;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class VersionName {
    private static final VersionName CURRENT = new VersionName("1.1.0");
    private final Version mVersion;

    @NonNull
    static VersionName getCurrentVersion() {
        return CURRENT;
    }

    public Version getVersion() {
        return this.mVersion;
    }

    VersionName(String versionString) {
        this.mVersion = Version.parse(versionString);
    }

    VersionName(int major, int minor, int patch, String description) {
        this.mVersion = Version.create(major, minor, patch, description);
    }

    public String toVersionString() {
        return this.mVersion.toString();
    }
}

