/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.Preview;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.PreviewConfig;
import androidx.camera.extensions.PreviewExtender;
import androidx.camera.extensions.impl.AutoPreviewExtenderImpl;
import androidx.camera.extensions.impl.BeautyPreviewExtenderImpl;
import androidx.camera.extensions.impl.BokehPreviewExtenderImpl;
import androidx.camera.extensions.impl.HdrPreviewExtenderImpl;
import androidx.camera.extensions.impl.NightPreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;

public class PreviewConfigProvider
implements ConfigProvider<PreviewConfig> {
    private PreviewExtenderImpl mImpl;
    private Context mContext;
    private int mEffectMode;

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public PreviewConfigProvider(int mode, @NonNull CameraInfo cameraInfo, @NonNull Context context) {
        try {
            switch (mode) {
                case 1: {
                    this.mImpl = new BokehPreviewExtenderImpl();
                    break;
                }
                case 2: {
                    this.mImpl = new HdrPreviewExtenderImpl();
                    break;
                }
                case 3: {
                    this.mImpl = new NightPreviewExtenderImpl();
                    break;
                }
                case 4: {
                    this.mImpl = new BeautyPreviewExtenderImpl();
                    break;
                }
                case 5: {
                    this.mImpl = new AutoPreviewExtenderImpl();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalArgumentException("Extension mode does not exist: " + mode);
        }
        this.mEffectMode = mode;
        this.mContext = context;
        String cameraId = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraId();
        CameraCharacteristics cameraCharacteristics = Camera2CameraInfo.extractCameraCharacteristics((CameraInfo)cameraInfo);
        this.mImpl.init(cameraId, cameraCharacteristics);
    }

    @NonNull
    public PreviewConfig getConfig() {
        if (this.mImpl == null) {
            return new PreviewConfig(OptionsBundle.emptyBundle());
        }
        Preview.Builder builder = new Preview.Builder();
        PreviewExtender.updateBuilderConfig(builder, this.mEffectMode, this.mImpl, this.mContext);
        return builder.getUseCaseConfig();
    }
}

