/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.util.Pair;
import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.extensions.impl.AutoImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.AutoPreviewExtenderImpl;
import androidx.camera.extensions.impl.BeautyImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.BeautyPreviewExtenderImpl;
import androidx.camera.extensions.impl.BokehImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.BokehPreviewExtenderImpl;
import androidx.camera.extensions.impl.HdrImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.HdrPreviewExtenderImpl;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.NightImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.NightPreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;
import androidx.camera.extensions.internal.ExtensionVersion;
import androidx.camera.extensions.internal.VendorExtender;
import androidx.camera.extensions.internal.Version;
import androidx.camera.extensions.internal.compat.workaround.AvailableKeysRetriever;
import androidx.camera.extensions.internal.compat.workaround.ExtensionDisabledValidator;
import androidx.camera.extensions.internal.compat.workaround.ImageAnalysisAvailability;
import androidx.camera.extensions.internal.sessionprocessor.BasicExtenderSessionProcessor;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@RequiresApi(value=21)
public class BasicVendorExtender
implements VendorExtender {
    private static final String TAG = "BasicVendorExtender";
    private final ExtensionDisabledValidator mExtensionDisabledValidator = new ExtensionDisabledValidator();
    private PreviewExtenderImpl mPreviewExtenderImpl = null;
    private ImageCaptureExtenderImpl mImageCaptureExtenderImpl = null;
    private CameraInfo mCameraInfo;
    private String mCameraId;
    private CameraCharacteristics mCameraCharacteristics;
    private AvailableKeysRetriever mAvailableKeysRetriever = new AvailableKeysRetriever();
    private int mMode = 0;
    static final List<CaptureRequest.Key> sBaseSupportedKeys = new ArrayList<CaptureRequest.Key>(Arrays.asList(CaptureRequest.SCALER_CROP_REGION, CaptureRequest.CONTROL_AF_MODE, CaptureRequest.CONTROL_AF_TRIGGER, CaptureRequest.CONTROL_AF_REGIONS, CaptureRequest.CONTROL_AE_REGIONS, CaptureRequest.CONTROL_AWB_REGIONS, CaptureRequest.CONTROL_AE_MODE, CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, CaptureRequest.FLASH_MODE, CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION));

    public BasicVendorExtender(int mode) {
        try {
            this.mMode = mode;
            switch (mode) {
                case 1: {
                    this.mPreviewExtenderImpl = new BokehPreviewExtenderImpl();
                    this.mImageCaptureExtenderImpl = new BokehImageCaptureExtenderImpl();
                    break;
                }
                case 2: {
                    this.mPreviewExtenderImpl = new HdrPreviewExtenderImpl();
                    this.mImageCaptureExtenderImpl = new HdrImageCaptureExtenderImpl();
                    break;
                }
                case 3: {
                    this.mPreviewExtenderImpl = new NightPreviewExtenderImpl();
                    this.mImageCaptureExtenderImpl = new NightImageCaptureExtenderImpl();
                    break;
                }
                case 4: {
                    this.mPreviewExtenderImpl = new BeautyPreviewExtenderImpl();
                    this.mImageCaptureExtenderImpl = new BeautyImageCaptureExtenderImpl();
                    break;
                }
                case 5: {
                    this.mPreviewExtenderImpl = new AutoPreviewExtenderImpl();
                    this.mImageCaptureExtenderImpl = new AutoImageCaptureExtenderImpl();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Should not activate ExtensionMode.NONE");
                }
            }
        }
        catch (NoClassDefFoundError e) {
            Logger.e((String)TAG, (String)("OEM implementation for extension mode " + mode + "does not exist!"));
        }
    }

    @VisibleForTesting
    BasicVendorExtender(ImageCaptureExtenderImpl imageCaptureExtenderImpl, PreviewExtenderImpl previewExtenderImpl) {
        this.mPreviewExtenderImpl = previewExtenderImpl;
        this.mImageCaptureExtenderImpl = imageCaptureExtenderImpl;
    }

    @Override
    public boolean isExtensionAvailable(@NonNull String cameraId, @NonNull Map<String, CameraCharacteristics> characteristicsMap) {
        if (this.mExtensionDisabledValidator.shouldDisableExtension()) {
            return false;
        }
        if (this.mPreviewExtenderImpl == null || this.mImageCaptureExtenderImpl == null) {
            return false;
        }
        CameraCharacteristics cameraCharacteristics = characteristicsMap.get(cameraId);
        return this.mPreviewExtenderImpl.isExtensionAvailable(cameraId, cameraCharacteristics) && this.mImageCaptureExtenderImpl.isExtensionAvailable(cameraId, cameraCharacteristics);
    }

    @Override
    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public void init(@NonNull CameraInfo cameraInfo) {
        this.mCameraInfo = cameraInfo;
        if (this.mPreviewExtenderImpl == null || this.mImageCaptureExtenderImpl == null) {
            return;
        }
        this.mCameraId = Camera2CameraInfo.from((CameraInfo)cameraInfo).getCameraId();
        this.mCameraCharacteristics = Camera2CameraInfo.extractCameraCharacteristics((CameraInfo)cameraInfo);
        this.mPreviewExtenderImpl.init(this.mCameraId, this.mCameraCharacteristics);
        this.mImageCaptureExtenderImpl.init(this.mCameraId, this.mCameraCharacteristics);
        Logger.d((String)TAG, (String)("PreviewExtender processorType= " + this.mPreviewExtenderImpl.getProcessorType()));
        Logger.d((String)TAG, (String)("ImageCaptureExtender processor= " + this.mImageCaptureExtenderImpl.getCaptureProcessor()));
    }

    @Override
    @Nullable
    public Range<Long> getEstimatedCaptureLatencyRange(@Nullable Size size) {
        Preconditions.checkNotNull((Object)this.mCameraInfo, (Object)"VendorExtender#init() must be called first");
        if (this.mImageCaptureExtenderImpl != null && ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_2) >= 0) {
            try {
                return this.mImageCaptureExtenderImpl.getEstimatedCaptureLatencyRange(size);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        return null;
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    private Size[] getOutputSizes(int imageFormat) {
        StreamConfigurationMap map = (StreamConfigurationMap)Camera2CameraInfo.from((CameraInfo)this.mCameraInfo).getCameraCharacteristic(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        return map.getOutputSizes(imageFormat);
    }

    private int getCaptureInputImageFormat() {
        if (this.mImageCaptureExtenderImpl != null && this.mImageCaptureExtenderImpl.getCaptureProcessor() != null) {
            return 35;
        }
        return 256;
    }

    private int getPreviewInputImageFormat() {
        if (this.mPreviewExtenderImpl != null && this.mPreviewExtenderImpl.getProcessorType() == PreviewExtenderImpl.ProcessorType.PROCESSOR_TYPE_IMAGE_PROCESSOR) {
            return 35;
        }
        return 34;
    }

    @Override
    @NonNull
    public List<Pair<Integer, Size[]>> getSupportedPreviewOutputResolutions() {
        Preconditions.checkNotNull((Object)this.mCameraInfo, (Object)"VendorExtender#init() must be called first");
        if (this.mPreviewExtenderImpl != null && ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_1) >= 0) {
            try {
                List result = this.mPreviewExtenderImpl.getSupportedResolutions();
                if (result != null) {
                    return this.replaceImageFormatIfMissing(result, 35, 34);
                }
            }
            catch (NoSuchMethodError result) {
                // empty catch block
            }
        }
        int inputImageFormat = this.getPreviewInputImageFormat();
        return Arrays.asList(new Pair((Object)34, (Object)this.getOutputSizes(inputImageFormat)));
    }

    @Override
    @NonNull
    public List<Pair<Integer, Size[]>> getSupportedCaptureOutputResolutions() {
        Preconditions.checkNotNull((Object)this.mCameraInfo, (Object)"VendorExtender#init() must be called first");
        if (this.mImageCaptureExtenderImpl != null && ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_1) >= 0) {
            try {
                List result = this.mImageCaptureExtenderImpl.getSupportedResolutions();
                if (result != null) {
                    return this.replaceImageFormatIfMissing(result, 35, 256);
                }
            }
            catch (NoSuchMethodError result) {
                // empty catch block
            }
        }
        int inputImageFormat = this.getCaptureInputImageFormat();
        return Arrays.asList(new Pair((Object)256, (Object)this.getOutputSizes(inputImageFormat)));
    }

    private List<Pair<Integer, Size[]>> replaceImageFormatIfMissing(List<Pair<Integer, Size[]>> input, int formatToBeReplaced, int newFormat) {
        for (Pair<Integer, Size[]> pair : input) {
            if ((Integer)pair.first != newFormat) continue;
            return input;
        }
        ArrayList<Pair<Integer, Size[]>> output = new ArrayList<Pair<Integer, Size[]>>();
        boolean formatFound = false;
        for (Pair<Integer, Size[]> pair : input) {
            if ((Integer)pair.first == formatToBeReplaced) {
                formatFound = true;
                output.add((Pair<Integer, Size[]>)new Pair((Object)newFormat, (Object)((Size[])pair.second)));
                continue;
            }
            output.add(pair);
        }
        if (!formatFound) {
            throw new IllegalArgumentException("Supported resolution should contain " + newFormat + " format.");
        }
        return output;
    }

    @Override
    @NonNull
    public Size[] getSupportedYuvAnalysisResolutions() {
        boolean hasImageCaptureProcessor;
        ImageAnalysisAvailability imageAnalysisAvailability = new ImageAnalysisAvailability();
        boolean hasPreviewProcessor = this.mPreviewExtenderImpl.getProcessorType() == PreviewExtenderImpl.ProcessorType.PROCESSOR_TYPE_IMAGE_PROCESSOR;
        boolean bl = hasImageCaptureProcessor = this.mImageCaptureExtenderImpl.getCaptureProcessor() != null;
        if (!imageAnalysisAvailability.isAvailable(this.mCameraId, this.getHardwareLevel(), this.mMode, hasPreviewProcessor, hasImageCaptureProcessor)) {
            return new Size[0];
        }
        Preconditions.checkNotNull((Object)this.mCameraInfo, (Object)"VendorExtender#init() must be called first");
        return this.getOutputSizes(35);
    }

    private int getHardwareLevel() {
        Integer hardwareLevel = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        return hardwareLevel != null ? hardwareLevel : 2;
    }

    @NonNull
    private List<CaptureRequest.Key> getSupportedParameterKeys(Context context) {
        if (ExtensionVersion.isMinimumCompatibleVersion(Version.VERSION_1_3)) {
            try {
                List<CaptureRequest.Key> keys = this.mAvailableKeysRetriever.getAvailableCaptureRequestKeys(this.mImageCaptureExtenderImpl, this.mCameraId, this.mCameraCharacteristics, context);
                if (keys != null) {
                    return Collections.unmodifiableList(keys);
                }
            }
            catch (Exception e) {
                Logger.e((String)TAG, (String)"ImageCaptureExtenderImpl.getAvailableCaptureRequestKeys throws exceptions", (Throwable)e);
            }
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(sBaseSupportedKeys);
    }

    @NonNull
    private List<CaptureResult.Key> getSupportedCaptureResultKeys() {
        if (ExtensionVersion.isMinimumCompatibleVersion(Version.VERSION_1_3)) {
            try {
                List keys = this.mImageCaptureExtenderImpl.getAvailableCaptureResultKeys();
                if (keys != null) {
                    return Collections.unmodifiableList(keys);
                }
            }
            catch (Exception e) {
                Logger.e((String)TAG, (String)"ImageCaptureExtenderImpl.getAvailableCaptureResultKeys throws exceptions", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public SessionProcessor createSessionProcessor(@NonNull Context context) {
        Preconditions.checkNotNull((Object)this.mCameraInfo, (Object)"VendorExtender#init() must be called first");
        return new BasicExtenderSessionProcessor(this.mPreviewExtenderImpl, this.mImageCaptureExtenderImpl, this.getSupportedParameterKeys(context), this.getSupportedCaptureResultKeys(), context);
    }

    static {
        if (Build.VERSION.SDK_INT >= 30) {
            sBaseSupportedKeys.add(CaptureRequest.CONTROL_ZOOM_RATIO);
        }
    }
}

