/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Logger;
import androidx.camera.extensions.impl.ExtensionVersionImpl;
import androidx.camera.extensions.internal.ClientVersion;
import androidx.camera.extensions.internal.Version;

@RequiresApi(value=21)
public abstract class ExtensionVersion {
    private static final String TAG = "ExtenderVersion";
    private static volatile ExtensionVersion sExtensionVersion;

    @VisibleForTesting
    public static void injectInstance(@Nullable ExtensionVersion extensionVersion) {
        sExtensionVersion = extensionVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExtensionVersion getInstance() {
        if (sExtensionVersion != null) {
            return sExtensionVersion;
        }
        Class<ExtensionVersion> clazz = ExtensionVersion.class;
        synchronized (ExtensionVersion.class) {
            if (sExtensionVersion == null) {
                try {
                    sExtensionVersion = new VendorExtenderVersioning();
                }
                catch (NoClassDefFoundError e) {
                    Logger.d((String)TAG, (String)"No versioning extender found. Falling back to default.");
                    sExtensionVersion = new DefaultExtenderVersioning();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sExtensionVersion;
        }
    }

    public static boolean isExtensionVersionSupported() {
        return ExtensionVersion.getInstance().getVersionObject() != null;
    }

    @Nullable
    public static Version getRuntimeVersion() {
        return ExtensionVersion.getInstance().getVersionObject();
    }

    public static boolean isAdvancedExtenderSupported() {
        return ExtensionVersion.getInstance().isAdvancedExtenderSupportedInternal();
    }

    public static boolean isMinimumCompatibleVersion(@NonNull Version version) {
        return ExtensionVersion.getRuntimeVersion().compareTo(version.getMajor(), version.getMinor()) >= 0;
    }

    public static boolean isMaximumCompatibleVersion(@NonNull Version version) {
        return ExtensionVersion.getRuntimeVersion().compareTo(version.getMajor(), version.getMinor()) <= 0;
    }

    abstract boolean isAdvancedExtenderSupportedInternal();

    abstract Version getVersionObject();

    private static class VendorExtenderVersioning
    extends ExtensionVersion {
        private static ExtensionVersionImpl sImpl;
        private Version mRuntimeVersion;

        VendorExtenderVersioning() {
            String vendorVersion;
            Version vendorVersionObj;
            if (sImpl == null) {
                sImpl = new ExtensionVersionImpl();
            }
            if ((vendorVersionObj = Version.parse(vendorVersion = sImpl.checkApiVersion(ClientVersion.getCurrentVersion().toVersionString()))) != null && ClientVersion.getCurrentVersion().getVersion().getMajor() == vendorVersionObj.getMajor()) {
                this.mRuntimeVersion = vendorVersionObj;
            }
            Logger.d((String)ExtensionVersion.TAG, (String)("Selected vendor runtime: " + this.mRuntimeVersion));
        }

        @Override
        Version getVersionObject() {
            return this.mRuntimeVersion;
        }

        @Override
        boolean isAdvancedExtenderSupportedInternal() {
            try {
                return sImpl.isAdvancedExtenderImplemented();
            }
            catch (NoSuchMethodError e) {
                return false;
            }
        }
    }

    private static class DefaultExtenderVersioning
    extends ExtensionVersion {
        DefaultExtenderVersioning() {
        }

        @Override
        Version getVersionObject() {
            return null;
        }

        @Override
        boolean isAdvancedExtenderSupportedInternal() {
            return false;
        }
    }
}

