/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.util.Pair;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageAnalysisConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.extensions.internal.ImageAnalysisConfigProvider;
import androidx.camera.extensions.internal.ImageCaptureConfigProvider;
import androidx.camera.extensions.internal.PreviewConfigProvider;
import androidx.camera.extensions.internal.VendorExtender;
import java.util.List;

@RequiresApi(value=21)
public final class ExtensionsUseCaseConfigFactory
implements UseCaseConfigFactory {
    private final ImageCaptureConfigProvider mImageCaptureConfigProvider;
    private final PreviewConfigProvider mPreviewConfigProvider;
    private final ImageAnalysisConfigProvider mImageAnalysisConfigProvider;

    public ExtensionsUseCaseConfigFactory(int mode, @NonNull VendorExtender vendorExtender) {
        this.mImageCaptureConfigProvider = new ImageCaptureConfigProvider(mode, vendorExtender);
        this.mPreviewConfigProvider = new PreviewConfigProvider(mode, vendorExtender);
        this.mImageAnalysisConfigProvider = new ImageAnalysisConfigProvider(vendorExtender);
    }

    private boolean isImageAnalysisSupported(@Nullable List<Pair<Integer, Size[]>> supportedResolutions) {
        if (supportedResolutions == null) {
            return false;
        }
        for (Pair<Integer, Size[]> pair : supportedResolutions) {
            int imageFormat = (Integer)pair.first;
            Size[] sizes = (Size[])pair.second;
            if (imageFormat != 35 || sizes == null || sizes.length <= 0) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Config getConfig(@NonNull UseCaseConfigFactory.CaptureType captureType, int captureMode) {
        MutableOptionsBundle mutableOptionsBundle;
        switch (captureType) {
            case IMAGE_CAPTURE: {
                mutableOptionsBundle = MutableOptionsBundle.from((Config)this.mImageCaptureConfigProvider.getConfig());
                break;
            }
            case PREVIEW: {
                mutableOptionsBundle = MutableOptionsBundle.from((Config)this.mPreviewConfigProvider.getConfig());
                break;
            }
            case IMAGE_ANALYSIS: {
                ImageAnalysisConfig config = this.mImageAnalysisConfigProvider.getConfig();
                List supportedResolutions = config.getSupportedResolutions(null);
                if (!this.isImageAnalysisSupported(supportedResolutions)) {
                    throw new IllegalArgumentException("ImageAnalysis is not supported when Extension is enabled on this device. Check ExtensionsManager.isImageAnalysisSupported before binding the ImageAnalysis use case.");
                }
                mutableOptionsBundle = MutableOptionsBundle.from((Config)config);
                break;
            }
            case VIDEO_CAPTURE: {
                throw new IllegalArgumentException("CameraX Extensions doesn't support VideoCapture!");
            }
            default: {
                return null;
            }
        }
        mutableOptionsBundle.insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, (Object)true);
        return OptionsBundle.from((Config)mutableOptionsBundle);
    }
}

