/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.util.Pair;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.extensions.internal.VendorExtender;
import java.util.List;

@RequiresApi(value=21)
public class ImageCaptureConfigProvider
implements ConfigProvider<ImageCaptureConfig> {
    static final Config.Option<Integer> OPTION_IMAGE_CAPTURE_CONFIG_PROVIDER_MODE = Config.Option.create((String)"camerax.extensions.imageCaptureConfigProvider.mode", Integer.class);
    private final VendorExtender mVendorExtender;
    private final int mEffectMode;

    public ImageCaptureConfigProvider(int mode, @NonNull VendorExtender vendorExtender) {
        this.mEffectMode = mode;
        this.mVendorExtender = vendorExtender;
    }

    @NonNull
    public ImageCaptureConfig getConfig() {
        ImageCapture.Builder builder = new ImageCapture.Builder();
        this.updateBuilderConfig(builder, this.mEffectMode, this.mVendorExtender);
        return builder.getUseCaseConfig();
    }

    void updateBuilderConfig(@NonNull ImageCapture.Builder builder, int effectMode, @NonNull VendorExtender vendorExtender) {
        builder.getMutableConfig().insertOption(OPTION_IMAGE_CAPTURE_CONFIG_PROVIDER_MODE, (Object)effectMode);
        List<Pair<Integer, Size[]>> supportedResolutions = vendorExtender.getSupportedCaptureOutputResolutions();
        builder.setSupportedResolutions(supportedResolutions);
        builder.setHighResolutionDisabled(true);
    }
}

