/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal;

import android.util.Pair;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Preview;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.PreviewConfig;
import androidx.camera.extensions.internal.VendorExtender;
import java.util.List;

@RequiresApi(value=21)
public class PreviewConfigProvider
implements ConfigProvider<PreviewConfig> {
    private static final String TAG = "PreviewConfigProvider";
    static final Config.Option<Integer> OPTION_PREVIEW_CONFIG_PROVIDER_MODE = Config.Option.create((String)"camerax.extensions.previewConfigProvider.mode", Integer.class);
    private final VendorExtender mVendorExtender;
    private final int mEffectMode;

    public PreviewConfigProvider(int mode, @NonNull VendorExtender vendorExtender) {
        this.mEffectMode = mode;
        this.mVendorExtender = vendorExtender;
    }

    @NonNull
    public PreviewConfig getConfig() {
        Preview.Builder builder = new Preview.Builder();
        this.updateBuilderConfig(builder, this.mEffectMode, this.mVendorExtender);
        return builder.getUseCaseConfig();
    }

    void updateBuilderConfig(@NonNull Preview.Builder builder, int effectMode, @NonNull VendorExtender vendorExtender) {
        builder.getMutableConfig().insertOption(OPTION_PREVIEW_CONFIG_PROVIDER_MODE, (Object)effectMode);
        List<Pair<Integer, Size[]>> supportedResolutions = vendorExtender.getSupportedPreviewOutputResolutions();
        builder.setSupportedResolutions(supportedResolutions);
        builder.setHighResolutionDisabled(true);
    }
}

