/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.compat.quirk;

import android.os.Build;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Quirk;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

@RequiresApi(value=21)
public class ImageAnalysisUnavailableQuirk
implements Quirk {
    private static final Set<Pair<String, String>> KNOWN_DEVICES = new HashSet<Pair>(Arrays.asList(Pair.create((Object)"samsung", (Object)"dm3q"), Pair.create((Object)"samsung", (Object)"q2q"), Pair.create((Object)"samsung", (Object)"a52sxq"), Pair.create((Object)"samsung", (Object)"b0q")));
    private final Set<Pair<String, Integer>> mUnavailableCombinations = new HashSet<Pair<String, Integer>>();

    ImageAnalysisUnavailableQuirk() {
        if (Build.BRAND.equalsIgnoreCase("SAMSUNG") && Build.DEVICE.equalsIgnoreCase("dm3q")) {
            this.mUnavailableCombinations.addAll(Arrays.asList(Pair.create((Object)"1", (Object)1), Pair.create((Object)"1", (Object)4), Pair.create((Object)"3", (Object)1), Pair.create((Object)"3", (Object)4)));
        } else if (Build.BRAND.equalsIgnoreCase("SAMSUNG") && Build.DEVICE.equalsIgnoreCase("q2q")) {
            this.mUnavailableCombinations.addAll(Arrays.asList(Pair.create((Object)"0", (Object)1), Pair.create((Object)"0", (Object)4)));
        } else if (Build.BRAND.equalsIgnoreCase("SAMSUNG") && Build.DEVICE.equalsIgnoreCase("a52sxq")) {
            this.mUnavailableCombinations.addAll(Arrays.asList(Pair.create((Object)"0", (Object)1), Pair.create((Object)"0", (Object)4)));
        } else if (Build.BRAND.equalsIgnoreCase("SAMSUNG") && Build.DEVICE.equalsIgnoreCase("b0q")) {
            this.mUnavailableCombinations.addAll(Arrays.asList(Pair.create((Object)"3", (Object)1), Pair.create((Object)"3", (Object)4)));
        }
    }

    static boolean load() {
        return KNOWN_DEVICES.contains(Pair.create((Object)Build.BRAND.toLowerCase(Locale.US), (Object)Build.DEVICE.toLowerCase(Locale.US)));
    }

    public boolean isUnavailable(@NonNull String cameraId, int mode) {
        return this.mUnavailableCombinations.contains(Pair.create((Object)cameraId, (Object)mode));
    }
}

