/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.compat.workaround;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.extensions.internal.compat.quirk.DeviceQuirks;
import androidx.camera.extensions.internal.compat.quirk.ExtraSupportedSurfaceCombinationsQuirk;
import androidx.camera.extensions.internal.compat.quirk.ImageAnalysisUnavailableQuirk;

@RequiresApi(value=21)
public class ImageAnalysisAvailability {
    ImageAnalysisUnavailableQuirk mImageAnalysisUnavailableQuirk = DeviceQuirks.get(ImageAnalysisUnavailableQuirk.class);
    ExtraSupportedSurfaceCombinationsQuirk mExtraSupportedSurfaceCombinationsQuirk = DeviceQuirks.get(ExtraSupportedSurfaceCombinationsQuirk.class);

    public boolean isAvailable(@NonNull String cameraId, int hardwareLevel, int mode, boolean hasPreviewProcessor, boolean hasImageCaptureProcessor) {
        if (this.mImageAnalysisUnavailableQuirk != null && this.mImageAnalysisUnavailableQuirk.isUnavailable(cameraId, mode)) {
            return false;
        }
        if (this.mExtraSupportedSurfaceCombinationsQuirk != null) {
            return true;
        }
        if (!hasPreviewProcessor && !hasImageCaptureProcessor) {
            return true;
        }
        if (hasPreviewProcessor && !hasImageCaptureProcessor) {
            return hardwareLevel == 0 || hardwareLevel == 1 || hardwareLevel == 3;
        }
        return hardwareLevel == 1 || hardwareLevel == 3;
    }
}

