/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.compat.workaround;

import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Logger;
import androidx.camera.extensions.internal.compat.quirk.CrashWhenOnDisableTooSoon;
import androidx.camera.extensions.internal.compat.quirk.DeviceQuirks;

@RequiresApi(value=21)
public class OnEnableDisableSessionDurationCheck {
    private static final String TAG = "OnEnableDisableSessionDurationCheck";
    private final boolean mEnabledMinimumDuration;
    private long mOnEnableSessionTimeStamp = 0L;
    @VisibleForTesting
    static final long MIN_DURATION_FOR_ENABLE_DISABLE_SESSION = 100L;

    public OnEnableDisableSessionDurationCheck() {
        this(DeviceQuirks.get(CrashWhenOnDisableTooSoon.class) != null);
    }

    @VisibleForTesting
    OnEnableDisableSessionDurationCheck(boolean enabledMinimalDuration) {
        this.mEnabledMinimumDuration = enabledMinimalDuration;
    }

    public void onEnableSessionInvoked() {
        if (this.mEnabledMinimumDuration) {
            this.mOnEnableSessionTimeStamp = SystemClock.elapsedRealtime();
        }
    }

    public void onDisableSessionInvoked() {
        if (this.mEnabledMinimumDuration) {
            this.ensureMinDurationAfterOnEnableSession();
        }
    }

    private void ensureMinDurationAfterOnEnableSession() {
        long timeAfterOnEnableSession = SystemClock.elapsedRealtime() - this.mOnEnableSessionTimeStamp;
        while (timeAfterOnEnableSession < 100L) {
            try {
                long timeToWait = 100L - timeAfterOnEnableSession;
                Logger.d((String)TAG, (String)("onDisableSession too soon, wait " + timeToWait + " ms"));
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException e) {
                Logger.e((String)TAG, (String)"sleep interrupted");
                return;
            }
            timeAfterOnEnableSession = SystemClock.elapsedRealtime() - this.mOnEnableSessionTimeStamp;
        }
    }
}

