/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.sessionprocessor;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.media.Image;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2CameraCaptureResultConverter;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.interop.CaptureRequestOptions;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.OutputSurface;
import androidx.camera.core.impl.RequestProcessor;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.extensions.impl.advanced.Camera2OutputConfigImpl;
import androidx.camera.extensions.impl.advanced.Camera2SessionConfigImpl;
import androidx.camera.extensions.impl.advanced.ImageProcessorImpl;
import androidx.camera.extensions.impl.advanced.ImageReferenceImpl;
import androidx.camera.extensions.impl.advanced.OutputSurfaceImpl;
import androidx.camera.extensions.impl.advanced.RequestProcessorImpl;
import androidx.camera.extensions.impl.advanced.SessionProcessorImpl;
import androidx.camera.extensions.internal.ClientVersion;
import androidx.camera.extensions.internal.ExtensionVersion;
import androidx.camera.extensions.internal.Version;
import androidx.camera.extensions.internal.sessionprocessor.Camera2OutputConfig;
import androidx.camera.extensions.internal.sessionprocessor.Camera2OutputConfigConverter;
import androidx.camera.extensions.internal.sessionprocessor.Camera2SessionConfig;
import androidx.camera.extensions.internal.sessionprocessor.Camera2SessionConfigBuilder;
import androidx.camera.extensions.internal.sessionprocessor.ImageProcessor;
import androidx.camera.extensions.internal.sessionprocessor.ImageReference;
import androidx.camera.extensions.internal.sessionprocessor.SessionProcessorBase;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@RequiresApi(value=21)
public class AdvancedSessionProcessor
extends SessionProcessorBase {
    private final SessionProcessorImpl mImpl;
    private final Context mContext;

    public AdvancedSessionProcessor(@NonNull SessionProcessorImpl impl, @NonNull List<CaptureRequest.Key> supportedKeys, @NonNull Context context) {
        super(supportedKeys);
        this.mImpl = impl;
        this.mContext = context;
    }

    @Override
    @NonNull
    protected Camera2SessionConfig initSessionInternal(@NonNull String cameraId, @NonNull Map<String, CameraCharacteristics> cameraCharacteristicsMap, @NonNull OutputSurface previewSurfaceConfig, @NonNull OutputSurface imageCaptureSurfaceConfig, @Nullable OutputSurface imageAnalysisSurfaceConfig) {
        Camera2SessionConfigImpl sessionConfigImpl = this.mImpl.initSession(cameraId, cameraCharacteristicsMap, this.mContext, (OutputSurfaceImpl)new OutputSurfaceImplAdapter(previewSurfaceConfig), (OutputSurfaceImpl)new OutputSurfaceImplAdapter(imageCaptureSurfaceConfig), (OutputSurfaceImpl)(imageAnalysisSurfaceConfig == null ? null : new OutputSurfaceImplAdapter(imageAnalysisSurfaceConfig)));
        return this.convertToCamera2SessionConfig(sessionConfigImpl);
    }

    private Camera2SessionConfig convertToCamera2SessionConfig(@NonNull Camera2SessionConfigImpl sessionConfigImpl) {
        Camera2SessionConfigBuilder camera2SessionConfigBuilder = new Camera2SessionConfigBuilder();
        for (Camera2OutputConfigImpl outputConfigImpl : sessionConfigImpl.getOutputConfigs()) {
            Camera2OutputConfig outputConfig = Camera2OutputConfigConverter.fromImpl(outputConfigImpl);
            camera2SessionConfigBuilder.addOutputConfig(outputConfig);
        }
        Iterator<Object> iterator = sessionConfigImpl.getSessionParameters().keySet().iterator();
        while (iterator.hasNext()) {
            CaptureRequest.Key key;
            CaptureRequest.Key objKey = key = (CaptureRequest.Key)iterator.next();
            camera2SessionConfigBuilder.addSessionParameter(objKey, sessionConfigImpl.getSessionParameters().get(objKey));
        }
        camera2SessionConfigBuilder.setSessionTemplateId(sessionConfigImpl.getSessionTemplateId());
        return camera2SessionConfigBuilder.build();
    }

    @Override
    protected void deInitSessionInternal() {
        this.mImpl.deInitSession();
    }

    public void setParameters(@NonNull Config parameters) {
        HashMap<CaptureRequest.Key<?>, Object> map = AdvancedSessionProcessor.convertConfigToMap(parameters);
        this.mImpl.setParameters(map);
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    @NonNull
    private static HashMap<CaptureRequest.Key<?>, Object> convertConfigToMap(@NonNull Config parameters) {
        HashMap map = new HashMap();
        CaptureRequestOptions options = CaptureRequestOptions.Builder.from((Config)parameters).build();
        for (Config.Option option : options.listOptions()) {
            CaptureRequest.Key key = (CaptureRequest.Key)option.getToken();
            map.put(key, options.retrieveOption(option));
        }
        return map;
    }

    public void onCaptureSessionStart(@NonNull RequestProcessor requestProcessor) {
        this.mImpl.onCaptureSessionStart((RequestProcessorImpl)new RequestProcessorImplAdapter(requestProcessor));
    }

    public void onCaptureSessionEnd() {
        this.mImpl.onCaptureSessionEnd();
    }

    public int startCapture(@NonNull SessionProcessor.CaptureCallback callback) {
        return this.mImpl.startCapture((SessionProcessorImpl.CaptureCallback)new SessionProcessorImplCaptureCallbackAdapter(callback));
    }

    public int startRepeating(@NonNull SessionProcessor.CaptureCallback callback) {
        return this.mImpl.startRepeating((SessionProcessorImpl.CaptureCallback)new SessionProcessorImplCaptureCallbackAdapter(callback));
    }

    public int startTrigger(@NonNull Config config, @NonNull SessionProcessor.CaptureCallback callback) {
        HashMap<CaptureRequest.Key<?>, Object> map = AdvancedSessionProcessor.convertConfigToMap(config);
        if (ClientVersion.isMinimumCompatibleVersion(Version.VERSION_1_3) && ExtensionVersion.isMinimumCompatibleVersion(Version.VERSION_1_3)) {
            return this.mImpl.startTrigger(map, (SessionProcessorImpl.CaptureCallback)new SessionProcessorImplCaptureCallbackAdapter(callback));
        }
        return -1;
    }

    public void stopRepeating() {
        this.mImpl.stopRepeating();
    }

    public void abortCapture(int captureSequenceId) {
        this.mImpl.abortCapture(captureSequenceId);
    }

    @Nullable
    public Pair<Long, Long> getRealtimeCaptureLatency() {
        if (ClientVersion.isMinimumCompatibleVersion(Version.VERSION_1_4) && ExtensionVersion.isMinimumCompatibleVersion(Version.VERSION_1_4)) {
            return this.mImpl.getRealtimeCaptureLatency();
        }
        return null;
    }

    private static class OutputSurfaceImplAdapter
    implements OutputSurfaceImpl {
        private final OutputSurface mOutputSurface;

        OutputSurfaceImplAdapter(OutputSurface outputSurface) {
            this.mOutputSurface = outputSurface;
        }

        @NonNull
        public Surface getSurface() {
            return this.mOutputSurface.getSurface();
        }

        @NonNull
        public Size getSize() {
            return this.mOutputSurface.getSize();
        }

        public int getImageFormat() {
            return this.mOutputSurface.getImageFormat();
        }
    }

    private class RequestProcessorImplAdapter
    implements RequestProcessorImpl {
        private final RequestProcessor mRequestProcessor;

        RequestProcessorImplAdapter(RequestProcessor requestProcessor) {
            this.mRequestProcessor = requestProcessor;
        }

        public void setImageProcessor(int outputConfigId, @NonNull ImageProcessorImpl imageProcessorImpl) {
            AdvancedSessionProcessor.this.setImageProcessor(outputConfigId, new ImageProcessorAdapter(imageProcessorImpl));
        }

        public int submit(@NonNull RequestProcessorImpl.Request request, @NonNull RequestProcessorImpl.Callback callback) {
            return this.mRequestProcessor.submit((RequestProcessor.Request)new RequestAdapter(request), (RequestProcessor.Callback)new CallbackAdapter(callback));
        }

        public int submit(@NonNull List<RequestProcessorImpl.Request> requests, @NonNull RequestProcessorImpl.Callback callback) {
            ArrayList<RequestAdapter> outRequests = new ArrayList<RequestAdapter>();
            for (RequestProcessorImpl.Request request : requests) {
                outRequests.add(new RequestAdapter(request));
            }
            return this.mRequestProcessor.submit(outRequests, (RequestProcessor.Callback)new CallbackAdapter(callback));
        }

        public int setRepeating(@NonNull RequestProcessorImpl.Request request, @NonNull RequestProcessorImpl.Callback callback) {
            return this.mRequestProcessor.setRepeating((RequestProcessor.Request)new RequestAdapter(request), (RequestProcessor.Callback)new CallbackAdapter(callback));
        }

        public void abortCaptures() {
            this.mRequestProcessor.abortCaptures();
        }

        public void stopRepeating() {
            this.mRequestProcessor.stopRepeating();
        }
    }

    private static class SessionProcessorImplCaptureCallbackAdapter
    implements SessionProcessorImpl.CaptureCallback {
        private final SessionProcessor.CaptureCallback mCaptureCallback;

        SessionProcessorImplCaptureCallbackAdapter(@NonNull SessionProcessor.CaptureCallback callback) {
            this.mCaptureCallback = callback;
        }

        public void onCaptureStarted(int captureSequenceId, long timestamp) {
            this.mCaptureCallback.onCaptureStarted(captureSequenceId, timestamp);
        }

        public void onCaptureProcessStarted(int captureSequenceId) {
            this.mCaptureCallback.onCaptureProcessStarted(captureSequenceId);
        }

        public void onCaptureFailed(int captureSequenceId) {
            this.mCaptureCallback.onCaptureFailed(captureSequenceId);
        }

        public void onCaptureSequenceCompleted(int captureSequenceId) {
            this.mCaptureCallback.onCaptureSequenceCompleted(captureSequenceId);
        }

        public void onCaptureSequenceAborted(int captureSequenceId) {
            this.mCaptureCallback.onCaptureSequenceAborted(captureSequenceId);
        }

        public void onCaptureCompleted(long timestamp, int captureSequenceId, Map<CaptureResult.Key, Object> result) {
            this.mCaptureCallback.onCaptureCompleted(timestamp, captureSequenceId, result);
        }

        public void onCaptureProcessProgressed(int progress) {
        }
    }

    private static class CallbackAdapter
    implements RequestProcessor.Callback {
        private final RequestProcessorImpl.Callback mCallback;

        CallbackAdapter(RequestProcessorImpl.Callback callback) {
            this.mCallback = callback;
        }

        public void onCaptureStarted(@NonNull RequestProcessor.Request request, long frameNumber, long timestamp) {
            this.mCallback.onCaptureStarted(this.getImplRequest(request), frameNumber, timestamp);
        }

        public void onCaptureProgressed(@NonNull RequestProcessor.Request request, @NonNull CameraCaptureResult cameraCaptureResult) {
            CaptureResult captureResult = Camera2CameraCaptureResultConverter.getCaptureResult((CameraCaptureResult)cameraCaptureResult);
            Preconditions.checkArgument((captureResult != null ? 1 : 0) != 0, (Object)"Cannot get CaptureResult from the cameraCaptureResult ");
            this.mCallback.onCaptureProgressed(this.getImplRequest(request), captureResult);
        }

        public void onCaptureCompleted(@NonNull RequestProcessor.Request request, @Nullable CameraCaptureResult cameraCaptureResult) {
            CaptureResult captureResult = Camera2CameraCaptureResultConverter.getCaptureResult((CameraCaptureResult)cameraCaptureResult);
            Preconditions.checkArgument((boolean)(captureResult instanceof TotalCaptureResult), (Object)"CaptureResult in cameraCaptureResult is not a TotalCaptureResult");
            this.mCallback.onCaptureCompleted(this.getImplRequest(request), (TotalCaptureResult)captureResult);
        }

        public void onCaptureFailed(@NonNull RequestProcessor.Request request, @Nullable CameraCaptureFailure cameraCaptureFailure) {
            CaptureFailure captureFailure = Camera2CameraCaptureResultConverter.getCaptureFailure((CameraCaptureFailure)cameraCaptureFailure);
            Preconditions.checkArgument((captureFailure != null ? 1 : 0) != 0, (Object)"CameraCaptureFailure does not contain CaptureFailure.");
            this.mCallback.onCaptureFailed(this.getImplRequest(request), captureFailure);
        }

        public void onCaptureBufferLost(@NonNull RequestProcessor.Request request, long frameNumber, int outputStreamId) {
            this.mCallback.onCaptureBufferLost(this.getImplRequest(request), frameNumber, outputStreamId);
        }

        public void onCaptureSequenceCompleted(int sequenceId, long frameNumber) {
            this.mCallback.onCaptureSequenceCompleted(sequenceId, frameNumber);
        }

        public void onCaptureSequenceAborted(int sequenceId) {
            this.mCallback.onCaptureSequenceAborted(sequenceId);
        }

        private RequestProcessorImpl.Request getImplRequest(RequestProcessor.Request request) {
            Preconditions.checkArgument((boolean)(request instanceof RequestAdapter));
            RequestAdapter requestProcessorRequest = (RequestAdapter)request;
            return requestProcessorRequest.getImplRequest();
        }
    }

    private static class ImageReferenceImplAdapter
    implements ImageReferenceImpl {
        private final ImageReference mImageReference;

        ImageReferenceImplAdapter(ImageReference imageReference) {
            this.mImageReference = imageReference;
        }

        public boolean increment() {
            return this.mImageReference.increment();
        }

        public boolean decrement() {
            return this.mImageReference.decrement();
        }

        @Nullable
        public Image get() {
            return this.mImageReference.get();
        }
    }

    private static class ImageProcessorAdapter
    implements ImageProcessor {
        private final ImageProcessorImpl mImpl;

        ImageProcessorAdapter(ImageProcessorImpl impl) {
            this.mImpl = impl;
        }

        @Override
        public void onNextImageAvailable(int outputStreamId, long timestampNs, @NonNull ImageReference imageReference, @Nullable String physicalCameraId) {
            this.mImpl.onNextImageAvailable(outputStreamId, timestampNs, (ImageReferenceImpl)new ImageReferenceImplAdapter(imageReference), physicalCameraId);
        }
    }

    private static class RequestAdapter
    implements RequestProcessor.Request {
        private final RequestProcessorImpl.Request mImplRequest;
        private final List<Integer> mTargetOutputConfigIds;
        private final Config mParameters;
        private final int mTemplateId;

        @OptIn(markerClass={ExperimentalCamera2Interop.class})
        RequestAdapter(@NonNull RequestProcessorImpl.Request implRequest) {
            this.mImplRequest = implRequest;
            ArrayList<Integer> targetOutputConfigIds = new ArrayList<Integer>();
            for (Integer outputConfigId : implRequest.getTargetOutputConfigIds()) {
                targetOutputConfigIds.add(outputConfigId);
            }
            this.mTargetOutputConfigIds = targetOutputConfigIds;
            Camera2ImplConfig.Builder camera2ConfigBuilder = new Camera2ImplConfig.Builder();
            Iterator iterator = implRequest.getParameters().keySet().iterator();
            while (iterator.hasNext()) {
                CaptureRequest.Key key;
                CaptureRequest.Key objKey = key = (CaptureRequest.Key)iterator.next();
                camera2ConfigBuilder.setCaptureRequestOption(objKey, implRequest.getParameters().get(objKey));
            }
            this.mParameters = camera2ConfigBuilder.build();
            this.mTemplateId = implRequest.getTemplateId();
        }

        @NonNull
        public List<Integer> getTargetOutputConfigIds() {
            return this.mTargetOutputConfigIds;
        }

        @NonNull
        public Config getParameters() {
            return this.mParameters;
        }

        public int getTemplateId() {
            return this.mTemplateId;
        }

        @Nullable
        public RequestProcessorImpl.Request getImplRequest() {
            return this.mImplRequest;
        }
    }
}

