/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.sessionprocessor;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2CameraCaptureResultConverter;
import androidx.camera.camera2.interop.CaptureRequestOptions;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.OutputSurface;
import androidx.camera.core.impl.RequestProcessor;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.extensions.impl.CaptureProcessorImpl;
import androidx.camera.extensions.impl.CaptureStageImpl;
import androidx.camera.extensions.impl.ImageCaptureExtenderImpl;
import androidx.camera.extensions.impl.PreviewExtenderImpl;
import androidx.camera.extensions.impl.PreviewImageProcessorImpl;
import androidx.camera.extensions.impl.RequestUpdateProcessorImpl;
import androidx.camera.extensions.internal.ClientVersion;
import androidx.camera.extensions.internal.ExtensionVersion;
import androidx.camera.extensions.internal.Version;
import androidx.camera.extensions.internal.compat.workaround.OnEnableDisableSessionDurationCheck;
import androidx.camera.extensions.internal.sessionprocessor.Camera2OutputConfig;
import androidx.camera.extensions.internal.sessionprocessor.Camera2SessionConfig;
import androidx.camera.extensions.internal.sessionprocessor.Camera2SessionConfigBuilder;
import androidx.camera.extensions.internal.sessionprocessor.ImageProcessor;
import androidx.camera.extensions.internal.sessionprocessor.ImageReaderOutputConfig;
import androidx.camera.extensions.internal.sessionprocessor.ImageReference;
import androidx.camera.extensions.internal.sessionprocessor.PreviewProcessor;
import androidx.camera.extensions.internal.sessionprocessor.RequestBuilder;
import androidx.camera.extensions.internal.sessionprocessor.SessionProcessorBase;
import androidx.camera.extensions.internal.sessionprocessor.StillCaptureProcessor;
import androidx.camera.extensions.internal.sessionprocessor.SurfaceOutputConfig;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@OptIn(markerClass={ExperimentalCamera2Interop.class})
@RequiresApi(value=21)
public class BasicExtenderSessionProcessor
extends SessionProcessorBase {
    private static final String TAG = "BasicSessionProcessor";
    private static final int PREVIEW_PROCESS_MAX_IMAGES = 2;
    @NonNull
    private final Context mContext;
    @NonNull
    private final PreviewExtenderImpl mPreviewExtenderImpl;
    @NonNull
    private final ImageCaptureExtenderImpl mImageCaptureExtenderImpl;
    final Object mLock = new Object();
    volatile StillCaptureProcessor mStillCaptureProcessor = null;
    volatile PreviewProcessor mPreviewProcessor = null;
    volatile RequestUpdateProcessorImpl mRequestUpdateProcessor = null;
    private volatile Camera2OutputConfig mPreviewOutputConfig;
    private volatile Camera2OutputConfig mCaptureOutputConfig;
    @Nullable
    private volatile Camera2OutputConfig mAnalysisOutputConfig = null;
    private volatile OutputSurface mPreviewOutputSurfaceConfig;
    private volatile OutputSurface mCaptureOutputSurfaceConfig;
    private volatile RequestProcessor mRequestProcessor;
    volatile boolean mIsCapturing = false;
    private final AtomicInteger mNextCaptureSequenceId = new AtomicInteger(0);
    static AtomicInteger sLastOutputConfigId = new AtomicInteger(0);
    @GuardedBy(value="mLock")
    private final Map<CaptureRequest.Key<?>, Object> mParameters = new LinkedHashMap();
    private final List<CaptureResult.Key> mSupportedResultKeys;
    private OnEnableDisableSessionDurationCheck mOnEnableDisableSessionDurationCheck = new OnEnableDisableSessionDurationCheck();

    public BasicExtenderSessionProcessor(@NonNull PreviewExtenderImpl previewExtenderImpl, @NonNull ImageCaptureExtenderImpl imageCaptureExtenderImpl, @NonNull List<CaptureRequest.Key> supportedRequestKeys, @NonNull List<CaptureResult.Key> supportedResultKeys, @NonNull Context context) {
        super(supportedRequestKeys);
        this.mPreviewExtenderImpl = previewExtenderImpl;
        this.mImageCaptureExtenderImpl = imageCaptureExtenderImpl;
        this.mSupportedResultKeys = supportedResultKeys;
        this.mContext = context;
    }

    @Override
    @NonNull
    protected Camera2SessionConfig initSessionInternal(@NonNull String cameraId, @NonNull Map<String, CameraCharacteristics> cameraCharacteristicsMap, @NonNull OutputSurface previewSurfaceConfig, @NonNull OutputSurface imageCaptureSurfaceConfig, @Nullable OutputSurface imageAnalysisSurfaceConfig) {
        Logger.d((String)TAG, (String)"PreviewExtenderImpl.onInit");
        this.mPreviewExtenderImpl.onInit(cameraId, cameraCharacteristicsMap.get(cameraId), this.mContext);
        Logger.d((String)TAG, (String)"ImageCaptureExtenderImpl.onInit");
        this.mImageCaptureExtenderImpl.onInit(cameraId, cameraCharacteristicsMap.get(cameraId), this.mContext);
        this.mPreviewOutputSurfaceConfig = previewSurfaceConfig;
        this.mCaptureOutputSurfaceConfig = imageCaptureSurfaceConfig;
        PreviewExtenderImpl.ProcessorType processorType = this.mPreviewExtenderImpl.getProcessorType();
        Logger.d((String)TAG, (String)("preview processorType=" + processorType));
        if (processorType == PreviewExtenderImpl.ProcessorType.PROCESSOR_TYPE_IMAGE_PROCESSOR) {
            this.mPreviewOutputConfig = ImageReaderOutputConfig.create(sLastOutputConfigId.getAndIncrement(), previewSurfaceConfig.getSize(), 35, 2);
            PreviewImageProcessorImpl previewImageProcessor = (PreviewImageProcessorImpl)this.mPreviewExtenderImpl.getProcessor();
            this.mPreviewProcessor = new PreviewProcessor(previewImageProcessor, this.mPreviewOutputSurfaceConfig.getSurface(), this.mPreviewOutputSurfaceConfig.getSize());
        } else if (processorType == PreviewExtenderImpl.ProcessorType.PROCESSOR_TYPE_REQUEST_UPDATE_ONLY) {
            this.mPreviewOutputConfig = SurfaceOutputConfig.create(sLastOutputConfigId.getAndIncrement(), previewSurfaceConfig.getSurface());
            this.mRequestUpdateProcessor = (RequestUpdateProcessorImpl)this.mPreviewExtenderImpl.getProcessor();
        } else {
            this.mPreviewOutputConfig = SurfaceOutputConfig.create(sLastOutputConfigId.getAndIncrement(), previewSurfaceConfig.getSurface());
        }
        CaptureProcessorImpl captureProcessor = this.mImageCaptureExtenderImpl.getCaptureProcessor();
        Logger.d((String)TAG, (String)("CaptureProcessor=" + captureProcessor));
        if (captureProcessor != null) {
            this.mCaptureOutputConfig = ImageReaderOutputConfig.create(sLastOutputConfigId.getAndIncrement(), imageCaptureSurfaceConfig.getSize(), 35, this.mImageCaptureExtenderImpl.getMaxCaptureStage());
            this.mStillCaptureProcessor = new StillCaptureProcessor(captureProcessor, this.mCaptureOutputSurfaceConfig.getSurface(), this.mCaptureOutputSurfaceConfig.getSize());
        } else {
            this.mCaptureOutputConfig = SurfaceOutputConfig.create(sLastOutputConfigId.getAndIncrement(), imageCaptureSurfaceConfig.getSurface());
        }
        if (imageAnalysisSurfaceConfig != null) {
            this.mAnalysisOutputConfig = SurfaceOutputConfig.create(sLastOutputConfigId.getAndIncrement(), imageAnalysisSurfaceConfig.getSurface());
        }
        Camera2SessionConfigBuilder builder = new Camera2SessionConfigBuilder().addOutputConfig(this.mPreviewOutputConfig).addOutputConfig(this.mCaptureOutputConfig).setSessionTemplateId(1);
        if (this.mAnalysisOutputConfig != null) {
            builder.addOutputConfig(this.mAnalysisOutputConfig);
        }
        CaptureStageImpl captureStagePreview = this.mPreviewExtenderImpl.onPresetSession();
        Logger.d((String)TAG, (String)("preview onPresetSession:" + captureStagePreview));
        CaptureStageImpl captureStageCapture = this.mImageCaptureExtenderImpl.onPresetSession();
        Logger.d((String)TAG, (String)("capture onPresetSession:" + captureStageCapture));
        if (captureStagePreview != null && captureStagePreview.getParameters() != null) {
            for (Pair parameter : captureStagePreview.getParameters()) {
                builder.addSessionParameter((CaptureRequest.Key)parameter.first, parameter.second);
            }
        }
        if (captureStageCapture != null && captureStageCapture.getParameters() != null) {
            for (Pair parameter : captureStageCapture.getParameters()) {
                builder.addSessionParameter((CaptureRequest.Key)parameter.first, parameter.second);
            }
        }
        return builder.build();
    }

    @Override
    protected void deInitSessionInternal() {
        Logger.d((String)TAG, (String)"preview onDeInit");
        this.mPreviewExtenderImpl.onDeInit();
        Logger.d((String)TAG, (String)"capture onDeInit");
        this.mImageCaptureExtenderImpl.onDeInit();
        if (this.mPreviewProcessor != null) {
            this.mPreviewProcessor.close();
            this.mPreviewProcessor = null;
        }
        if (this.mStillCaptureProcessor != null) {
            this.mStillCaptureProcessor.close();
            this.mStillCaptureProcessor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameters(@NonNull Config config) {
        Object object = this.mLock;
        synchronized (object) {
            HashMap<CaptureRequest.Key, Object> map = new HashMap<CaptureRequest.Key, Object>();
            CaptureRequestOptions options = CaptureRequestOptions.Builder.from((Config)config).build();
            for (Config.Option option : options.listOptions()) {
                CaptureRequest.Key key = (CaptureRequest.Key)option.getToken();
                map.put(key, options.retrieveOption(option));
            }
            this.mParameters.clear();
            this.mParameters.putAll(map);
            this.applyRotationAndJpegQualityToProcessor();
        }
    }

    public void onCaptureSessionStart(@NonNull RequestProcessor requestProcessor) {
        this.mRequestProcessor = requestProcessor;
        ArrayList<CaptureStageImpl> captureStages = new ArrayList<CaptureStageImpl>();
        CaptureStageImpl captureStage1 = this.mPreviewExtenderImpl.onEnableSession();
        Logger.d((String)TAG, (String)("preview onEnableSession: " + captureStage1));
        if (captureStage1 != null) {
            captureStages.add(captureStage1);
        }
        CaptureStageImpl captureStage2 = this.mImageCaptureExtenderImpl.onEnableSession();
        Logger.d((String)TAG, (String)("capture onEnableSession:" + captureStage2));
        if (captureStage2 != null) {
            captureStages.add(captureStage2);
        }
        this.mOnEnableDisableSessionDurationCheck.onEnableSessionInvoked();
        if (!captureStages.isEmpty()) {
            this.submitRequestByCaptureStages(requestProcessor, captureStages);
        }
        if (this.mPreviewProcessor != null) {
            this.setImageProcessor(this.mPreviewOutputConfig.getId(), new ImageProcessor(){

                @Override
                public void onNextImageAvailable(int outputStreamId, long timestampNs, @NonNull ImageReference imageReference, @Nullable String physicalCameraId) {
                    if (BasicExtenderSessionProcessor.this.mPreviewProcessor != null) {
                        BasicExtenderSessionProcessor.this.mPreviewProcessor.notifyImage(imageReference);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyParameters(RequestBuilder builder) {
        Object object = this.mLock;
        synchronized (object) {
            for (CaptureRequest.Key<?> key : this.mParameters.keySet()) {
                Object value = this.mParameters.get(key);
                if (value == null) continue;
                builder.setParameters(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRotationAndJpegQualityToProcessor() {
        Object object = this.mLock;
        synchronized (object) {
            Byte qualityObj;
            if (this.mStillCaptureProcessor == null) {
                return;
            }
            Integer orientationObj = (Integer)this.mParameters.get(CaptureRequest.JPEG_ORIENTATION);
            if (orientationObj != null) {
                this.mStillCaptureProcessor.setRotationDegrees(orientationObj);
            }
            if ((qualityObj = (Byte)this.mParameters.get(CaptureRequest.JPEG_QUALITY)) != null) {
                this.mStillCaptureProcessor.setJpegQuality(qualityObj.byteValue());
            }
        }
    }

    private void submitRequestByCaptureStages(RequestProcessor requestProcessor, List<CaptureStageImpl> captureStageList) {
        ArrayList<RequestProcessor.Request> requestList = new ArrayList<RequestProcessor.Request>();
        for (CaptureStageImpl captureStage : captureStageList) {
            RequestBuilder builder = new RequestBuilder();
            builder.addTargetOutputConfigIds(this.mPreviewOutputConfig.getId());
            if (this.mAnalysisOutputConfig != null) {
                builder.addTargetOutputConfigIds(this.mAnalysisOutputConfig.getId());
            }
            for (Pair keyObjectPair : captureStage.getParameters()) {
                builder.setParameters((CaptureRequest.Key)keyObjectPair.first, keyObjectPair.second);
            }
            builder.setTemplateId(1);
            requestList.add(builder.build());
        }
        requestProcessor.submit(requestList, new RequestProcessor.Callback(){});
    }

    public void onCaptureSessionEnd() {
        this.mOnEnableDisableSessionDurationCheck.onDisableSessionInvoked();
        ArrayList<CaptureStageImpl> captureStages = new ArrayList<CaptureStageImpl>();
        CaptureStageImpl captureStage1 = this.mPreviewExtenderImpl.onDisableSession();
        Logger.d((String)TAG, (String)("preview onDisableSession: " + captureStage1));
        if (captureStage1 != null) {
            captureStages.add(captureStage1);
        }
        CaptureStageImpl captureStage2 = this.mImageCaptureExtenderImpl.onDisableSession();
        Logger.d((String)TAG, (String)("capture onDisableSession:" + captureStage2));
        if (captureStage2 != null) {
            captureStages.add(captureStage2);
        }
        if (!captureStages.isEmpty()) {
            this.submitRequestByCaptureStages(this.mRequestProcessor, captureStages);
        }
        this.mRequestProcessor = null;
        this.mIsCapturing = false;
    }

    Map<CaptureResult.Key, Object> getCaptureResultKeyMapFromList(List<Pair<CaptureResult.Key, Object>> list) {
        HashMap<CaptureResult.Key, Object> map = new HashMap<CaptureResult.Key, Object>();
        for (Pair<CaptureResult.Key, Object> pair : list) {
            map.put((CaptureResult.Key)pair.first, pair.second);
        }
        return map;
    }

    Map<CaptureResult.Key, Object> getCaptureResultKeyMaps(TotalCaptureResult captureResult) {
        HashMap<CaptureResult.Key, Object> map = new HashMap<CaptureResult.Key, Object>();
        for (CaptureResult.Key key : captureResult.getKeys()) {
            if (!this.mSupportedResultKeys.contains(key)) continue;
            map.put(key, captureResult.get(key));
        }
        return map;
    }

    public int startRepeating(@NonNull SessionProcessor.CaptureCallback captureCallback) {
        int repeatingCaptureSequenceId = this.mNextCaptureSequenceId.getAndIncrement();
        if (this.mRequestProcessor == null) {
            captureCallback.onCaptureFailed(repeatingCaptureSequenceId);
            captureCallback.onCaptureSequenceAborted(repeatingCaptureSequenceId);
        } else {
            if (this.mPreviewProcessor != null) {
                this.mPreviewProcessor.start((shutterTimestamp, result) -> captureCallback.onCaptureCompleted(shutterTimestamp, repeatingCaptureSequenceId, this.getCaptureResultKeyMapFromList(result)));
            }
            this.updateRepeating(repeatingCaptureSequenceId, captureCallback);
        }
        return repeatingCaptureSequenceId;
    }

    void updateRepeating(final int repeatingCaptureSequenceId, final @NonNull SessionProcessor.CaptureCallback captureCallback) {
        if (this.mRequestProcessor == null) {
            Logger.d((String)TAG, (String)"mRequestProcessor is null, ignore repeating request");
            return;
        }
        RequestBuilder builder = new RequestBuilder();
        builder.addTargetOutputConfigIds(this.mPreviewOutputConfig.getId());
        if (this.mAnalysisOutputConfig != null) {
            builder.addTargetOutputConfigIds(this.mAnalysisOutputConfig.getId());
        }
        builder.setTemplateId(1);
        this.applyParameters(builder);
        this.applyPreviewStagesParameters(builder);
        RequestProcessor.Callback callback = new RequestProcessor.Callback(){

            public void onCaptureCompleted(@NonNull RequestProcessor.Request request, @NonNull CameraCaptureResult cameraCaptureResult) {
                CaptureStageImpl captureStage;
                Long timestamp;
                CaptureResult captureResult = Camera2CameraCaptureResultConverter.getCaptureResult((CameraCaptureResult)cameraCaptureResult);
                Preconditions.checkArgument((boolean)(captureResult instanceof TotalCaptureResult), (Object)"Cannot get TotalCaptureResult from the cameraCaptureResult ");
                TotalCaptureResult totalCaptureResult = (TotalCaptureResult)captureResult;
                if (BasicExtenderSessionProcessor.this.mPreviewProcessor != null) {
                    BasicExtenderSessionProcessor.this.mPreviewProcessor.notifyCaptureResult(totalCaptureResult);
                } else if (ClientVersion.isMinimumCompatibleVersion(Version.VERSION_1_3) && ExtensionVersion.isMinimumCompatibleVersion(Version.VERSION_1_3) && (timestamp = (Long)totalCaptureResult.get(CaptureResult.SENSOR_TIMESTAMP)) != null) {
                    captureCallback.onCaptureCompleted(timestamp.longValue(), repeatingCaptureSequenceId, BasicExtenderSessionProcessor.this.getCaptureResultKeyMaps(totalCaptureResult));
                }
                if (BasicExtenderSessionProcessor.this.mRequestUpdateProcessor != null && (captureStage = BasicExtenderSessionProcessor.this.mRequestUpdateProcessor.process(totalCaptureResult)) != null) {
                    BasicExtenderSessionProcessor.this.updateRepeating(repeatingCaptureSequenceId, captureCallback);
                }
                captureCallback.onCaptureSequenceCompleted(repeatingCaptureSequenceId);
            }
        };
        Logger.d((String)TAG, (String)"requestProcessor setRepeating");
        this.mRequestProcessor.setRepeating(builder.build(), callback);
    }

    private void applyPreviewStagesParameters(RequestBuilder builder) {
        CaptureStageImpl captureStage = this.mPreviewExtenderImpl.getCaptureStage();
        if (captureStage != null) {
            for (Pair keyObjectPair : captureStage.getParameters()) {
                builder.setParameters((CaptureRequest.Key)keyObjectPair.first, keyObjectPair.second);
            }
        }
    }

    public void stopRepeating() {
        this.mRequestProcessor.stopRepeating();
    }

    public int startCapture(final @NonNull SessionProcessor.CaptureCallback captureCallback) {
        final int captureSequenceId = this.mNextCaptureSequenceId.getAndIncrement();
        if (this.mRequestProcessor == null || this.mIsCapturing) {
            Logger.d((String)TAG, (String)"startCapture failed");
            captureCallback.onCaptureFailed(captureSequenceId);
            captureCallback.onCaptureSequenceAborted(captureSequenceId);
            return captureSequenceId;
        }
        this.mIsCapturing = true;
        ArrayList<RequestProcessor.Request> requestList = new ArrayList<RequestProcessor.Request>();
        List captureStages = this.mImageCaptureExtenderImpl.getCaptureStages();
        ArrayList<Integer> captureIdList = new ArrayList<Integer>();
        for (CaptureStageImpl captureStage : captureStages) {
            RequestBuilder builder = new RequestBuilder();
            builder.addTargetOutputConfigIds(this.mCaptureOutputConfig.getId());
            builder.setTemplateId(2);
            builder.setCaptureStageId(captureStage.getId());
            captureIdList.add(captureStage.getId());
            this.applyParameters(builder);
            this.applyPreviewStagesParameters(builder);
            for (Pair keyObjectPair : captureStage.getParameters()) {
                builder.setParameters((CaptureRequest.Key)keyObjectPair.first, keyObjectPair.second);
            }
            requestList.add(builder.build());
        }
        Logger.d((String)TAG, (String)("Wait for capture stage id: " + captureIdList));
        RequestProcessor.Callback callback = new RequestProcessor.Callback(){
            boolean mIsCaptureFailed = false;
            boolean mIsCaptureStarted = false;

            public void onCaptureStarted(@NonNull RequestProcessor.Request request, long frameNumber, long timestamp) {
                if (!this.mIsCaptureStarted) {
                    this.mIsCaptureStarted = true;
                    captureCallback.onCaptureStarted(captureSequenceId, timestamp);
                }
            }

            public void onCaptureCompleted(@NonNull RequestProcessor.Request request, @NonNull CameraCaptureResult cameraCaptureResult) {
                CaptureResult captureResult = Camera2CameraCaptureResultConverter.getCaptureResult((CameraCaptureResult)cameraCaptureResult);
                Preconditions.checkArgument((boolean)(captureResult instanceof TotalCaptureResult), (Object)"Cannot get capture TotalCaptureResult from the cameraCaptureResult ");
                TotalCaptureResult totalCaptureResult = (TotalCaptureResult)captureResult;
                RequestBuilder.RequestProcessorRequest requestProcessorRequest = (RequestBuilder.RequestProcessorRequest)request;
                if (BasicExtenderSessionProcessor.this.mStillCaptureProcessor != null) {
                    BasicExtenderSessionProcessor.this.mStillCaptureProcessor.notifyCaptureResult(totalCaptureResult, requestProcessorRequest.getCaptureStageId());
                } else {
                    captureCallback.onCaptureProcessStarted(captureSequenceId);
                    captureCallback.onCaptureSequenceCompleted(captureSequenceId);
                    BasicExtenderSessionProcessor.this.mIsCapturing = false;
                }
            }

            public void onCaptureFailed(@NonNull RequestProcessor.Request request, @NonNull CameraCaptureFailure captureFailure) {
                if (!this.mIsCaptureFailed) {
                    this.mIsCaptureFailed = true;
                    captureCallback.onCaptureFailed(captureSequenceId);
                    captureCallback.onCaptureSequenceAborted(captureSequenceId);
                    BasicExtenderSessionProcessor.this.mIsCapturing = false;
                }
            }

            public void onCaptureSequenceAborted(int sequenceId) {
                captureCallback.onCaptureSequenceAborted(captureSequenceId);
                BasicExtenderSessionProcessor.this.mIsCapturing = false;
            }
        };
        Logger.d((String)TAG, (String)"startCapture");
        if (this.mStillCaptureProcessor != null) {
            this.mStillCaptureProcessor.startCapture(captureIdList, new StillCaptureProcessor.OnCaptureResultCallback(){

                @Override
                public void onCompleted() {
                    captureCallback.onCaptureSequenceCompleted(captureSequenceId);
                    BasicExtenderSessionProcessor.this.mIsCapturing = false;
                }

                @Override
                public void onError(@NonNull Exception e) {
                    captureCallback.onCaptureFailed(captureSequenceId);
                    BasicExtenderSessionProcessor.this.mIsCapturing = false;
                }

                @Override
                public void onCaptureResult(long shutterTimestamp, @NonNull List<Pair<CaptureResult.Key, Object>> result) {
                    captureCallback.onCaptureCompleted(shutterTimestamp, captureSequenceId, BasicExtenderSessionProcessor.this.getCaptureResultKeyMapFromList(result));
                }
            });
        }
        this.setImageProcessor(this.mCaptureOutputConfig.getId(), new ImageProcessor(){
            boolean mIsFirstFrame = true;

            @Override
            public void onNextImageAvailable(int outputStreamId, long timestampNs, @NonNull ImageReference imageReference, @Nullable String physicalCameraId) {
                Logger.d((String)BasicExtenderSessionProcessor.TAG, (String)("onNextImageAvailable  outputStreamId=" + outputStreamId));
                if (BasicExtenderSessionProcessor.this.mStillCaptureProcessor != null) {
                    BasicExtenderSessionProcessor.this.mStillCaptureProcessor.notifyImage(imageReference);
                }
                if (this.mIsFirstFrame) {
                    captureCallback.onCaptureProcessStarted(captureSequenceId);
                    this.mIsFirstFrame = false;
                }
            }
        });
        this.mRequestProcessor.submit(requestList, callback);
        return captureSequenceId;
    }

    public void abortCapture(int captureSequenceId) {
        this.mRequestProcessor.abortCaptures();
    }

    public int startTrigger(@NonNull Config config, final @NonNull SessionProcessor.CaptureCallback callback) {
        Logger.d((String)TAG, (String)"startTrigger");
        final int captureSequenceId = this.mNextCaptureSequenceId.getAndIncrement();
        RequestBuilder builder = new RequestBuilder();
        builder.addTargetOutputConfigIds(this.mPreviewOutputConfig.getId());
        if (this.mAnalysisOutputConfig != null) {
            builder.addTargetOutputConfigIds(this.mAnalysisOutputConfig.getId());
        }
        builder.setTemplateId(1);
        this.applyParameters(builder);
        this.applyPreviewStagesParameters(builder);
        CaptureRequestOptions options = CaptureRequestOptions.Builder.from((Config)config).build();
        for (Config.Option option : options.listOptions()) {
            CaptureRequest.Key key = (CaptureRequest.Key)option.getToken();
            builder.setParameters(key, options.retrieveOption(option));
        }
        this.mRequestProcessor.submit(builder.build(), new RequestProcessor.Callback(){

            public void onCaptureCompleted(@NonNull RequestProcessor.Request request, @NonNull CameraCaptureResult captureResult) {
                callback.onCaptureSequenceCompleted(captureSequenceId);
            }

            public void onCaptureFailed(@NonNull RequestProcessor.Request request, @NonNull CameraCaptureFailure captureFailure) {
                callback.onCaptureFailed(captureSequenceId);
            }
        });
        return captureSequenceId;
    }

    @Nullable
    public Pair<Long, Long> getRealtimeCaptureLatency() {
        if (ClientVersion.isMinimumCompatibleVersion(Version.VERSION_1_4) && ExtensionVersion.isMinimumCompatibleVersion(Version.VERSION_1_4)) {
            return this.mImageCaptureExtenderImpl.getRealtimeCaptureLatency();
        }
        return null;
    }
}

