/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.sessionprocessor;

import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.extensions.impl.PreviewImageProcessorImpl;
import androidx.camera.extensions.impl.ProcessResultImpl;
import androidx.camera.extensions.internal.ClientVersion;
import androidx.camera.extensions.internal.ExtensionVersion;
import androidx.camera.extensions.internal.Version;
import androidx.camera.extensions.internal.sessionprocessor.CaptureResultImageMatcher;
import androidx.camera.extensions.internal.sessionprocessor.ImageReference;
import java.util.List;

@RequiresApi(value=21)
class PreviewProcessor {
    private static final String TAG = "PreviewProcessor";
    @NonNull
    final PreviewImageProcessorImpl mPreviewImageProcessor;
    @NonNull
    final CaptureResultImageMatcher mCaptureResultImageMatcher = new CaptureResultImageMatcher();
    final Object mLock = new Object();
    @GuardedBy(value="mLock")
    boolean mIsClosed = false;

    PreviewProcessor(@NonNull PreviewImageProcessorImpl previewImageProcessor, @NonNull Surface previewOutputSurface, @NonNull Size surfaceSize) {
        this.mPreviewImageProcessor = previewImageProcessor;
        this.mPreviewImageProcessor.onResolutionUpdate(surfaceSize);
        this.mPreviewImageProcessor.onOutputSurface(previewOutputSurface, 1);
        this.mPreviewImageProcessor.onImageFormatUpdate(35);
    }

    void start(final @NonNull OnCaptureResultCallback onResultCallback) {
        this.mCaptureResultImageMatcher.setImageReferenceListener((imageReference, totalCaptureResult, captureStageId) -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mIsClosed) {
                    imageReference.decrement();
                    Logger.d((String)TAG, (String)"Ignore image in closed state");
                    return;
                }
                if (ClientVersion.isMinimumCompatibleVersion(Version.VERSION_1_3) && ExtensionVersion.isMinimumCompatibleVersion(Version.VERSION_1_3)) {
                    this.mPreviewImageProcessor.process(imageReference.get(), totalCaptureResult, new ProcessResultImpl(){

                        public void onCaptureCompleted(long shutterTimestamp, @NonNull List<Pair<CaptureResult.Key, Object>> result) {
                            onResultCallback.onCaptureResult(shutterTimestamp, result);
                        }

                        public void onCaptureProcessProgressed(int progress) {
                        }
                    }, CameraXExecutors.ioExecutor());
                } else {
                    this.mPreviewImageProcessor.process(imageReference.get(), totalCaptureResult);
                }
                imageReference.decrement();
            }
        });
    }

    void notifyCaptureResult(@NonNull TotalCaptureResult captureResult) {
        this.mCaptureResultImageMatcher.captureResultIncoming(captureResult);
    }

    void notifyImage(@NonNull ImageReference imageReference) {
        this.mCaptureResultImageMatcher.imageIncoming(imageReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.mLock;
        synchronized (object) {
            this.mIsClosed = true;
            this.mCaptureResultImageMatcher.clear();
            this.mCaptureResultImageMatcher.clearImageReferenceListener();
        }
    }

    static interface OnCaptureResultCallback {
        public void onCaptureResult(long var1, @NonNull List<Pair<CaptureResult.Key, Object>> var3);
    }
}

