/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.sessionprocessor;

import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.RequestProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@OptIn(markerClass={ExperimentalCamera2Interop.class})
@RequiresApi(value=21)
class RequestBuilder {
    private List<Integer> mTargetOutputConfigIds = new ArrayList<Integer>();
    private Map<CaptureRequest.Key<?>, Object> mParameters = new HashMap();
    private int mTemplateId = 1;
    int mCaptureStageId;

    RequestBuilder() {
    }

    @NonNull
    RequestBuilder addTargetOutputConfigIds(int targetOutputConfigId) {
        this.mTargetOutputConfigIds.add(targetOutputConfigId);
        return this;
    }

    @NonNull
    RequestBuilder setParameters(@NonNull CaptureRequest.Key<?> key, @NonNull Object value) {
        this.mParameters.put(key, value);
        return this;
    }

    @NonNull
    RequestBuilder setTemplateId(int templateId) {
        this.mTemplateId = templateId;
        return this;
    }

    @NonNull
    public RequestBuilder setCaptureStageId(int captureStageId) {
        this.mCaptureStageId = captureStageId;
        return this;
    }

    @NonNull
    RequestProcessor.Request build() {
        return new RequestProcessorRequest(this.mTargetOutputConfigIds, this.mParameters, this.mTemplateId, this.mCaptureStageId);
    }

    static class RequestProcessorRequest
    implements RequestProcessor.Request {
        final List<Integer> mTargetOutputConfigIds;
        final Config mParameterConfig;
        final int mTemplateId;
        final int mCaptureStageId;

        RequestProcessorRequest(List<Integer> targetOutputConfigIds, Map<CaptureRequest.Key<?>, Object> parameters, int templateId, int captureStageId) {
            this.mTargetOutputConfigIds = targetOutputConfigIds;
            this.mTemplateId = templateId;
            this.mCaptureStageId = captureStageId;
            Camera2ImplConfig.Builder camera2ConfigBuilder = new Camera2ImplConfig.Builder();
            Iterator<CaptureRequest.Key<?>> iterator = parameters.keySet().iterator();
            while (iterator.hasNext()) {
                CaptureRequest.Key<?> key;
                CaptureRequest.Key<?> objKey = key = iterator.next();
                camera2ConfigBuilder.setCaptureRequestOption(objKey, parameters.get(objKey));
            }
            this.mParameterConfig = camera2ConfigBuilder.build();
        }

        @NonNull
        public List<Integer> getTargetOutputConfigIds() {
            return this.mTargetOutputConfigIds;
        }

        @NonNull
        public Config getParameters() {
            return this.mParameterConfig;
        }

        public int getTemplateId() {
            return this.mTemplateId;
        }

        public int getCaptureStageId() {
            return this.mCaptureStageId;
        }
    }
}

