/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.sessionprocessor;

import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.Camera2CameraCaptureResult;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxys;
import androidx.camera.core.Logger;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.CameraCaptureResultImageInfo;
import androidx.camera.extensions.impl.CaptureProcessorImpl;
import androidx.camera.extensions.impl.ProcessResultImpl;
import androidx.camera.extensions.internal.ClientVersion;
import androidx.camera.extensions.internal.ExtensionVersion;
import androidx.camera.extensions.internal.Version;
import androidx.camera.extensions.internal.sessionprocessor.CaptureResultImageMatcher;
import androidx.camera.extensions.internal.sessionprocessor.ImageReference;
import androidx.camera.extensions.internal.sessionprocessor.YuvToJpegConverter;
import java.util.HashMap;
import java.util.List;

@RequiresApi(value=21)
class StillCaptureProcessor {
    private static final String TAG = "StillCaptureProcessor";
    private static final int MAX_IMAGES = 2;
    @NonNull
    final CaptureProcessorImpl mCaptureProcessorImpl;
    @NonNull
    final CaptureResultImageMatcher mCaptureResultImageMatcher = new CaptureResultImageMatcher();
    @NonNull
    final ImageReaderProxy mProcessedYuvImageReader;
    @NonNull
    YuvToJpegConverter mYuvToJpegConverter;
    final Object mLock = new Object();
    @GuardedBy(value="mLock")
    @NonNull
    HashMap<Integer, Pair<ImageReference, TotalCaptureResult>> mCaptureResults = new HashMap();
    @GuardedBy(value="mLock")
    OnCaptureResultCallback mOnCaptureResultCallback = null;
    @GuardedBy(value="mLock")
    TotalCaptureResult mSourceCaptureResult = null;
    @GuardedBy(value="mLock")
    boolean mIsClosed = false;

    StillCaptureProcessor(@NonNull CaptureProcessorImpl captureProcessorImpl, @NonNull Surface captureOutputSurface, @NonNull Size surfaceSize) {
        this.mCaptureProcessorImpl = captureProcessorImpl;
        this.mProcessedYuvImageReader = ImageReaderProxys.createIsolatedReader((int)surfaceSize.getWidth(), (int)surfaceSize.getHeight(), (int)35, (int)2);
        this.mYuvToJpegConverter = new YuvToJpegConverter(100, captureOutputSurface);
        this.mProcessedYuvImageReader.setOnImageAvailableListener(imageReader -> {
            OnCaptureResultCallback onCaptureResultCallback = null;
            YuvToJpegConverter.ConversionFailedException errorException = null;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mIsClosed) {
                    Logger.d((String)TAG, (String)"Ignore JPEG processing in closed state");
                    return;
                }
                ImageProxy imageProxy = imageReader.acquireNextImage();
                if (this.mSourceCaptureResult != null) {
                    imageProxy = new SettableImageProxy(imageProxy, null, (ImageInfo)new CameraCaptureResultImageInfo((CameraCaptureResult)new Camera2CameraCaptureResult((CaptureResult)this.mSourceCaptureResult)));
                    this.mSourceCaptureResult = null;
                }
                if (imageProxy != null) {
                    try {
                        this.mYuvToJpegConverter.writeYuvImage(imageProxy);
                    }
                    catch (YuvToJpegConverter.ConversionFailedException e) {
                        errorException = e;
                    }
                    if (this.mOnCaptureResultCallback != null) {
                        onCaptureResultCallback = this.mOnCaptureResultCallback;
                        this.mOnCaptureResultCallback = null;
                    }
                }
            }
            if (onCaptureResultCallback != null) {
                if (errorException != null) {
                    onCaptureResultCallback.onError(errorException);
                } else {
                    onCaptureResultCallback.onCompleted();
                }
            }
        }, CameraXExecutors.ioExecutor());
        this.mCaptureProcessorImpl.onOutputSurface(this.mProcessedYuvImageReader.getSurface(), 35);
        this.mCaptureProcessorImpl.onImageFormatUpdate(35);
        this.mCaptureProcessorImpl.onResolutionUpdate(surfaceSize);
    }

    StillCaptureProcessor(@NonNull CaptureProcessorImpl captureProcessorImpl, @NonNull Surface captureOutputSurface, @NonNull Size surfaceSize, @NonNull YuvToJpegConverter yuvToJpegConverter) {
        this(captureProcessorImpl, captureOutputSurface, surfaceSize);
        this.mYuvToJpegConverter = yuvToJpegConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCaptureResults() {
        Object object = this.mLock;
        synchronized (object) {
            for (Pair<ImageReference, TotalCaptureResult> value : this.mCaptureResults.values()) {
                ((ImageReference)value.first).decrement();
            }
            this.mCaptureResults.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCapture(@NonNull List<Integer> captureIdList, final @NonNull OnCaptureResultCallback onCaptureResultCallback) {
        Logger.d((String)TAG, (String)"Start the processor");
        Object object = this.mLock;
        synchronized (object) {
            this.mOnCaptureResultCallback = onCaptureResultCallback;
            this.clearCaptureResults();
        }
        this.mCaptureResultImageMatcher.clear();
        this.mCaptureResultImageMatcher.setImageReferenceListener((imageReference, totalCaptureResult, captureStageId) -> {
            Exception errorException = null;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mIsClosed) {
                    imageReference.decrement();
                    Logger.d((String)TAG, (String)"Ignore image in closed state");
                    return;
                }
                Logger.d((String)TAG, (String)("onImageReferenceIncoming  captureStageId=" + captureStageId));
                this.mCaptureResults.put(captureStageId, (Pair<ImageReference, TotalCaptureResult>)new Pair((Object)imageReference, (Object)totalCaptureResult));
                Logger.d((String)TAG, (String)("mCaptureResult has capture stage Id: " + this.mCaptureResults.keySet()));
                if (this.mCaptureResults.keySet().containsAll(captureIdList)) {
                    HashMap<Integer, Pair> convertedResult = new HashMap<Integer, Pair>();
                    for (Integer id : this.mCaptureResults.keySet()) {
                        Pair<ImageReference, TotalCaptureResult> pair = this.mCaptureResults.get(id);
                        convertedResult.put(id, new Pair((Object)((ImageReference)pair.first).get(), (Object)((TotalCaptureResult)pair.second)));
                    }
                    Logger.d((String)TAG, (String)"CaptureProcessorImpl.process()");
                    try {
                        if (ExtensionVersion.isMinimumCompatibleVersion(Version.VERSION_1_3) && ClientVersion.isMinimumCompatibleVersion(Version.VERSION_1_3)) {
                            this.mCaptureProcessorImpl.process(convertedResult, new ProcessResultImpl(){

                                public void onCaptureCompleted(long shutterTimestamp, @NonNull List<Pair<CaptureResult.Key, Object>> result) {
                                    onCaptureResultCallback.onCaptureResult(shutterTimestamp, result);
                                }

                                public void onCaptureProcessProgressed(int progress) {
                                }
                            }, CameraXExecutors.ioExecutor());
                        } else {
                            this.mCaptureProcessorImpl.process(convertedResult);
                        }
                    }
                    catch (Exception e) {
                        this.mOnCaptureResultCallback = null;
                        errorException = e;
                    }
                    this.clearCaptureResults();
                }
            }
            if (errorException != null && onCaptureResultCallback != null) {
                onCaptureResultCallback.onError(errorException);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCaptureResult(@NonNull TotalCaptureResult captureResult, int captureStageId) {
        this.mCaptureResultImageMatcher.captureResultIncoming(captureResult, captureStageId);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSourceCaptureResult == null) {
                this.mSourceCaptureResult = captureResult;
            }
        }
    }

    void notifyImage(@NonNull ImageReference imageReference) {
        this.mCaptureResultImageMatcher.imageIncoming(imageReference);
    }

    void setJpegQuality(@IntRange(from=0L, to=100L) int quality) {
        this.mYuvToJpegConverter.setJpegQuality(quality);
    }

    void setRotationDegrees(int rotationDegrees) {
        this.mYuvToJpegConverter.setRotationDegrees(rotationDegrees);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Logger.d((String)TAG, (String)"Close the processor");
        Object object = this.mLock;
        synchronized (object) {
            this.mIsClosed = true;
            this.clearCaptureResults();
            this.mProcessedYuvImageReader.clearOnImageAvailableListener();
            this.mCaptureResultImageMatcher.clearImageReferenceListener();
            this.mCaptureResultImageMatcher.clear();
            this.mProcessedYuvImageReader.close();
        }
    }

    static interface OnCaptureResultCallback {
        public void onCompleted();

        public void onCaptureResult(long var1, @NonNull List<Pair<CaptureResult.Key, Object>> var3);

        public void onError(@NonNull Exception var1);
    }
}

