/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.Identifier;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.UseCaseConfigFactory;

@RequiresApi(value=21)
class ExtensionsConfig
implements CameraConfig {
    public static final Config.Option<Integer> OPTION_EXTENSION_MODE = Config.Option.create((String)"camerax.extensions.extensionMode", Integer.TYPE);
    private final Config mConfig;

    ExtensionsConfig(Config config) {
        this.mConfig = config;
    }

    @NonNull
    public Config getConfig() {
        return this.mConfig;
    }

    public int getExtensionMode() {
        return (Integer)this.retrieveOption(OPTION_EXTENSION_MODE);
    }

    @NonNull
    public Identifier getCompatibilityId() {
        return (Identifier)this.retrieveOption(OPTION_COMPATIBILITY_ID);
    }

    static final class Builder
    implements CameraConfig.Builder<Builder> {
        private final MutableOptionsBundle mConfig = MutableOptionsBundle.create();

        Builder() {
        }

        ExtensionsConfig build() {
            return new ExtensionsConfig((Config)this.mConfig);
        }

        public Builder setExtensionMode(int mode) {
            this.mConfig.insertOption(OPTION_EXTENSION_MODE, (Object)mode);
            return this;
        }

        @NonNull
        public Builder setUseCaseConfigFactory(@NonNull UseCaseConfigFactory factory) {
            this.mConfig.insertOption(CameraConfig.OPTION_USECASE_CONFIG_FACTORY, (Object)factory);
            return this;
        }

        @NonNull
        public Builder setCompatibilityId(@NonNull Identifier identifier) {
            this.mConfig.insertOption(CameraConfig.OPTION_COMPATIBILITY_ID, (Object)identifier);
            return this;
        }

        @NonNull
        public Builder setUseCaseCombinationRequiredRule(int useCaseCombinationRequiredRule) {
            this.mConfig.insertOption(CameraConfig.OPTION_USE_CASE_COMBINATION_REQUIRED_RULE, (Object)useCaseCombinationRequiredRule);
            return this;
        }

        @NonNull
        public Builder setSessionProcessor(@NonNull SessionProcessor sessionProcessor) {
            this.mConfig.insertOption(CameraConfig.OPTION_SESSION_PROCESSOR, (Object)sessionProcessor);
            return this;
        }

        @NonNull
        public Builder setZslDisabled(boolean disabled) {
            this.mConfig.insertOption(CameraConfig.OPTION_ZSL_DISABLED, (Object)disabled);
            return this;
        }

        @NonNull
        public Builder setPostviewSupported(boolean supported) {
            this.mConfig.insertOption(CameraConfig.OPTION_POSTVIEW_SUPPORTED, (Object)supported);
            return this;
        }

        @NonNull
        public Builder setCaptureProcessProgressSupported(boolean supported) {
            this.mConfig.insertOption(CameraConfig.OPTION_CAPTURE_PROCESS_PROGRESS_SUPPORTED, (Object)supported);
            return this;
        }
    }
}

