/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions;

import android.os.Build;
import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraProvider;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.impl.CameraConfigProvider;
import androidx.camera.core.impl.ExtendedCameraConfigProviderStore;
import androidx.camera.core.impl.Identifier;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.extensions.ExtensionCameraFilter;
import androidx.camera.extensions.ExtensionsConfig;
import androidx.camera.extensions.VendorExtenderFactory;
import androidx.camera.extensions.internal.AdvancedVendorExtender;
import androidx.camera.extensions.internal.BasicVendorExtender;
import androidx.camera.extensions.internal.ExtensionVersion;
import androidx.camera.extensions.internal.ExtensionsUseCaseConfigFactory;
import androidx.camera.extensions.internal.VendorExtender;
import androidx.camera.extensions.internal.Version;
import java.util.List;

@RequiresApi(value=21)
final class ExtensionsInfo {
    private static final String EXTENDED_CAMERA_CONFIG_PROVIDER_ID_PREFIX = ":camera:camera-extensions-";
    private final CameraProvider mCameraProvider;
    @NonNull
    private VendorExtenderFactory mVendorExtenderFactory;

    ExtensionsInfo(@NonNull CameraProvider cameraProvider) {
        this.mCameraProvider = cameraProvider;
        this.mVendorExtenderFactory = extensionMode -> ExtensionsInfo.getVendorExtender(extensionMode);
    }

    @NonNull
    CameraSelector getExtensionCameraSelectorAndInjectCameraConfig(@NonNull CameraSelector baseCameraSelector, int mode) {
        if (!this.isExtensionAvailable(baseCameraSelector, mode)) {
            throw new IllegalArgumentException("No camera can be found to support the specified extensions mode! isExtensionAvailable should be checked first before calling getExtensionEnabledCameraSelector.");
        }
        for (CameraFilter cameraFilter : baseCameraSelector.getCameraFilterSet()) {
            if (!(cameraFilter instanceof ExtensionCameraFilter)) continue;
            throw new IllegalArgumentException("An extension is already applied to the base CameraSelector.");
        }
        this.injectExtensionCameraConfig(mode);
        CameraSelector.Builder builder = CameraSelector.Builder.fromSelector((CameraSelector)baseCameraSelector);
        builder.addCameraFilter(this.getFilter(mode));
        return builder.build();
    }

    boolean isExtensionAvailable(@NonNull CameraSelector baseCameraSelector, int mode) {
        CameraSelector.Builder builder = CameraSelector.Builder.fromSelector((CameraSelector)baseCameraSelector);
        builder.addCameraFilter(this.getFilter(mode));
        List cameraInfos = builder.build().filter(this.mCameraProvider.getAvailableCameraInfos());
        return !cameraInfos.isEmpty();
    }

    @Nullable
    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    Range<Long> getEstimatedCaptureLatencyRange(@NonNull CameraSelector cameraSelector, int mode, @Nullable Size resolution) {
        CameraSelector newCameraSelector = CameraSelector.Builder.fromSelector((CameraSelector)cameraSelector).addCameraFilter(this.getFilter(mode)).build();
        List cameraInfos = newCameraSelector.filter(this.mCameraProvider.getAvailableCameraInfos());
        if (cameraInfos.isEmpty()) {
            return null;
        }
        CameraInfo extensionsCameraInfo = (CameraInfo)cameraInfos.get(0);
        if (ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_2) < 0) {
            return null;
        }
        try {
            VendorExtender vendorExtender = this.mVendorExtenderFactory.createVendorExtender(mode);
            vendorExtender.init(extensionsCameraInfo);
            return vendorExtender.getEstimatedCaptureLatencyRange(resolution);
        }
        catch (NoSuchMethodError e) {
            return null;
        }
    }

    boolean isImageAnalysisSupported(@NonNull CameraSelector cameraSelector, int mode) {
        CameraSelector newCameraSelector = CameraSelector.Builder.fromSelector((CameraSelector)cameraSelector).addCameraFilter(this.getFilter(mode)).build();
        List cameraInfos = newCameraSelector.filter(this.mCameraProvider.getAvailableCameraInfos());
        if (cameraInfos.isEmpty()) {
            return false;
        }
        CameraInfo extensionsCameraInfo = (CameraInfo)cameraInfos.get(0);
        VendorExtender vendorExtender = this.mVendorExtenderFactory.createVendorExtender(mode);
        vendorExtender.init(extensionsCameraInfo);
        Size[] supportedYuvSizes = vendorExtender.getSupportedYuvAnalysisResolutions();
        return supportedYuvSizes != null && supportedYuvSizes.length > 0;
    }

    @VisibleForTesting
    void setVendorExtenderFactory(@NonNull VendorExtenderFactory factory) {
        this.mVendorExtenderFactory = factory;
    }

    private CameraFilter getFilter(int mode) {
        String id = ExtensionsInfo.getExtendedCameraConfigProviderId(mode);
        VendorExtender vendorExtender = this.mVendorExtenderFactory.createVendorExtender(mode);
        ExtensionCameraFilter filter = new ExtensionCameraFilter(id, vendorExtender);
        return filter;
    }

    private void injectExtensionCameraConfig(int mode) {
        Identifier id = Identifier.create((Object)ExtensionsInfo.getExtendedCameraConfigProviderId(mode));
        if (ExtendedCameraConfigProviderStore.getConfigProvider((Object)id) == CameraConfigProvider.EMPTY) {
            ExtendedCameraConfigProviderStore.addConfig((Object)id, (cameraInfo, context) -> {
                VendorExtender vendorExtender = this.mVendorExtenderFactory.createVendorExtender(mode);
                vendorExtender.init(cameraInfo);
                ExtensionsUseCaseConfigFactory factory = new ExtensionsUseCaseConfigFactory(vendorExtender);
                ExtensionsConfig.Builder builder = new ExtensionsConfig.Builder().setExtensionMode(mode).setUseCaseConfigFactory(factory).setCompatibilityId(id).setZslDisabled(true).setPostviewSupported(vendorExtender.isPostviewAvailable()).setCaptureProcessProgressSupported(vendorExtender.isCaptureProcessProgressAvailable()).setUseCaseCombinationRequiredRule(1);
                SessionProcessor sessionProcessor = vendorExtender.createSessionProcessor(context);
                if (sessionProcessor != null) {
                    builder.setSessionProcessor(sessionProcessor);
                }
                return builder.build();
            });
        }
    }

    @NonNull
    static VendorExtender getVendorExtender(int mode) {
        boolean isAdvancedExtenderSupported = ExtensionsInfo.isAdvancedExtenderSupported();
        VendorExtender vendorExtender = isAdvancedExtenderSupported ? new AdvancedVendorExtender(mode) : (Build.VERSION.SDK_INT >= 23 ? new BasicVendorExtender(mode) : new VendorExtender(){});
        return vendorExtender;
    }

    private static boolean isAdvancedExtenderSupported() {
        if (ExtensionVersion.getRuntimeVersion().compareTo(Version.VERSION_1_2) < 0) {
            return false;
        }
        return ExtensionVersion.isAdvancedExtenderSupported();
    }

    private static String getExtendedCameraConfigProviderId(int mode) {
        String id;
        switch (mode) {
            case 1: {
                id = ":camera:camera-extensions-EXTENSION_MODE_BOKEH";
                break;
            }
            case 2: {
                id = ":camera:camera-extensions-EXTENSION_MODE_HDR";
                break;
            }
            case 3: {
                id = ":camera:camera-extensions-EXTENSION_MODE_NIGHT";
                break;
            }
            case 4: {
                id = ":camera:camera-extensions-EXTENSION_MODE_FACE_RETOUCH";
                break;
            }
            case 5: {
                id = ":camera:camera-extensions-EXTENSION_MODE_AUTO";
                break;
            }
            case 0: {
                id = ":camera:camera-extensions-EXTENSION_MODE_NONE";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid extension mode!");
            }
        }
        return id;
    }
}

