/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.compat.quirk;

import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Quirk;
import androidx.camera.extensions.internal.ExtensionVersion;
import androidx.camera.extensions.internal.Version;

@RequiresApi(value=21)
public class ExtensionDisabledQuirk
implements Quirk {
    static boolean load() {
        return ExtensionDisabledQuirk.isPixel5() || ExtensionDisabledQuirk.isMoto();
    }

    public boolean shouldDisableExtension() {
        if (ExtensionDisabledQuirk.isPixel5() && !ExtensionDisabledQuirk.isAdvancedExtenderSupported()) {
            return true;
        }
        return ExtensionDisabledQuirk.isMoto() && ExtensionVersion.isMaximumCompatibleVersion(Version.VERSION_1_1);
    }

    private static boolean isPixel5() {
        return "google".equalsIgnoreCase(Build.BRAND) && "redfin".equalsIgnoreCase(Build.DEVICE);
    }

    private static boolean isMoto() {
        return "motorola".equalsIgnoreCase(Build.BRAND);
    }

    private static boolean isAdvancedExtenderSupported() {
        return ExtensionVersion.isMinimumCompatibleVersion(Version.VERSION_1_2) && ExtensionVersion.isAdvancedExtenderSupported();
    }
}

