/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.sessionprocessor;

import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.media.Image;
import android.util.LongSparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.extensions.internal.sessionprocessor.ImageReference;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import java.util.Map;

@RequiresApi(value=21)
class CaptureResultImageMatcher {
    private final Object mLock = new Object();
    private static final int INVALID_TIMESTAMP = -1;
    @GuardedBy(value="mLock")
    private final LongSparseArray<TotalCaptureResult> mPendingCaptureResults = new LongSparseArray();
    @GuardedBy(value="mLock")
    Map<TotalCaptureResult, Integer> mCaptureStageIdMap = new HashMap<TotalCaptureResult, Integer>();
    @GuardedBy(value="mLock")
    private final LongSparseArray<ImageReference> mPendingImages = new LongSparseArray();
    @GuardedBy(value="mLock")
    ImageReferenceListener mImageReferenceListener;

    CaptureResultImageMatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingCaptureResults.clear();
            for (int i = 0; i < this.mPendingImages.size(); ++i) {
                long key = this.mPendingImages.keyAt(i);
                ((ImageReference)this.mPendingImages.get(key)).decrement();
            }
            this.mPendingImages.clear();
            this.mCaptureStageIdMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setImageReferenceListener(@NonNull ImageReferenceListener imageReferenceListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mImageReferenceListener = imageReferenceListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearImageReferenceListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImageReferenceListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageIncoming(@NonNull ImageReference imageReference) {
        Object object = this.mLock;
        synchronized (object) {
            Image image = imageReference.get();
            this.mPendingImages.put(image.getTimestamp(), (Object)imageReference);
        }
        this.matchImages();
    }

    void captureResultIncoming(@NonNull TotalCaptureResult captureResult) {
        this.captureResultIncoming(captureResult, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void captureResultIncoming(@NonNull TotalCaptureResult captureResult, int captureStageId) {
        Object object = this.mLock;
        synchronized (object) {
            long timestamp = this.getTimeStampFromCaptureResult(captureResult);
            if (timestamp == -1L) {
                return;
            }
            this.mPendingCaptureResults.put(timestamp, (Object)captureResult);
            this.mCaptureStageIdMap.put(captureResult, captureStageId);
        }
        this.matchImages();
    }

    private long getTimeStampFromCaptureResult(TotalCaptureResult captureResult) {
        Long timestamp = (Long)captureResult.get(CaptureResult.SENSOR_TIMESTAMP);
        long timestampValue = -1L;
        if (timestamp != null) {
            timestampValue = timestamp;
        }
        return timestampValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyImage(ImageReference imageReference, TotalCaptureResult totalCaptureResult) {
        ImageReferenceListener listenerToInvoke = null;
        Integer captureStageId = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mImageReferenceListener != null) {
                listenerToInvoke = this.mImageReferenceListener;
                captureStageId = this.mCaptureStageIdMap.get(totalCaptureResult);
            } else {
                imageReference.decrement();
            }
        }
        if (listenerToInvoke != null) {
            listenerToInvoke.onImageReferenceIncoming(imageReference, totalCaptureResult, captureStageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStaleData() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingImages.size() == 0 || this.mPendingCaptureResults.size() == 0) {
                return;
            }
            Long minImageRefTimestamp = this.mPendingImages.keyAt(0);
            Long minCaptureResultTimestamp = this.mPendingCaptureResults.keyAt(0);
            Preconditions.checkArgument((!minCaptureResultTimestamp.equals(minImageRefTimestamp) ? 1 : 0) != 0);
            if (minCaptureResultTimestamp > minImageRefTimestamp) {
                for (int i = this.mPendingImages.size() - 1; i >= 0; --i) {
                    if (this.mPendingImages.keyAt(i) >= minCaptureResultTimestamp) continue;
                    ImageReference imageReference = (ImageReference)this.mPendingImages.valueAt(i);
                    imageReference.decrement();
                    this.mPendingImages.removeAt(i);
                }
            } else {
                for (int i = this.mPendingCaptureResults.size() - 1; i >= 0; --i) {
                    if (this.mPendingCaptureResults.keyAt(i) >= minImageRefTimestamp) continue;
                    this.mPendingCaptureResults.removeAt(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchImages() {
        ImageReference imageToNotify = null;
        TotalCaptureResult resultToNotify = null;
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mPendingCaptureResults.size() - 1; i >= 0; --i) {
                TotalCaptureResult captureResult = (TotalCaptureResult)this.mPendingCaptureResults.valueAt(i);
                long timestamp = this.getTimeStampFromCaptureResult(captureResult);
                ImageReference imageReference = (ImageReference)this.mPendingImages.get(timestamp);
                if (imageReference == null) continue;
                this.mPendingImages.remove(timestamp);
                this.mPendingCaptureResults.removeAt(i);
                imageToNotify = imageReference;
                resultToNotify = captureResult;
            }
            this.removeStaleData();
        }
        if (imageToNotify != null && resultToNotify != null) {
            this.notifyImage(imageToNotify, resultToNotify);
        }
    }

    static interface ImageReferenceListener {
        public void onImageReferenceIncoming(@NonNull ImageReference var1, @NonNull TotalCaptureResult var2, int var3);
    }
}

