/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.sessionprocessor;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.OutputSurfaceConfiguration;
import androidx.camera.core.impl.RestrictedCameraControl;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.SessionProcessorSurface;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.extensions.internal.sessionprocessor.Camera2OutputConfig;
import androidx.camera.extensions.internal.sessionprocessor.Camera2SessionConfig;
import androidx.camera.extensions.internal.sessionprocessor.ImageProcessor;
import androidx.camera.extensions.internal.sessionprocessor.ImageReaderOutputConfig;
import androidx.camera.extensions.internal.sessionprocessor.ImageReference;
import androidx.camera.extensions.internal.sessionprocessor.MultiResolutionImageReaderOutputConfig;
import androidx.camera.extensions.internal.sessionprocessor.SurfaceOutputConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RequiresApi(value=21)
abstract class SessionProcessorBase
implements SessionProcessor {
    private static final String TAG = "SessionProcessorBase";
    @NonNull
    @GuardedBy(value="mLock")
    private final Map<Integer, ImageReader> mImageReaderMap = new HashMap<Integer, ImageReader>();
    @GuardedBy(value="mLock")
    private final Map<Integer, Camera2OutputConfig> mOutputConfigMap = new HashMap<Integer, Camera2OutputConfig>();
    @Nullable
    private HandlerThread mImageReaderHandlerThread;
    @GuardedBy(value="mLock")
    private final List<DeferrableSurface> mSurfacesList = new ArrayList<DeferrableSurface>();
    private final Object mLock = new Object();
    private String mCameraId;
    @NonNull
    @RestrictedCameraControl.CameraOperation
    private final Set<Integer> mSupportedCameraOperations;

    SessionProcessorBase(@NonNull List<CaptureRequest.Key> supportedParameterKeys) {
        this.mSupportedCameraOperations = this.getSupportedCameraOperations(supportedParameterKeys);
    }

    @RestrictedCameraControl.CameraOperation
    private Set<Integer> getSupportedCameraOperations(@NonNull List<CaptureRequest.Key> supportedParameterKeys) {
        HashSet<Integer> operations = new HashSet<Integer>();
        if (Build.VERSION.SDK_INT >= 30) {
            if (supportedParameterKeys.contains(CaptureRequest.CONTROL_ZOOM_RATIO) || supportedParameterKeys.contains(CaptureRequest.SCALER_CROP_REGION)) {
                operations.add(0);
            }
        } else if (supportedParameterKeys.contains(CaptureRequest.SCALER_CROP_REGION)) {
            operations.add(0);
        }
        if (supportedParameterKeys.containsAll(Arrays.asList(CaptureRequest.CONTROL_AF_TRIGGER, CaptureRequest.CONTROL_AF_MODE))) {
            operations.add(1);
        }
        if (supportedParameterKeys.contains(CaptureRequest.CONTROL_AF_REGIONS)) {
            operations.add(2);
        }
        if (supportedParameterKeys.contains(CaptureRequest.CONTROL_AE_REGIONS)) {
            operations.add(3);
        }
        if (supportedParameterKeys.contains(CaptureRequest.CONTROL_AWB_REGIONS)) {
            operations.add(4);
        }
        if (supportedParameterKeys.containsAll(Arrays.asList(CaptureRequest.CONTROL_AE_MODE, CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER))) {
            operations.add(5);
        }
        if (supportedParameterKeys.containsAll(Arrays.asList(CaptureRequest.CONTROL_AE_MODE, CaptureRequest.FLASH_MODE))) {
            operations.add(6);
        }
        if (supportedParameterKeys.contains(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION)) {
            operations.add(7);
        }
        return operations;
    }

    @NonNull
    private static SessionProcessorSurface createOutputConfigSurface(@NonNull Camera2OutputConfig outputConfig, Map<Integer, ImageReader> imageReaderMap) {
        if (outputConfig instanceof SurfaceOutputConfig) {
            SurfaceOutputConfig surfaceOutputConfig = (SurfaceOutputConfig)outputConfig;
            SessionProcessorSurface surface = new SessionProcessorSurface(surfaceOutputConfig.getSurface(), outputConfig.getId());
            return surface;
        }
        if (outputConfig instanceof ImageReaderOutputConfig) {
            ImageReaderOutputConfig imageReaderOutputConfig = (ImageReaderOutputConfig)outputConfig;
            ImageReader imageReader = ImageReader.newInstance((int)imageReaderOutputConfig.getSize().getWidth(), (int)imageReaderOutputConfig.getSize().getHeight(), (int)imageReaderOutputConfig.getImageFormat(), (int)imageReaderOutputConfig.getMaxImages());
            imageReaderMap.put(outputConfig.getId(), imageReader);
            SessionProcessorSurface surface = new SessionProcessorSurface(imageReader.getSurface(), outputConfig.getId());
            surface.getTerminationFuture().addListener(() -> imageReader.close(), CameraXExecutors.directExecutor());
            return surface;
        }
        if (outputConfig instanceof MultiResolutionImageReaderOutputConfig) {
            throw new UnsupportedOperationException("MultiResolutionImageReader not supported yet");
        }
        throw new UnsupportedOperationException("Unsupported Camera2OutputConfig:" + outputConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public final SessionConfig initSession(@NonNull CameraInfo cameraInfo, @NonNull OutputSurfaceConfiguration outputSurfaceConfiguration) {
        Camera2CameraInfo camera2CameraInfo = Camera2CameraInfo.from((CameraInfo)cameraInfo);
        Map characteristicsMap = camera2CameraInfo.getCameraCharacteristicsMap();
        Camera2SessionConfig camera2SessionConfig = this.initSessionInternal(camera2CameraInfo.getCameraId(), characteristicsMap, outputSurfaceConfiguration);
        SessionConfig.Builder sessionConfigBuilder = new SessionConfig.Builder();
        Object object = this.mLock;
        synchronized (object) {
            for (Camera2OutputConfig outputConfig : camera2SessionConfig.getOutputConfigs()) {
                SessionProcessorSurface sessionProcessorSurface = SessionProcessorBase.createOutputConfigSurface(outputConfig, this.mImageReaderMap);
                this.mSurfacesList.add((DeferrableSurface)sessionProcessorSurface);
                this.mOutputConfigMap.put(outputConfig.getId(), outputConfig);
                SessionConfig.OutputConfig.Builder outputConfigBuilder = SessionConfig.OutputConfig.builder((DeferrableSurface)sessionProcessorSurface).setPhysicalCameraId(outputConfig.getPhysicalCameraId()).setSurfaceGroupId(outputConfig.getSurfaceGroupId());
                List<Camera2OutputConfig> sharedOutputs = outputConfig.getSurfaceSharingOutputConfigs();
                if (sharedOutputs != null && !sharedOutputs.isEmpty()) {
                    ArrayList<SessionProcessorSurface> sharedSurfaces = new ArrayList<SessionProcessorSurface>();
                    for (Camera2OutputConfig sharedOutput : sharedOutputs) {
                        this.mOutputConfigMap.put(sharedOutput.getId(), sharedOutput);
                        sharedSurfaces.add(SessionProcessorBase.createOutputConfigSurface(sharedOutput, this.mImageReaderMap));
                    }
                    outputConfigBuilder.setSharedSurfaces(sharedSurfaces);
                }
                sessionConfigBuilder.addOutputConfig(outputConfigBuilder.build());
            }
        }
        Camera2ImplConfig.Builder camera2ConfigurationBuilder = new Camera2ImplConfig.Builder();
        Iterator<Camera2OutputConfig> iterator = camera2SessionConfig.getSessionParameters().keySet().iterator();
        while (iterator.hasNext()) {
            CaptureRequest.Key key;
            CaptureRequest.Key objKey = key = (CaptureRequest.Key)iterator.next();
            Object value = camera2SessionConfig.getSessionParameters().get(objKey);
            camera2ConfigurationBuilder.setCaptureRequestOption(objKey, value);
        }
        sessionConfigBuilder.setImplementationOptions((Config)camera2ConfigurationBuilder.build());
        sessionConfigBuilder.setTemplateType(camera2SessionConfig.getSessionTemplateId());
        sessionConfigBuilder.setSessionType(camera2SessionConfig.getSessionType());
        this.mImageReaderHandlerThread = new HandlerThread("CameraX-extensions_image_reader");
        this.mImageReaderHandlerThread.start();
        this.mCameraId = camera2CameraInfo.getCameraId();
        Logger.d((String)TAG, (String)("initSession: cameraId=" + this.mCameraId));
        return sessionConfigBuilder.build();
    }

    @NonNull
    @RestrictedCameraControl.CameraOperation
    public Set<Integer> getSupportedCameraOperations() {
        return this.mSupportedCameraOperations;
    }

    @NonNull
    protected abstract Camera2SessionConfig initSessionInternal(@NonNull String var1, @NonNull Map<String, CameraCharacteristics> var2, @NonNull OutputSurfaceConfiguration var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setImageProcessor(int outputConfigId, @NonNull ImageProcessor imageProcessor) {
        String physicalCameraId;
        ImageReader imageReader;
        Object object = this.mLock;
        synchronized (object) {
            imageReader = this.mImageReaderMap.get(outputConfigId);
            Camera2OutputConfig outputConfig = this.mOutputConfigMap.get(outputConfigId);
            physicalCameraId = outputConfig == null ? null : outputConfig.getPhysicalCameraId();
        }
        if (imageReader != null) {
            imageReader.setOnImageAvailableListener(reader -> {
                try {
                    Image image = reader.acquireNextImage();
                    ImageRefHolder imageReference = new ImageRefHolder(image);
                    imageProcessor.onNextImageAvailable(outputConfigId, image.getTimestamp(), imageReference, physicalCameraId);
                }
                catch (IllegalStateException e) {
                    Logger.e((String)TAG, (String)"Failed to acquire next image.", (Throwable)e);
                }
            }, new Handler(this.mImageReaderHandlerThread.getLooper()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deInitSession() {
        Logger.e((String)TAG, (String)("deInitSession: cameraId=" + this.mCameraId));
        this.deInitSessionInternal();
        Object object = this.mLock;
        synchronized (object) {
            for (DeferrableSurface deferrableSurface : this.mSurfacesList) {
                deferrableSurface.close();
            }
            this.mSurfacesList.clear();
            this.mImageReaderMap.clear();
            this.mOutputConfigMap.clear();
        }
        if (this.mImageReaderHandlerThread != null) {
            this.mImageReaderHandlerThread.quitSafely();
            this.mImageReaderHandlerThread = null;
        }
    }

    protected abstract void deInitSessionInternal();

    private static class ImageRefHolder
    implements ImageReference {
        private int mRefCount = 1;
        private final Image mImage;
        private final Object mImageLock = new Object();

        ImageRefHolder(@NonNull Image image) {
            this.mImage = image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean increment() {
            Object object = this.mImageLock;
            synchronized (object) {
                if (this.mRefCount <= 0) {
                    return false;
                }
                ++this.mRefCount;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean decrement() {
            Object object = this.mImageLock;
            synchronized (object) {
                if (this.mRefCount <= 0) {
                    return false;
                }
                --this.mRefCount;
                if (this.mRefCount <= 0) {
                    this.mImage.close();
                }
            }
            return true;
        }

        @Override
        @Nullable
        public Image get() {
            return this.mImage;
        }
    }
}

