/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.internal.sessionprocessor;

import android.view.Surface;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageProcessingUtil;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.core.util.Preconditions;

@RequiresApi(value=21)
class YuvToJpegConverter {
    private static final String TAG = "YuvToJpegConverter";
    private final Surface mOutputJpegSurface;
    @IntRange(from=1L, to=100L)
    private volatile int mJpegQuality;
    private volatile int mRotationDegrees = 0;

    YuvToJpegConverter(int jpegQuality, @NonNull Surface outputJpegSurface) {
        this.mJpegQuality = jpegQuality;
        this.mOutputJpegSurface = outputJpegSurface;
    }

    public void setRotationDegrees(int rotationDegrees) {
        this.mRotationDegrees = rotationDegrees;
    }

    void setJpegQuality(int jpgQuality) {
        this.mJpegQuality = jpgQuality;
    }

    void writeYuvImage(@NonNull ImageProxy imageProxy) throws ConversionFailedException {
        Preconditions.checkState((imageProxy.getFormat() == 35 ? 1 : 0) != 0, (String)"Input image is not expected YUV_420_888 image format");
        try {
            boolean success = ImageProcessingUtil.convertYuvToJpegBytesIntoSurface((ImageProxy)imageProxy, (int)this.mJpegQuality, (int)this.mRotationDegrees, (Surface)this.mOutputJpegSurface);
            if (!success) {
                throw new ConversionFailedException("Failed to process YUV -> JPEG");
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)"Failed to process YUV -> JPEG", (Throwable)e);
            throw new ConversionFailedException("Failed to process YUV -> JPEG", e);
        }
        finally {
            imageProxy.close();
        }
    }

    static class ConversionFailedException
    extends Exception {
        ConversionFailedException(String message) {
            super(message);
        }

        ConversionFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

