/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.lifecycle;

import android.content.Context;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.ViewPort;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.lifecycle.LifecycleCameraProvider;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

public final class ProcessCameraProvider
implements LifecycleCameraProvider {
    private static final ProcessCameraProvider sAppInstance = new ProcessCameraProvider();

    @NonNull
    public static ListenableFuture<ProcessCameraProvider> getInstance(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        return Futures.transform((ListenableFuture)CameraX.getOrCreateInstance((Context)context), cameraX -> sAppInstance, (Executor)CameraXExecutors.directExecutor());
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public static void initializeInstance(@NonNull Context context, @NonNull CameraXConfig cameraXConfig) {
        ListenableFuture future = CameraX.initialize((Context)context, (CameraXConfig)cameraXConfig);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
            }

            public void onFailure(Throwable t) {
                throw new RuntimeException(t);
            }
        }, (Executor)CameraXExecutors.directExecutor());
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    @NonNull
    public ListenableFuture<Void> shutdown() {
        return CameraX.shutdown();
    }

    @MainThread
    @NonNull
    public Camera bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraSelector cameraSelector, UseCase ... useCases) {
        return CameraX.bindToLifecycle((LifecycleOwner)lifecycleOwner, (CameraSelector)cameraSelector, null, (UseCase[])useCases);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @MainThread
    @NonNull
    public Camera bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraSelector cameraSelector, @NonNull UseCaseGroup useCaseGroup) {
        return CameraX.bindToLifecycle((LifecycleOwner)lifecycleOwner, (CameraSelector)cameraSelector, (ViewPort)useCaseGroup.getViewPort(), (UseCase[])useCaseGroup.getUseCases());
    }

    @Override
    public boolean isBound(@NonNull UseCase useCase) {
        return CameraX.isBound((UseCase)useCase);
    }

    @Override
    @MainThread
    public void unbind(UseCase ... useCases) {
        CameraX.unbind((UseCase[])useCases);
    }

    @Override
    @MainThread
    public void unbindAll() {
        CameraX.unbindAll();
    }

    @Override
    public boolean hasCamera(@NonNull CameraSelector cameraSelector) throws CameraInfoUnavailableException {
        return CameraX.hasCamera((CameraSelector)cameraSelector);
    }

    private ProcessCameraProvider() {
    }
}

