/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.lifecycle;

import android.content.Context;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RestrictTo;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.ExperimentalCameraFilter;
import androidx.camera.core.ExperimentalUseCaseGroup;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.ViewPort;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import androidx.camera.lifecycle.ExperimentalCameraProviderConfiguration;
import androidx.camera.lifecycle.ExperimentalUseCaseGroupLifecycle;
import androidx.camera.lifecycle.LifecycleCamera;
import androidx.camera.lifecycle.LifecycleCameraProvider;
import androidx.camera.lifecycle.LifecycleCameraRepository;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Executor;

public final class ProcessCameraProvider
implements LifecycleCameraProvider {
    private static final ProcessCameraProvider sAppInstance = new ProcessCameraProvider();
    private final LifecycleCameraRepository mLifecycleCameraRepository = new LifecycleCameraRepository();
    private CameraX mCameraX;

    @NonNull
    public static ListenableFuture<ProcessCameraProvider> getInstance(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        return Futures.transform((ListenableFuture)CameraX.getOrCreateInstance((Context)context), cameraX -> {
            sAppInstance.setCameraX((CameraX)cameraX);
            return sAppInstance;
        }, (Executor)CameraXExecutors.directExecutor());
    }

    @ExperimentalCameraProviderConfiguration
    public static void configureInstance(@NonNull CameraXConfig cameraXConfig) {
        CameraX.configureInstance((CameraXConfig)cameraXConfig);
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    @NonNull
    public ListenableFuture<Void> shutdown() {
        this.mLifecycleCameraRepository.clear();
        return CameraX.shutdown();
    }

    private void setCameraX(CameraX cameraX) {
        this.mCameraX = cameraX;
    }

    @MainThread
    @NonNull
    @OptIn(markerClass={ExperimentalUseCaseGroup.class})
    public Camera bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraSelector cameraSelector, UseCase ... useCases) {
        return this.bindToLifecycle(lifecycleOwner, cameraSelector, (ViewPort)null, useCases);
    }

    @ExperimentalUseCaseGroupLifecycle
    @MainThread
    @NonNull
    @OptIn(markerClass={ExperimentalUseCaseGroup.class})
    public Camera bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraSelector cameraSelector, @NonNull UseCaseGroup useCaseGroup) {
        return this.bindToLifecycle(lifecycleOwner, cameraSelector, useCaseGroup.getViewPort(), useCaseGroup.getUseCases().toArray(new UseCase[0]));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @ExperimentalUseCaseGroup
    @OptIn(markerClass={ExperimentalCameraFilter.class})
    @NonNull
    public Camera bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraSelector cameraSelector, @Nullable ViewPort viewPort, UseCase ... useCases) {
        Threads.checkMainThread();
        CameraSelector.Builder selectorBuilder = CameraSelector.Builder.fromSelector((CameraSelector)cameraSelector);
        for (UseCase useCase : useCases) {
            CameraSelector selector = useCase.getCurrentConfig().getCameraSelector(null);
            if (selector == null) continue;
            for (CameraFilter filter : selector.getCameraFilterSet()) {
                selectorBuilder.addCameraFilter(filter);
            }
        }
        CameraSelector modifiedSelector = selectorBuilder.build();
        LinkedHashSet cameraInternals = modifiedSelector.filter(this.mCameraX.getCameraRepository().getCameras());
        CameraUseCaseAdapter.CameraId cameraId = CameraUseCaseAdapter.generateCameraId((LinkedHashSet)cameraInternals);
        LifecycleCamera lifecycleCameraToBind = this.mLifecycleCameraRepository.getLifecycleCamera(lifecycleOwner, cameraId);
        Collection<LifecycleCamera> lifecycleCameras = this.mLifecycleCameraRepository.getLifecycleCameras();
        for (UseCase useCase : useCases) {
            for (LifecycleCamera lifecycleCamera : lifecycleCameras) {
                if (!lifecycleCamera.isBound(useCase) || lifecycleCamera == lifecycleCameraToBind) continue;
                throw new IllegalStateException(String.format("Use case %s already bound to a different lifecycle.", useCase));
            }
        }
        if (lifecycleCameraToBind == null) {
            lifecycleCameraToBind = this.mLifecycleCameraRepository.createLifecycleCamera(lifecycleOwner, new CameraUseCaseAdapter(cameraInternals, this.mCameraX.getCameraDeviceSurfaceManager(), this.mCameraX.getDefaultConfigFactory()));
        }
        if (useCases.length == 0) {
            return lifecycleCameraToBind;
        }
        this.mLifecycleCameraRepository.bindToLifecycleCamera(lifecycleCameraToBind, viewPort, Arrays.asList(useCases));
        return lifecycleCameraToBind;
    }

    @Override
    public boolean isBound(@NonNull UseCase useCase) {
        for (LifecycleCamera lifecycleCamera : this.mLifecycleCameraRepository.getLifecycleCameras()) {
            if (!lifecycleCamera.isBound(useCase)) continue;
            return true;
        }
        return false;
    }

    @Override
    @MainThread
    public void unbind(UseCase ... useCases) {
        Threads.checkMainThread();
        this.mLifecycleCameraRepository.unbind(Arrays.asList(useCases));
    }

    @Override
    @MainThread
    public void unbindAll() {
        Threads.checkMainThread();
        this.mLifecycleCameraRepository.unbindAll();
    }

    public boolean hasCamera(@NonNull CameraSelector cameraSelector) throws CameraInfoUnavailableException {
        try {
            cameraSelector.select(this.mCameraX.getCameraRepository().getCameras());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @NonNull
    public List<CameraInfo> getAvailableCameraInfos() {
        ArrayList<CameraInfo> availableCameraInfos = new ArrayList<CameraInfo>();
        LinkedHashSet cameras = this.mCameraX.getCameraRepository().getCameras();
        for (CameraInternal camera : cameras) {
            availableCameraInfos.add(camera.getCameraInfo());
        }
        return availableCameraInfos;
    }

    private ProcessCameraProvider() {
    }
}

