/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.lifecycle;

import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.ConcurrentCamera;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.ViewPort;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraConfigs;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.ExtendedCameraConfigProviderStore;
import androidx.camera.core.impl.utils.ContextUtil;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import androidx.camera.lifecycle.ExperimentalCameraProviderConfiguration;
import androidx.camera.lifecycle.LifecycleCamera;
import androidx.camera.lifecycle.LifecycleCameraProvider;
import androidx.camera.lifecycle.LifecycleCameraRepository;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class ProcessCameraProvider
implements LifecycleCameraProvider {
    private static final ProcessCameraProvider sAppInstance = new ProcessCameraProvider();
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private CameraXConfig.Provider mCameraXConfigProvider = null;
    @GuardedBy(value="mLock")
    private ListenableFuture<CameraX> mCameraXInitializeFuture;
    @GuardedBy(value="mLock")
    private ListenableFuture<Void> mCameraXShutdownFuture = Futures.immediateFuture(null);
    private final LifecycleCameraRepository mLifecycleCameraRepository = new LifecycleCameraRepository();
    private CameraX mCameraX;
    private Context mContext;

    @NonNull
    public static ListenableFuture<ProcessCameraProvider> getInstance(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        return Futures.transform(sAppInstance.getOrCreateCameraXInstance(context), cameraX -> {
            sAppInstance.setCameraX((CameraX)cameraX);
            sAppInstance.setContext(ContextUtil.getApplicationContext((Context)context));
            return sAppInstance;
        }, (Executor)CameraXExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<CameraX> getOrCreateCameraXInstance(@NonNull Context context) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCameraXInitializeFuture != null) {
                return this.mCameraXInitializeFuture;
            }
            final CameraX cameraX = new CameraX(context, this.mCameraXConfigProvider);
            this.mCameraXInitializeFuture = CallbackToFutureAdapter.getFuture(completer -> {
                Object object = this.mLock;
                synchronized (object) {
                    FutureChain future = FutureChain.from(this.mCameraXShutdownFuture).transformAsync(input -> cameraX.getInitializeFuture(), CameraXExecutors.directExecutor());
                    Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Void>(){

                        public void onSuccess(@Nullable Void result) {
                            completer.set((Object)cameraX);
                        }

                        public void onFailure(@NonNull Throwable t) {
                            completer.setException(t);
                        }
                    }, (Executor)CameraXExecutors.directExecutor());
                }
                return "ProcessCameraProvider-initializeCameraX";
            });
            return this.mCameraXInitializeFuture;
        }
    }

    @ExperimentalCameraProviderConfiguration
    public static void configureInstance(@NonNull CameraXConfig cameraXConfig) {
        sAppInstance.configureInstanceInternal(cameraXConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureInstanceInternal(@NonNull CameraXConfig cameraXConfig) {
        Object object = this.mLock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)cameraXConfig);
            Preconditions.checkState((this.mCameraXConfigProvider == null ? 1 : 0) != 0, (String)"CameraX has already been configured. To use a different configuration, shutdown() must be called.");
            this.mCameraXConfigProvider = () -> cameraXConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NonNull
    public ListenableFuture<Void> shutdownAsync() {
        Threads.runOnMainSync(() -> {
            this.unbindAll();
            this.mLifecycleCameraRepository.clear();
        });
        if (this.mCameraX != null) {
            this.mCameraX.getCameraFactory().getCameraCoordinator().shutdown();
        }
        ListenableFuture shutdownFuture = this.mCameraX != null ? this.mCameraX.shutdown() : Futures.immediateFuture(null);
        Object object = this.mLock;
        synchronized (object) {
            this.mCameraXConfigProvider = null;
            this.mCameraXInitializeFuture = null;
            this.mCameraXShutdownFuture = shutdownFuture;
        }
        this.mCameraX = null;
        this.mContext = null;
        return shutdownFuture;
    }

    private void setCameraX(CameraX cameraX) {
        this.mCameraX = cameraX;
    }

    private void setContext(Context context) {
        this.mContext = context;
    }

    @MainThread
    @NonNull
    public Camera bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraSelector cameraSelector, UseCase ... useCases) {
        if (this.getCameraOperatingMode() == 2) {
            throw new UnsupportedOperationException("bindToLifecycle for single camera is not supported in concurrent camera mode, call unbindAll() first");
        }
        this.setCameraOperatingMode(1);
        Camera camera = this.bindToLifecycle(lifecycleOwner, cameraSelector, null, Collections.emptyList(), useCases);
        return camera;
    }

    @MainThread
    @NonNull
    public Camera bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraSelector cameraSelector, @NonNull UseCaseGroup useCaseGroup) {
        if (this.getCameraOperatingMode() == 2) {
            throw new UnsupportedOperationException("bindToLifecycle for single camera is not supported in concurrent camera mode, call unbindAll() first");
        }
        this.setCameraOperatingMode(1);
        Camera camera = this.bindToLifecycle(lifecycleOwner, cameraSelector, useCaseGroup.getViewPort(), useCaseGroup.getEffects(), useCaseGroup.getUseCases().toArray(new UseCase[0]));
        return camera;
    }

    @MainThread
    @NonNull
    public ConcurrentCamera bindToLifecycle(@NonNull List<ConcurrentCamera.SingleCameraConfig> singleCameraConfigs) {
        if (!this.mContext.getPackageManager().hasSystemFeature("android.hardware.camera.concurrent")) {
            throw new UnsupportedOperationException("Concurrent camera is not supported on the device");
        }
        if (this.getCameraOperatingMode() == 1) {
            throw new UnsupportedOperationException("Camera is already running, call unbindAll() before binding more cameras");
        }
        if (singleCameraConfigs.size() < 2) {
            throw new IllegalArgumentException("Concurrent camera needs two camera configs");
        }
        if (singleCameraConfigs.size() > 2) {
            throw new IllegalArgumentException("Concurrent camera is only supporting two  cameras at maximum.");
        }
        ArrayList<CameraInfo> cameraInfosToBind = new ArrayList<CameraInfo>();
        List<CameraInfo> availableCameraInfos = this.getAvailableCameraInfos();
        CameraInfo firstCameraInfo = this.getCameraInfoFromCameraSelector(singleCameraConfigs.get(0).getCameraSelector(), availableCameraInfos);
        CameraInfo secondCameraInfo = this.getCameraInfoFromCameraSelector(singleCameraConfigs.get(1).getCameraSelector(), availableCameraInfos);
        if (firstCameraInfo == null || secondCameraInfo == null) {
            throw new IllegalArgumentException("Invalid camera selectors in camera configs");
        }
        cameraInfosToBind.add(firstCameraInfo);
        cameraInfosToBind.add(secondCameraInfo);
        if (!this.getActiveConcurrentCameraInfos().isEmpty() && !cameraInfosToBind.equals(this.getActiveConcurrentCameraInfos())) {
            throw new UnsupportedOperationException("Cameras are already running, call unbindAll() before binding more cameras");
        }
        this.setCameraOperatingMode(2);
        ArrayList<Camera> cameras = new ArrayList<Camera>();
        for (ConcurrentCamera.SingleCameraConfig config : singleCameraConfigs) {
            Camera camera = this.bindToLifecycle(config.getLifecycleOwner(), config.getCameraSelector(), config.getUseCaseGroup().getViewPort(), config.getUseCaseGroup().getEffects(), config.getUseCaseGroup().getUseCases().toArray(new UseCase[0]));
            cameras.add(camera);
        }
        this.setActiveConcurrentCameraInfos(cameraInfosToBind);
        return new ConcurrentCamera(cameras);
    }

    @NonNull
    Camera bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraSelector cameraSelector, @Nullable ViewPort viewPort, @NonNull List<CameraEffect> effects, UseCase ... useCases) {
        Threads.checkMainThread();
        LinkedHashSet cameraInternals = cameraSelector.filter(this.mCameraX.getCameraRepository().getCameras());
        if (cameraInternals.isEmpty()) {
            throw new IllegalArgumentException("Provided camera selector unable to resolve a camera for the given use case");
        }
        CameraConfig cameraConfig = this.getCameraConfig(cameraSelector, ((CameraInternal)cameraInternals.iterator().next()).getCameraInfo());
        CameraUseCaseAdapter.CameraId cameraId = CameraUseCaseAdapter.generateCameraId((LinkedHashSet)cameraInternals);
        LifecycleCamera lifecycleCameraToBind = this.mLifecycleCameraRepository.getLifecycleCamera(lifecycleOwner, cameraId, cameraConfig);
        Collection<LifecycleCamera> lifecycleCameras = this.mLifecycleCameraRepository.getLifecycleCameras();
        for (UseCase useCase : useCases) {
            for (LifecycleCamera lifecycleCamera : lifecycleCameras) {
                if (!lifecycleCamera.isBound(useCase) || lifecycleCamera == lifecycleCameraToBind) continue;
                throw new IllegalStateException(String.format("Use case %s already bound to a different lifecycle.", useCase));
            }
        }
        if (lifecycleCameraToBind == null) {
            lifecycleCameraToBind = this.mLifecycleCameraRepository.createLifecycleCamera(lifecycleOwner, new CameraUseCaseAdapter(cameraInternals, this.mCameraX.getCameraFactory().getCameraCoordinator(), this.mCameraX.getCameraDeviceSurfaceManager(), this.mCameraX.getDefaultConfigFactory(), cameraConfig));
        }
        if (useCases.length == 0) {
            return lifecycleCameraToBind;
        }
        this.mLifecycleCameraRepository.bindToLifecycleCamera(lifecycleCameraToBind, viewPort, effects, Arrays.asList(useCases), this.mCameraX.getCameraFactory().getCameraCoordinator());
        return lifecycleCameraToBind;
    }

    @NonNull
    private CameraConfig getCameraConfig(@NonNull CameraSelector cameraSelector, @NonNull CameraInfo cameraInfo) {
        CameraConfig cameraConfig = null;
        for (CameraFilter cameraFilter : cameraSelector.getCameraFilterSet()) {
            CameraConfig extendedCameraConfig;
            if (cameraFilter.getIdentifier() == CameraFilter.DEFAULT_ID || (extendedCameraConfig = ExtendedCameraConfigProviderStore.getConfigProvider((Object)cameraFilter.getIdentifier()).getConfig(cameraInfo, this.mContext)) == null) continue;
            if (cameraConfig != null) {
                throw new IllegalArgumentException("Cannot apply multiple extended camera configs at the same time.");
            }
            cameraConfig = extendedCameraConfig;
        }
        if (cameraConfig == null) {
            cameraConfig = CameraConfigs.defaultConfig();
        }
        return cameraConfig;
    }

    @Override
    public boolean isBound(@NonNull UseCase useCase) {
        for (LifecycleCamera lifecycleCamera : this.mLifecycleCameraRepository.getLifecycleCameras()) {
            if (!lifecycleCamera.isBound(useCase)) continue;
            return true;
        }
        return false;
    }

    @Override
    @MainThread
    public void unbind(UseCase ... useCases) {
        Threads.checkMainThread();
        if (this.getCameraOperatingMode() == 2) {
            throw new UnsupportedOperationException("unbind usecase is not supported in concurrent camera mode, call unbindAll() first");
        }
        this.mLifecycleCameraRepository.unbind(Arrays.asList(useCases));
    }

    @Override
    @MainThread
    public void unbindAll() {
        Threads.checkMainThread();
        this.setCameraOperatingMode(0);
        this.mLifecycleCameraRepository.unbindAll();
    }

    public boolean hasCamera(@NonNull CameraSelector cameraSelector) throws CameraInfoUnavailableException {
        try {
            cameraSelector.select(this.mCameraX.getCameraRepository().getCameras());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @NonNull
    public List<CameraInfo> getAvailableCameraInfos() {
        ArrayList<CameraInfo> availableCameraInfos = new ArrayList<CameraInfo>();
        LinkedHashSet cameras = this.mCameraX.getCameraRepository().getCameras();
        for (CameraInternal camera : cameras) {
            availableCameraInfos.add(camera.getCameraInfo());
        }
        return availableCameraInfos;
    }

    @NonNull
    public List<List<CameraInfo>> getAvailableConcurrentCameraInfos() {
        Objects.requireNonNull(this.mCameraX);
        Objects.requireNonNull(this.mCameraX.getCameraFactory().getCameraCoordinator());
        List concurrentCameraSelectorLists = this.mCameraX.getCameraFactory().getCameraCoordinator().getConcurrentCameraSelectors();
        List<CameraInfo> availableCameraInfos = this.getAvailableCameraInfos();
        ArrayList<List<CameraInfo>> availableConcurrentCameraInfos = new ArrayList<List<CameraInfo>>();
        for (List cameraSelectors : concurrentCameraSelectorLists) {
            ArrayList<CameraInfo> cameraInfos = new ArrayList<CameraInfo>();
            for (CameraSelector cameraSelector : cameraSelectors) {
                CameraInfo cameraInfo = this.getCameraInfoFromCameraSelector(cameraSelector, availableCameraInfos);
                if (cameraInfo == null) continue;
                cameraInfos.add(cameraInfo);
            }
            availableConcurrentCameraInfos.add(cameraInfos);
        }
        return availableConcurrentCameraInfos;
    }

    @MainThread
    public boolean isConcurrentCameraModeOn() {
        return this.getCameraOperatingMode() == 2;
    }

    private int getCameraOperatingMode() {
        if (this.mCameraX == null) {
            return 0;
        }
        return this.mCameraX.getCameraFactory().getCameraCoordinator().getCameraOperatingMode();
    }

    private void setCameraOperatingMode(int cameraOperatingMode) {
        if (this.mCameraX == null) {
            return;
        }
        this.mCameraX.getCameraFactory().getCameraCoordinator().setCameraOperatingMode(cameraOperatingMode);
    }

    @NonNull
    private List<CameraInfo> getActiveConcurrentCameraInfos() {
        if (this.mCameraX == null) {
            return new ArrayList<CameraInfo>();
        }
        return this.mCameraX.getCameraFactory().getCameraCoordinator().getActiveConcurrentCameraInfos();
    }

    private void setActiveConcurrentCameraInfos(@NonNull List<CameraInfo> cameraInfos) {
        if (this.mCameraX == null) {
            return;
        }
        this.mCameraX.getCameraFactory().getCameraCoordinator().setActiveConcurrentCameraInfos(cameraInfos);
    }

    @Nullable
    private CameraInfo getCameraInfoFromCameraSelector(@NonNull CameraSelector cameraSelector, @NonNull List<CameraInfo> availableCameraInfos) {
        List cameraInfos = cameraSelector.filter(availableCameraInfos);
        return cameraInfos.isEmpty() ? null : (CameraInfo)cameraInfos.get(0);
    }

    private ProcessCameraProvider() {
    }
}

