/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.DynamicRange;
import androidx.camera.video.Quality;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@RequiresApi(value=21)
public interface VideoCapabilities {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public static final VideoCapabilities EMPTY = new VideoCapabilities(){

        @Override
        @NonNull
        public Set<DynamicRange> getSupportedDynamicRanges() {
            return new HashSet<DynamicRange>();
        }

        @Override
        @NonNull
        public List<Quality> getSupportedQualities(@NonNull DynamicRange dynamicRange) {
            return new ArrayList<Quality>();
        }

        @Override
        public boolean isQualitySupported(@NonNull Quality quality, @NonNull DynamicRange dynamicRange) {
            return false;
        }
    };

    @NonNull
    public Set<DynamicRange> getSupportedDynamicRanges();

    @NonNull
    public List<Quality> getSupportedQualities(@NonNull DynamicRange var1);

    public boolean isQualitySupported(@NonNull Quality var1, @NonNull DynamicRange var2);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    default public VideoValidatedEncoderProfilesProxy getProfiles(@NonNull Quality quality, @NonNull DynamicRange dynamicRange) {
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    default public VideoValidatedEncoderProfilesProxy findHighestSupportedEncoderProfilesFor(@NonNull Size size, @NonNull DynamicRange dynamicRange) {
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    default public Quality findHighestSupportedQualityFor(@NonNull Size size, @NonNull DynamicRange dynamicRange) {
        return Quality.NONE;
    }
}

