/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.compat.quirk;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.video.Quality;
import androidx.camera.video.internal.compat.quirk.VideoQualityQuirk;
import java.util.Arrays;
import java.util.Locale;

@RequiresApi(value=21)
public class ReportedVideoQualityNotSupportedQuirk
implements VideoQualityQuirk {
    static boolean load() {
        return ReportedVideoQualityNotSupportedQuirk.isHuaweiMate20() || ReportedVideoQualityNotSupportedQuirk.isHuaweiMate20Pro() || ReportedVideoQualityNotSupportedQuirk.isVivoY91i() || ReportedVideoQualityNotSupportedQuirk.isHuaweiP40Lite();
    }

    private static boolean isHuaweiMate20() {
        return "Huawei".equalsIgnoreCase(Build.BRAND) && "HMA-L29".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isHuaweiMate20Pro() {
        return "Huawei".equalsIgnoreCase(Build.BRAND) && "LYA-AL00".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isVivoY91i() {
        return "Vivo".equalsIgnoreCase(Build.BRAND) && "vivo 1820".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isHuaweiP40Lite() {
        return "Huawei".equalsIgnoreCase(Build.MANUFACTURER) && Arrays.asList("JNY-L21A", "JNY-L01A", "JNY-L21B", "JNY-L22A", "JNY-L02A", "JNY-L22B", "JNY-LX1").contains(Build.MODEL.toUpperCase(Locale.US));
    }

    @Override
    public boolean isProblematicVideoQuality(@NonNull CameraInfoInternal cameraInfo, @NonNull Quality quality) {
        if (ReportedVideoQualityNotSupportedQuirk.isHuaweiMate20() || ReportedVideoQualityNotSupportedQuirk.isHuaweiMate20Pro()) {
            return quality == Quality.UHD;
        }
        if (ReportedVideoQualityNotSupportedQuirk.isVivoY91i()) {
            return quality == Quality.HD || quality == Quality.FHD;
        }
        if (ReportedVideoQualityNotSupportedQuirk.isHuaweiP40Lite()) {
            return cameraInfo.getLensFacing() == 0 && (quality == Quality.FHD || quality == Quality.HD);
        }
        return false;
    }

    @Override
    public boolean workaroundBySurfaceProcessing() {
        return ReportedVideoQualityNotSupportedQuirk.isHuaweiMate20() || ReportedVideoQualityNotSupportedQuirk.isHuaweiMate20Pro() || ReportedVideoQualityNotSupportedQuirk.isHuaweiP40Lite();
    }
}

