/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.internal.encoder.VideoEncoderConfig;
import androidx.camera.video.internal.encoder.VideoEncoderDataSpace;

final class AutoValue_VideoEncoderConfig
extends VideoEncoderConfig {
    private final String mimeType;
    private final int profile;
    private final Timebase inputTimebase;
    private final Size resolution;
    private final int colorFormat;
    private final VideoEncoderDataSpace dataSpace;
    private final int frameRate;
    private final int IFrameInterval;
    private final int bitrate;

    private AutoValue_VideoEncoderConfig(String mimeType, int profile, Timebase inputTimebase, Size resolution, int colorFormat, VideoEncoderDataSpace dataSpace, int frameRate, int IFrameInterval, int bitrate) {
        this.mimeType = mimeType;
        this.profile = profile;
        this.inputTimebase = inputTimebase;
        this.resolution = resolution;
        this.colorFormat = colorFormat;
        this.dataSpace = dataSpace;
        this.frameRate = frameRate;
        this.IFrameInterval = IFrameInterval;
        this.bitrate = bitrate;
    }

    @Override
    @NonNull
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public int getProfile() {
        return this.profile;
    }

    @Override
    @NonNull
    public Timebase getInputTimebase() {
        return this.inputTimebase;
    }

    @Override
    @NonNull
    public Size getResolution() {
        return this.resolution;
    }

    @Override
    public int getColorFormat() {
        return this.colorFormat;
    }

    @Override
    @NonNull
    public VideoEncoderDataSpace getDataSpace() {
        return this.dataSpace;
    }

    @Override
    public int getFrameRate() {
        return this.frameRate;
    }

    @Override
    public int getIFrameInterval() {
        return this.IFrameInterval;
    }

    @Override
    public int getBitrate() {
        return this.bitrate;
    }

    public String toString() {
        return "VideoEncoderConfig{mimeType=" + this.mimeType + ", profile=" + this.profile + ", inputTimebase=" + this.inputTimebase + ", resolution=" + this.resolution + ", colorFormat=" + this.colorFormat + ", dataSpace=" + this.dataSpace + ", frameRate=" + this.frameRate + ", IFrameInterval=" + this.IFrameInterval + ", bitrate=" + this.bitrate + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VideoEncoderConfig) {
            VideoEncoderConfig that = (VideoEncoderConfig)o;
            return this.mimeType.equals(that.getMimeType()) && this.profile == that.getProfile() && this.inputTimebase.equals((Object)that.getInputTimebase()) && this.resolution.equals((Object)that.getResolution()) && this.colorFormat == that.getColorFormat() && this.dataSpace.equals(that.getDataSpace()) && this.frameRate == that.getFrameRate() && this.IFrameInterval == that.getIFrameInterval() && this.bitrate == that.getBitrate();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.mimeType.hashCode();
        h$ *= 1000003;
        h$ ^= this.profile;
        h$ *= 1000003;
        h$ ^= this.inputTimebase.hashCode();
        h$ *= 1000003;
        h$ ^= this.resolution.hashCode();
        h$ *= 1000003;
        h$ ^= this.colorFormat;
        h$ *= 1000003;
        h$ ^= this.dataSpace.hashCode();
        h$ *= 1000003;
        h$ ^= this.frameRate;
        h$ *= 1000003;
        h$ ^= this.IFrameInterval;
        h$ *= 1000003;
        return h$ ^= this.bitrate;
    }

    static final class Builder
    extends VideoEncoderConfig.Builder {
        private String mimeType;
        private Integer profile;
        private Timebase inputTimebase;
        private Size resolution;
        private Integer colorFormat;
        private VideoEncoderDataSpace dataSpace;
        private Integer frameRate;
        private Integer IFrameInterval;
        private Integer bitrate;

        Builder() {
        }

        @Override
        public VideoEncoderConfig.Builder setMimeType(String mimeType) {
            if (mimeType == null) {
                throw new NullPointerException("Null mimeType");
            }
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setProfile(int profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setInputTimebase(Timebase inputTimebase) {
            if (inputTimebase == null) {
                throw new NullPointerException("Null inputTimebase");
            }
            this.inputTimebase = inputTimebase;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setResolution(Size resolution) {
            if (resolution == null) {
                throw new NullPointerException("Null resolution");
            }
            this.resolution = resolution;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setColorFormat(int colorFormat) {
            this.colorFormat = colorFormat;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setDataSpace(VideoEncoderDataSpace dataSpace) {
            if (dataSpace == null) {
                throw new NullPointerException("Null dataSpace");
            }
            this.dataSpace = dataSpace;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setFrameRate(int frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setIFrameInterval(int IFrameInterval) {
            this.IFrameInterval = IFrameInterval;
            return this;
        }

        @Override
        public VideoEncoderConfig.Builder setBitrate(int bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        @Override
        public VideoEncoderConfig build() {
            String missing = "";
            if (this.mimeType == null) {
                missing = missing + " mimeType";
            }
            if (this.profile == null) {
                missing = missing + " profile";
            }
            if (this.inputTimebase == null) {
                missing = missing + " inputTimebase";
            }
            if (this.resolution == null) {
                missing = missing + " resolution";
            }
            if (this.colorFormat == null) {
                missing = missing + " colorFormat";
            }
            if (this.dataSpace == null) {
                missing = missing + " dataSpace";
            }
            if (this.frameRate == null) {
                missing = missing + " frameRate";
            }
            if (this.IFrameInterval == null) {
                missing = missing + " IFrameInterval";
            }
            if (this.bitrate == null) {
                missing = missing + " bitrate";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_VideoEncoderConfig(this.mimeType, this.profile, this.inputTimebase, this.resolution, this.colorFormat, this.dataSpace, this.frameRate, this.IFrameInterval, this.bitrate);
        }
    }
}

