/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.video.internal.AutoValue_VideoValidatedEncoderProfilesProxy;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RequiresApi(value=21)
@AutoValue
public abstract class VideoValidatedEncoderProfilesProxy
implements EncoderProfilesProxy {
    @NonNull
    public static VideoValidatedEncoderProfilesProxy from(@NonNull EncoderProfilesProxy profiles) {
        return VideoValidatedEncoderProfilesProxy.create(profiles.getDefaultDurationSeconds(), profiles.getRecommendedFileFormat(), profiles.getAudioProfiles(), profiles.getVideoProfiles());
    }

    @NonNull
    public static VideoValidatedEncoderProfilesProxy create(int defaultDurationSeconds, int recommendedFileFormat, @NonNull List<EncoderProfilesProxy.AudioProfileProxy> audioProfiles, @NonNull List<EncoderProfilesProxy.VideoProfileProxy> videoProfiles) {
        Preconditions.checkArgument((!videoProfiles.isEmpty() ? 1 : 0) != 0, (Object)"Should contain at least one VideoProfile.");
        EncoderProfilesProxy.VideoProfileProxy defaultVideoProfile = videoProfiles.get(0);
        EncoderProfilesProxy.AudioProfileProxy defaultAudioProfile = null;
        if (!audioProfiles.isEmpty()) {
            defaultAudioProfile = audioProfiles.get(0);
        }
        return new AutoValue_VideoValidatedEncoderProfilesProxy(defaultDurationSeconds, recommendedFileFormat, Collections.unmodifiableList(new ArrayList<EncoderProfilesProxy.AudioProfileProxy>(audioProfiles)), Collections.unmodifiableList(new ArrayList<EncoderProfilesProxy.VideoProfileProxy>(videoProfiles)), defaultAudioProfile, defaultVideoProfile);
    }

    @Nullable
    public abstract EncoderProfilesProxy.AudioProfileProxy getDefaultAudioProfile();

    @NonNull
    public abstract EncoderProfilesProxy.VideoProfileProxy getDefaultVideoProfile();
}

