/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.audio;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.video.internal.audio.AutoValue_AudioStream_PacketInfo;
import com.google.auto.value.AutoValue;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public interface AudioStream {
    public void start() throws AudioStreamException, IllegalStateException;

    public void stop() throws IllegalStateException;

    public void release();

    @NonNull
    public PacketInfo read(@NonNull ByteBuffer var1);

    public void setCallback(@Nullable AudioStreamCallback var1, @Nullable Executor var2);

    public static class AudioStreamException
    extends Exception {
        public AudioStreamException() {
        }

        public AudioStreamException(@NonNull String message) {
            super(message);
        }

        public AudioStreamException(@NonNull String message, @NonNull Throwable cause) {
            super(message, cause);
        }

        public AudioStreamException(@NonNull Throwable cause) {
            super(cause);
        }
    }

    public static interface AudioStreamCallback {
        default public void onSilenceStateChanged(boolean isSilenced) {
        }
    }

    @AutoValue
    public static abstract class PacketInfo {
        @NonNull
        public static PacketInfo of(int sizeInBytes, long timestampNs) {
            return new AutoValue_AudioStream_PacketInfo(sizeInBytes, timestampNs);
        }

        public abstract int getSizeInBytes();

        public abstract long getTimestampNs();
    }
}

