/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.camera.video.Quality;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import androidx.core.util.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@RequiresApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class CapabilitiesByQuality {
    private static final String TAG = "CapabilitiesByQuality";
    private final Map<Quality, VideoValidatedEncoderProfilesProxy> mSupportedProfilesMap = new LinkedHashMap<Quality, VideoValidatedEncoderProfilesProxy>();
    private final TreeMap<Size, Quality> mAreaSortedSizeToQualityMap = new TreeMap(new CompareSizesByArea());
    private final VideoValidatedEncoderProfilesProxy mHighestProfiles;
    private final VideoValidatedEncoderProfilesProxy mLowestProfiles;

    public CapabilitiesByQuality(@NonNull EncoderProfilesProvider provider) {
        for (Quality quality : Quality.getSortedQualities()) {
            EncoderProfilesProxy profiles = this.getEncoderProfiles(quality, provider);
            if (profiles == null) continue;
            Logger.d((String)TAG, (String)("profiles = " + profiles));
            VideoValidatedEncoderProfilesProxy validatedProfiles = this.toValidatedProfiles(profiles);
            if (validatedProfiles == null) {
                Logger.w((String)TAG, (String)("EncoderProfiles of quality " + quality + " has no video validated profiles."));
                continue;
            }
            EncoderProfilesProxy.VideoProfileProxy videoProfile = validatedProfiles.getDefaultVideoProfile();
            Size size = new Size(videoProfile.getWidth(), videoProfile.getHeight());
            this.mAreaSortedSizeToQualityMap.put(size, quality);
            this.mSupportedProfilesMap.put(quality, validatedProfiles);
        }
        if (this.mSupportedProfilesMap.isEmpty()) {
            Logger.e((String)TAG, (String)"No supported EncoderProfiles");
            this.mLowestProfiles = null;
            this.mHighestProfiles = null;
        } else {
            ArrayDeque<VideoValidatedEncoderProfilesProxy> profileQueue = new ArrayDeque<VideoValidatedEncoderProfilesProxy>(this.mSupportedProfilesMap.values());
            this.mHighestProfiles = (VideoValidatedEncoderProfilesProxy)profileQueue.peekFirst();
            this.mLowestProfiles = (VideoValidatedEncoderProfilesProxy)profileQueue.peekLast();
        }
    }

    @NonNull
    public List<Quality> getSupportedQualities() {
        return new ArrayList<Quality>(this.mSupportedProfilesMap.keySet());
    }

    public boolean isQualitySupported(@NonNull Quality quality) {
        CapabilitiesByQuality.checkQualityConstantsOrThrow(quality);
        return this.getProfiles(quality) != null;
    }

    @Nullable
    public VideoValidatedEncoderProfilesProxy getProfiles(@NonNull Quality quality) {
        CapabilitiesByQuality.checkQualityConstantsOrThrow(quality);
        if (quality == Quality.HIGHEST) {
            return this.mHighestProfiles;
        }
        if (quality == Quality.LOWEST) {
            return this.mLowestProfiles;
        }
        return this.mSupportedProfilesMap.get(quality);
    }

    @Nullable
    public VideoValidatedEncoderProfilesProxy findNearestHigherSupportedEncoderProfilesFor(@NonNull Size size) {
        VideoValidatedEncoderProfilesProxy encoderProfiles = null;
        Quality highestSupportedQuality = this.findNearestHigherSupportedQualityFor(size);
        Logger.d((String)TAG, (String)("Using supported quality of " + highestSupportedQuality + " for size " + size));
        if (highestSupportedQuality != Quality.NONE && (encoderProfiles = this.getProfiles(highestSupportedQuality)) == null) {
            throw new AssertionError((Object)"Camera advertised available quality but did not produce EncoderProfiles for advertised quality.");
        }
        return encoderProfiles;
    }

    @NonNull
    public Quality findNearestHigherSupportedQualityFor(@NonNull Size size) {
        Quality quality = (Quality)SizeUtil.findNearestHigherFor((Size)size, this.mAreaSortedSizeToQualityMap);
        return quality != null ? quality : Quality.NONE;
    }

    @Nullable
    private EncoderProfilesProxy getEncoderProfiles(@NonNull Quality quality, @NonNull EncoderProfilesProvider provider) {
        Preconditions.checkState((boolean)(quality instanceof Quality.ConstantQuality), (String)"Currently only support ConstantQuality");
        int qualityValue = ((Quality.ConstantQuality)quality).getValue();
        return provider.getAll(qualityValue);
    }

    @Nullable
    private VideoValidatedEncoderProfilesProxy toValidatedProfiles(@NonNull EncoderProfilesProxy profiles) {
        List videoProfiles = profiles.getVideoProfiles();
        if (videoProfiles.isEmpty()) {
            return null;
        }
        return VideoValidatedEncoderProfilesProxy.from(profiles);
    }

    private static void checkQualityConstantsOrThrow(@NonNull Quality quality) {
        Preconditions.checkArgument((boolean)Quality.containsQuality(quality), (Object)("Unknown quality: " + quality));
    }
}

