/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.location.Location;
import android.media.MediaMuxer;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Pair;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.MutableStateObservable;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.StateObservable;
import androidx.camera.core.impl.Timebase;
import androidx.camera.core.impl.utils.CloseGuardHelper;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.utils.ArrayRingBuffer;
import androidx.camera.core.internal.utils.RingBuffer;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.AudioStats;
import androidx.camera.video.AutoValue_Recorder_RecordingRecord;
import androidx.camera.video.FallbackStrategy;
import androidx.camera.video.FileDescriptorOutputOptions;
import androidx.camera.video.FileOutputOptions;
import androidx.camera.video.MediaSpec;
import androidx.camera.video.MediaStoreOutputOptions;
import androidx.camera.video.OutputOptions;
import androidx.camera.video.OutputResults;
import androidx.camera.video.PendingRecording;
import androidx.camera.video.Quality;
import androidx.camera.video.QualitySelector;
import androidx.camera.video.RecorderVideoCapabilities;
import androidx.camera.video.Recording;
import androidx.camera.video.RecordingStats;
import androidx.camera.video.StreamInfo;
import androidx.camera.video.VideoCapabilities;
import androidx.camera.video.VideoEncoderSession;
import androidx.camera.video.VideoOutput;
import androidx.camera.video.VideoRecordEvent;
import androidx.camera.video.VideoSpec;
import androidx.camera.video.internal.DebugUtils;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import androidx.camera.video.internal.audio.AudioSettings;
import androidx.camera.video.internal.audio.AudioSource;
import androidx.camera.video.internal.audio.AudioSourceAccessException;
import androidx.camera.video.internal.compat.Api26Impl;
import androidx.camera.video.internal.compat.quirk.DeactivateEncoderSurfaceBeforeStopEncoderQuirk;
import androidx.camera.video.internal.compat.quirk.DeviceQuirks;
import androidx.camera.video.internal.compat.quirk.EncoderNotUsePersistentInputSurfaceQuirk;
import androidx.camera.video.internal.config.AudioConfigUtil;
import androidx.camera.video.internal.config.AudioMimeInfo;
import androidx.camera.video.internal.encoder.AudioEncoderConfig;
import androidx.camera.video.internal.encoder.BufferCopiedEncodedData;
import androidx.camera.video.internal.encoder.EncodeException;
import androidx.camera.video.internal.encoder.EncodedData;
import androidx.camera.video.internal.encoder.Encoder;
import androidx.camera.video.internal.encoder.EncoderCallback;
import androidx.camera.video.internal.encoder.EncoderFactory;
import androidx.camera.video.internal.encoder.EncoderImpl;
import androidx.camera.video.internal.encoder.InvalidConfigException;
import androidx.camera.video.internal.encoder.OutputConfig;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import androidx.camera.video.internal.encoder.VideoEncoderInfoImpl;
import androidx.camera.video.internal.utils.OutputUtil;
import androidx.camera.video.internal.workaround.CorrectNegativeLatLongForMediaMuxer;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=21)
public final class Recorder
implements VideoOutput {
    private static final String TAG = "Recorder";
    public static final int VIDEO_CAPABILITIES_SOURCE_CAMCORDER_PROFILE = 0;
    public static final int VIDEO_CAPABILITIES_SOURCE_CODEC_CAPABILITIES = 1;
    private static final Set<State> PENDING_STATES = Collections.unmodifiableSet(EnumSet.of(State.PENDING_RECORDING, State.PENDING_PAUSED));
    private static final Set<State> VALID_NON_PENDING_STATES_WHILE_PENDING = Collections.unmodifiableSet(EnumSet.of(State.CONFIGURING, State.IDLING, State.RESETTING, State.STOPPING, State.ERROR));
    public static final QualitySelector DEFAULT_QUALITY_SELECTOR = QualitySelector.fromOrderedList(Arrays.asList(Quality.FHD, Quality.HD, Quality.SD), FallbackStrategy.higherQualityOrLowerThan(Quality.FHD));
    private static final VideoSpec VIDEO_SPEC_DEFAULT = VideoSpec.builder().setQualitySelector(DEFAULT_QUALITY_SELECTOR).setAspectRatio(-1).build();
    private static final MediaSpec MEDIA_SPEC_DEFAULT = MediaSpec.builder().setOutputFormat(-1).setVideoSpec(VIDEO_SPEC_DEFAULT).build();
    private static final String MEDIA_COLUMN = "_data";
    private static final Exception PENDING_RECORDING_ERROR_CAUSE_SOURCE_INACTIVE = new RuntimeException("The video frame producer became inactive before any data was received.");
    private static final int PENDING = 1;
    private static final int NOT_PENDING = 0;
    private static final long SOURCE_NON_STREAMING_TIMEOUT_MS = 1000L;
    private static final int AUDIO_CACHE_SIZE = 60;
    @VisibleForTesting
    static final EncoderFactory DEFAULT_ENCODER_FACTORY = EncoderImpl::new;
    private static final Executor AUDIO_EXECUTOR = CameraXExecutors.newSequentialExecutor((Executor)CameraXExecutors.ioExecutor());
    private final MutableStateObservable<StreamInfo> mStreamInfo;
    private final Executor mUserProvidedExecutor;
    private final Executor mExecutor;
    final Executor mSequentialExecutor;
    private final EncoderFactory mVideoEncoderFactory;
    private final EncoderFactory mAudioEncoderFactory;
    private final Object mLock = new Object();
    private final boolean mEncoderNotUsePersistentInputSurface = DeviceQuirks.get(EncoderNotUsePersistentInputSurfaceQuirk.class) != null;
    private final int mVideoCapabilitiesSource;
    @GuardedBy(value="mLock")
    private State mState = State.CONFIGURING;
    @GuardedBy(value="mLock")
    private State mNonPendingState = null;
    @GuardedBy(value="mLock")
    int mStreamId = 0;
    @GuardedBy(value="mLock")
    RecordingRecord mActiveRecordingRecord = null;
    @GuardedBy(value="mLock")
    RecordingRecord mPendingRecordingRecord = null;
    @GuardedBy(value="mLock")
    private long mLastGeneratedRecordingId = 0L;
    RecordingRecord mInProgressRecording = null;
    boolean mInProgressRecordingStopping = false;
    @Nullable
    private SurfaceRequest.TransformationInfo mInProgressTransformationInfo = null;
    @Nullable
    private SurfaceRequest.TransformationInfo mSourceTransformationInfo = null;
    private VideoValidatedEncoderProfilesProxy mResolvedEncoderProfiles = null;
    final List<ListenableFuture<Void>> mEncodingFutures = new ArrayList<ListenableFuture<Void>>();
    Integer mAudioTrackIndex = null;
    Integer mVideoTrackIndex = null;
    SurfaceRequest mLatestSurfaceRequest;
    Timebase mVideoSourceTimebase;
    Surface mLatestSurface = null;
    Surface mActiveSurface = null;
    MediaMuxer mMediaMuxer = null;
    final MutableStateObservable<MediaSpec> mMediaSpec;
    AudioSource mAudioSource = null;
    Encoder mVideoEncoder = null;
    OutputConfig mVideoOutputConfig = null;
    Encoder mAudioEncoder = null;
    OutputConfig mAudioOutputConfig = null;
    AudioState mAudioState = AudioState.INITIALIZING;
    @NonNull
    Uri mOutputUri = Uri.EMPTY;
    long mRecordingBytes = 0L;
    long mRecordingDurationNs = 0L;
    @VisibleForTesting
    long mFirstRecordingVideoDataTimeUs = Long.MAX_VALUE;
    @VisibleForTesting
    int mFirstRecordingVideoBitrate = 0;
    @VisibleForTesting
    Range<Integer> mVideoEncoderBitrateRange = null;
    @VisibleForTesting
    long mFirstRecordingAudioDataTimeUs = Long.MAX_VALUE;
    long mPreviousRecordingVideoDataTimeUs = Long.MAX_VALUE;
    long mPreviousRecordingAudioDataTimeUs = Long.MAX_VALUE;
    long mFileSizeLimitInBytes = 0L;
    long mDurationLimitNs = 0L;
    int mRecordingStopError = 1;
    Throwable mRecordingStopErrorCause = null;
    EncodedData mPendingFirstVideoData = null;
    @NonNull
    final RingBuffer<EncodedData> mPendingAudioRingBuffer = new ArrayRingBuffer(60);
    Throwable mAudioErrorCause = null;
    boolean mIsAudioSourceSilenced = false;
    VideoOutput.SourceState mSourceState = VideoOutput.SourceState.INACTIVE;
    ScheduledFuture<?> mSourceNonStreamingTimeout = null;
    private boolean mNeedsResetBeforeNextStart = false;
    @NonNull
    VideoEncoderSession mVideoEncoderSession;
    @Nullable
    VideoEncoderSession mVideoEncoderSessionToRelease = null;
    double mAudioAmplitude = 0.0;
    private boolean mShouldSendResumeEvent = false;

    Recorder(@Nullable Executor executor, @NonNull MediaSpec mediaSpec, int videoCapabilitiesSource, @NonNull EncoderFactory videoEncoderFactory, @NonNull EncoderFactory audioEncoderFactory) {
        this.mUserProvidedExecutor = executor;
        this.mExecutor = executor != null ? executor : CameraXExecutors.ioExecutor();
        this.mSequentialExecutor = CameraXExecutors.newSequentialExecutor((Executor)this.mExecutor);
        this.mMediaSpec = MutableStateObservable.withInitialState((Object)this.composeRecorderMediaSpec(mediaSpec));
        this.mVideoCapabilitiesSource = videoCapabilitiesSource;
        this.mStreamInfo = MutableStateObservable.withInitialState((Object)StreamInfo.of(this.mStreamId, this.internalStateToStreamState(this.mState)));
        this.mVideoEncoderFactory = videoEncoderFactory;
        this.mAudioEncoderFactory = audioEncoderFactory;
        this.mVideoEncoderSession = new VideoEncoderSession(this.mVideoEncoderFactory, this.mSequentialExecutor, this.mExecutor);
    }

    @Override
    public void onSurfaceRequested(@NonNull SurfaceRequest request) {
        this.onSurfaceRequested(request, Timebase.UPTIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onSurfaceRequested(@NonNull SurfaceRequest request, @NonNull Timebase timebase) {
        Object object = this.mLock;
        synchronized (object) {
            Logger.d((String)TAG, (String)("Surface is requested in state: " + (Object)((Object)this.mState) + ", Current surface: " + this.mStreamId));
            if (this.mState == State.ERROR) {
                this.setState(State.CONFIGURING);
            }
        }
        this.mSequentialExecutor.execute(() -> this.onSurfaceRequestedInternal(request, timebase));
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Observable<MediaSpec> getMediaSpec() {
        return this.mMediaSpec;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public Observable<StreamInfo> getStreamInfo() {
        return this.mStreamInfo;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onSourceStateChanged(@NonNull VideoOutput.SourceState newState) {
        this.mSequentialExecutor.execute(() -> this.onSourceStateChangedInternal(newState));
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public VideoCapabilities getMediaCapabilities(@NonNull CameraInfo cameraInfo) {
        return Recorder.getVideoCapabilities(cameraInfo, this.mVideoCapabilitiesSource);
    }

    @NonNull
    public PendingRecording prepareRecording(@NonNull Context context, @NonNull FileOutputOptions fileOutputOptions) {
        return this.prepareRecordingInternal(context, fileOutputOptions);
    }

    @RequiresApi(value=26)
    @NonNull
    public PendingRecording prepareRecording(@NonNull Context context, @NonNull FileDescriptorOutputOptions fileDescriptorOutputOptions) {
        if (Build.VERSION.SDK_INT < 26) {
            throw new UnsupportedOperationException("File descriptors as output destinations are not supported on pre-Android O (API 26) devices.");
        }
        return this.prepareRecordingInternal(context, fileDescriptorOutputOptions);
    }

    @NonNull
    public PendingRecording prepareRecording(@NonNull Context context, @NonNull MediaStoreOutputOptions mediaStoreOutputOptions) {
        return this.prepareRecordingInternal(context, mediaStoreOutputOptions);
    }

    @NonNull
    private PendingRecording prepareRecordingInternal(@NonNull Context context, @NonNull OutputOptions options) {
        Preconditions.checkNotNull((Object)options, (Object)"The OutputOptions cannot be null.");
        return new PendingRecording(context, this, options);
    }

    @NonNull
    public QualitySelector getQualitySelector() {
        return this.getObservableData((StateObservable)this.mMediaSpec).getVideoSpec().getQualitySelector();
    }

    public int getVideoCapabilitiesSource() {
        return this.mVideoCapabilitiesSource;
    }

    int getAudioSource() {
        return this.getObservableData((StateObservable)this.mMediaSpec).getAudioSpec().getSource();
    }

    @Nullable
    public Executor getExecutor() {
        return this.mUserProvidedExecutor;
    }

    public int getTargetVideoEncodingBitRate() {
        return (Integer)this.getObservableData((StateObservable)this.mMediaSpec).getVideoSpec().getBitrate().getLower();
    }

    public int getAspectRatio() {
        return this.getObservableData((StateObservable)this.mMediaSpec).getVideoSpec().getAspectRatio();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    Recording start(@NonNull PendingRecording pendingRecording) {
        long recordingId;
        Preconditions.checkNotNull((Object)pendingRecording, (Object)"The given PendingRecording cannot be null.");
        RecordingRecord alreadyInProgressRecording = null;
        int error = 0;
        IOException errorCause = null;
        Object object = this.mLock;
        synchronized (object) {
            recordingId = ++this.mLastGeneratedRecordingId;
            switch (this.mState) {
                case PAUSED: 
                case RECORDING: {
                    alreadyInProgressRecording = this.mActiveRecordingRecord;
                    break;
                }
                case PENDING_PAUSED: 
                case PENDING_RECORDING: {
                    alreadyInProgressRecording = (RecordingRecord)Preconditions.checkNotNull((Object)this.mPendingRecordingRecord);
                    break;
                }
                case RESETTING: 
                case STOPPING: 
                case CONFIGURING: 
                case ERROR: 
                case IDLING: {
                    if (this.mState == State.IDLING) {
                        Preconditions.checkState((this.mActiveRecordingRecord == null && this.mPendingRecordingRecord == null ? 1 : 0) != 0, (String)"Expected recorder to be idle but a recording is either pending or in progress.");
                    }
                    try {
                        RecordingRecord recordingRecord = RecordingRecord.from(pendingRecording, recordingId);
                        recordingRecord.initializeRecording(pendingRecording.getApplicationContext());
                        this.mPendingRecordingRecord = recordingRecord;
                        if (this.mState == State.IDLING) {
                            this.setState(State.PENDING_RECORDING);
                            this.mSequentialExecutor.execute(this::tryServicePendingRecording);
                            break;
                        }
                        if (this.mState == State.ERROR) {
                            this.setState(State.PENDING_RECORDING);
                            this.mSequentialExecutor.execute(() -> {
                                if (this.mLatestSurfaceRequest == null) {
                                    throw new AssertionError((Object)"surface request is required to retry initialization.");
                                }
                                this.configureInternal(this.mLatestSurfaceRequest, this.mVideoSourceTimebase);
                            });
                            break;
                        }
                        this.setState(State.PENDING_RECORDING);
                        break;
                    }
                    catch (IOException e) {
                        error = 5;
                        errorCause = e;
                    }
                }
            }
        }
        if (alreadyInProgressRecording != null) {
            throw new IllegalStateException("A recording is already in progress. Previous recordings must be stopped before a new recording can be started.");
        }
        if (error != 0) {
            Logger.e((String)TAG, (String)("Recording was started when the Recorder had encountered error " + errorCause));
            this.finalizePendingRecording(RecordingRecord.from(pendingRecording, recordingId), error, errorCause);
            return Recording.createFinalizedFrom(pendingRecording, recordingId);
        }
        return Recording.from(pendingRecording, recordingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause(@NonNull Recording activeRecording) {
        Object object = this.mLock;
        synchronized (object) {
            if (!Recorder.isSameRecording(activeRecording, this.mPendingRecordingRecord) && !Recorder.isSameRecording(activeRecording, this.mActiveRecordingRecord)) {
                Logger.d((String)TAG, (String)("pause() called on a recording that is no longer active: " + activeRecording.getOutputOptions()));
                return;
            }
            switch (this.mState) {
                case PENDING_RECORDING: {
                    this.setState(State.PENDING_PAUSED);
                    break;
                }
                case CONFIGURING: 
                case IDLING: {
                    throw new IllegalStateException("Called pause() from invalid state: " + (Object)((Object)this.mState));
                }
                case RECORDING: {
                    this.setState(State.PAUSED);
                    RecordingRecord finalActiveRecordingRecord = this.mActiveRecordingRecord;
                    this.mSequentialExecutor.execute(() -> this.pauseInternal(finalActiveRecordingRecord));
                    break;
                }
                case PAUSED: 
                case PENDING_PAUSED: {
                    break;
                }
                case RESETTING: 
                case STOPPING: {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume(@NonNull Recording activeRecording) {
        Object object = this.mLock;
        synchronized (object) {
            if (!Recorder.isSameRecording(activeRecording, this.mPendingRecordingRecord) && !Recorder.isSameRecording(activeRecording, this.mActiveRecordingRecord)) {
                Logger.d((String)TAG, (String)("resume() called on a recording that is no longer active: " + activeRecording.getOutputOptions()));
                return;
            }
            switch (this.mState) {
                case PENDING_PAUSED: {
                    this.setState(State.PENDING_RECORDING);
                    break;
                }
                case CONFIGURING: 
                case IDLING: {
                    throw new IllegalStateException("Called resume() from invalid state: " + (Object)((Object)this.mState));
                }
                case RECORDING: 
                case PENDING_RECORDING: 
                case RESETTING: 
                case STOPPING: {
                    break;
                }
                case PAUSED: {
                    this.setState(State.RECORDING);
                    RecordingRecord finalActiveRecordingRecord = this.mActiveRecordingRecord;
                    this.mSequentialExecutor.execute(() -> this.resumeInternal(finalActiveRecordingRecord));
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(@NonNull Recording activeRecording, int error, @Nullable Throwable errorCause) {
        RecordingRecord pendingRecordingToFinalize = null;
        Object object = this.mLock;
        synchronized (object) {
            if (!Recorder.isSameRecording(activeRecording, this.mPendingRecordingRecord) && !Recorder.isSameRecording(activeRecording, this.mActiveRecordingRecord)) {
                Logger.d((String)TAG, (String)("stop() called on a recording that is no longer active: " + activeRecording.getOutputOptions()));
                return;
            }
            switch (this.mState) {
                case PENDING_PAUSED: 
                case PENDING_RECORDING: {
                    Preconditions.checkState((boolean)Recorder.isSameRecording(activeRecording, this.mPendingRecordingRecord));
                    pendingRecordingToFinalize = this.mPendingRecordingRecord;
                    this.mPendingRecordingRecord = null;
                    this.restoreNonPendingState();
                    break;
                }
                case RESETTING: 
                case STOPPING: {
                    Preconditions.checkState((boolean)Recorder.isSameRecording(activeRecording, this.mActiveRecordingRecord));
                    break;
                }
                case CONFIGURING: 
                case IDLING: {
                    throw new IllegalStateException("Calling stop() while idling or initializing is invalid.");
                }
                case PAUSED: 
                case RECORDING: {
                    this.setState(State.STOPPING);
                    long explicitlyStopTimeUs = TimeUnit.NANOSECONDS.toMicros(System.nanoTime());
                    RecordingRecord finalActiveRecordingRecord = this.mActiveRecordingRecord;
                    this.mSequentialExecutor.execute(() -> this.stopInternal(finalActiveRecordingRecord, explicitlyStopTimeUs, error, errorCause));
                    break;
                }
            }
        }
        if (pendingRecordingToFinalize != null) {
            if (error == 10) {
                Logger.e((String)TAG, (String)"Recording was stopped due to recording being garbage collected before any valid data has been produced.");
            }
            this.finalizePendingRecording(pendingRecordingToFinalize, 8, new RuntimeException("Recording was stopped before any data could be produced.", errorCause));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mute(@NonNull Recording activeRecording, boolean muted) {
        Object object = this.mLock;
        synchronized (object) {
            if (!Recorder.isSameRecording(activeRecording, this.mPendingRecordingRecord) && !Recorder.isSameRecording(activeRecording, this.mActiveRecordingRecord)) {
                Logger.d((String)TAG, (String)("mute() called on a recording that is no longer active: " + activeRecording.getOutputOptions()));
                return;
            }
            RecordingRecord finalRecordingRecord = Recorder.isSameRecording(activeRecording, this.mPendingRecordingRecord) ? this.mPendingRecordingRecord : this.mActiveRecordingRecord;
            this.mSequentialExecutor.execute(() -> this.muteInternal(finalRecordingRecord, muted));
        }
    }

    private void finalizePendingRecording(@NonNull RecordingRecord recordingToFinalize, int error, @Nullable Throwable cause) {
        recordingToFinalize.finalizeRecording(Uri.EMPTY);
        recordingToFinalize.updateVideoRecordEvent(VideoRecordEvent.finalizeWithError(recordingToFinalize.getOutputOptions(), RecordingStats.of(0L, 0L, AudioStats.of(1, this.mAudioErrorCause, 0.0)), OutputResults.of(Uri.EMPTY), error, cause));
    }

    private void onSurfaceRequestedInternal(@NonNull SurfaceRequest request, @NonNull Timebase timebase) {
        if (this.mLatestSurfaceRequest != null && !this.mLatestSurfaceRequest.isServiced()) {
            this.mLatestSurfaceRequest.willNotProvideSurface();
        }
        this.mLatestSurfaceRequest = request;
        this.mVideoSourceTimebase = timebase;
        this.configureInternal(this.mLatestSurfaceRequest, this.mVideoSourceTimebase);
    }

    void onSourceStateChangedInternal(@NonNull VideoOutput.SourceState newState) {
        VideoOutput.SourceState oldState = this.mSourceState;
        this.mSourceState = newState;
        if (oldState == newState) {
            Logger.d((String)TAG, (String)("Video source transitions to the same state: " + (Object)((Object)newState)));
            return;
        }
        Logger.d((String)TAG, (String)("Video source has transitioned to state: " + (Object)((Object)newState)));
        if (newState == VideoOutput.SourceState.INACTIVE) {
            if (this.mActiveSurface == null) {
                this.requestReset(4, null, false);
            } else {
                this.mNeedsResetBeforeNextStart = true;
                if (this.mInProgressRecording != null && !this.mInProgressRecording.isPersistent()) {
                    this.onInProgressRecordingInternalError(this.mInProgressRecording, 4, null);
                }
            }
        } else if (newState == VideoOutput.SourceState.ACTIVE_NON_STREAMING && this.mSourceNonStreamingTimeout != null && this.mSourceNonStreamingTimeout.cancel(false) && this.mVideoEncoder != null) {
            Recorder.notifyEncoderSourceStopped(this.mVideoEncoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestReset(int errorCode, @Nullable Throwable errorCause, boolean videoOnly) {
        boolean shouldReset = false;
        boolean shouldStop = false;
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mState) {
                case PENDING_PAUSED: 
                case PENDING_RECORDING: {
                    shouldReset = true;
                    this.updateNonPendingState(State.RESETTING);
                    break;
                }
                case CONFIGURING: 
                case ERROR: 
                case IDLING: {
                    shouldReset = true;
                    break;
                }
                case PAUSED: 
                case RECORDING: {
                    Preconditions.checkState((this.mInProgressRecording != null ? 1 : 0) != 0, (String)("In-progress recording shouldn't be null when in state " + (Object)((Object)this.mState)));
                    if (this.mActiveRecordingRecord != this.mInProgressRecording) {
                        throw new AssertionError((Object)"In-progress recording does not match the active recording. Unable to reset encoder.");
                    }
                    if (this.isPersistentRecordingInProgress()) {
                        shouldReset = true;
                        break;
                    }
                    shouldStop = true;
                    this.setState(State.RESETTING);
                    break;
                }
                case STOPPING: {
                    this.setState(State.RESETTING);
                    break;
                }
            }
        }
        if (shouldReset) {
            if (videoOnly) {
                this.resetVideo();
            } else {
                this.reset();
            }
        } else if (shouldStop) {
            this.stopInternal(this.mInProgressRecording, -1L, errorCode, errorCause);
        }
    }

    private void configureInternal(@NonNull SurfaceRequest surfaceRequest, @NonNull Timebase videoSourceTimebase) {
        if (surfaceRequest.isServiced()) {
            Logger.w((String)TAG, (String)"Ignore the SurfaceRequest since it is already served.");
            return;
        }
        surfaceRequest.setTransformationInfoListener(this.mSequentialExecutor, transformationInfo -> {
            this.mSourceTransformationInfo = transformationInfo;
        });
        Size surfaceSize = surfaceRequest.getResolution();
        DynamicRange dynamicRange = surfaceRequest.getDynamicRange();
        VideoCapabilities capabilities = Recorder.getVideoCapabilities(surfaceRequest.getCamera().getCameraInfo());
        Quality highestSupportedQuality = capabilities.findNearestHigherSupportedQualityFor(surfaceSize, dynamicRange);
        Logger.d((String)TAG, (String)("Using supported quality of " + highestSupportedQuality + " for surface size " + surfaceSize));
        if (highestSupportedQuality != Quality.NONE) {
            this.mResolvedEncoderProfiles = capabilities.getProfiles(highestSupportedQuality, dynamicRange);
            if (this.mResolvedEncoderProfiles == null) {
                throw new AssertionError((Object)"Camera advertised available quality but did not produce EncoderProfiles  for advertised quality.");
            }
        }
        this.setupVideo(surfaceRequest, videoSourceTimebase);
    }

    private void setupVideo(@NonNull SurfaceRequest request, @NonNull Timebase timebase) {
        this.safeToCloseVideoEncoder().addListener(() -> {
            if (request.isServiced() || this.mVideoEncoderSession.isConfiguredSurfaceRequest(request) && !this.isPersistentRecordingInProgress()) {
                Logger.w((String)TAG, (String)("Ignore the SurfaceRequest " + request + " isServiced: " + request.isServiced() + " VideoEncoderSession: " + this.mVideoEncoderSession + " has been configured with a persistent in-progress recording."));
                return;
            }
            final VideoEncoderSession videoEncoderSession = new VideoEncoderSession(this.mVideoEncoderFactory, this.mSequentialExecutor, this.mExecutor);
            MediaSpec mediaSpec = this.getObservableData((StateObservable)this.mMediaSpec);
            ListenableFuture<Encoder> configureFuture = videoEncoderSession.configure(request, timebase, mediaSpec, this.mResolvedEncoderProfiles);
            this.mVideoEncoderSession = videoEncoderSession;
            Futures.addCallback(configureFuture, (FutureCallback)new FutureCallback<Encoder>(){

                public void onSuccess(@Nullable Encoder result) {
                    Logger.d((String)Recorder.TAG, (String)("VideoEncoder is created. " + result));
                    if (result == null) {
                        return;
                    }
                    Preconditions.checkState((Recorder.this.mVideoEncoderSession == videoEncoderSession ? 1 : 0) != 0);
                    Preconditions.checkState((Recorder.this.mVideoEncoder == null ? 1 : 0) != 0);
                    Recorder.this.onVideoEncoderReady(videoEncoderSession);
                    Recorder.this.onConfigured();
                }

                public void onFailure(@NonNull Throwable t) {
                    Logger.d((String)Recorder.TAG, (String)("VideoEncoder Setup error: " + t));
                    Recorder.this.onEncoderSetupError(t);
                }
            }, (Executor)this.mSequentialExecutor);
        }, this.mSequentialExecutor);
    }

    boolean isPersistentRecordingInProgress() {
        return this.mInProgressRecording != null && this.mInProgressRecording.isPersistent();
    }

    @NonNull
    private ListenableFuture<Void> safeToCloseVideoEncoder() {
        Logger.d((String)TAG, (String)("Try to safely release video encoder: " + this.mVideoEncoder));
        return this.mVideoEncoderSession.signalTermination();
    }

    void onVideoEncoderReady(final @NonNull VideoEncoderSession videoEncoderSession) {
        this.mVideoEncoder = videoEncoderSession.getVideoEncoder();
        this.mVideoEncoderBitrateRange = ((VideoEncoderInfo)this.mVideoEncoder.getEncoderInfo()).getSupportedBitrateRange();
        this.mFirstRecordingVideoBitrate = this.mVideoEncoder.getConfiguredBitrate();
        this.mActiveSurface = videoEncoderSession.getActiveSurface();
        this.setLatestSurface(this.mActiveSurface);
        videoEncoderSession.setOnSurfaceUpdateListener(this.mSequentialExecutor, this::setLatestSurface);
        Futures.addCallback(videoEncoderSession.getReadyToReleaseFuture(), (FutureCallback)new FutureCallback<Encoder>(){

            public void onSuccess(@Nullable Encoder result) {
                Logger.d((String)Recorder.TAG, (String)("VideoEncoder can be released: " + result));
                if (result == null) {
                    return;
                }
                if (Recorder.this.mSourceNonStreamingTimeout != null && Recorder.this.mSourceNonStreamingTimeout.cancel(false) && Recorder.this.mVideoEncoder != null && Recorder.this.mVideoEncoder == result) {
                    Recorder.notifyEncoderSourceStopped(Recorder.this.mVideoEncoder);
                }
                Recorder.this.mVideoEncoderSessionToRelease = videoEncoderSession;
                Recorder.this.setLatestSurface(null);
                Recorder.this.requestReset(4, null, Recorder.this.isPersistentRecordingInProgress());
            }

            public void onFailure(@NonNull Throwable t) {
                Logger.d((String)Recorder.TAG, (String)("Error in ReadyToReleaseFuture: " + t));
            }
        }, (Executor)this.mSequentialExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConfigured() {
        RecordingRecord recordingToStart = null;
        RecordingRecord pendingRecordingToFinalize = null;
        boolean continuePersistentRecording = false;
        int error = 0;
        Exception errorCause = null;
        boolean recordingPaused = false;
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mState) {
                case RESETTING: 
                case IDLING: {
                    throw new AssertionError((Object)("Incorrectly invoke onConfigured() in state " + (Object)((Object)this.mState)));
                }
                case STOPPING: {
                    if (!this.mEncoderNotUsePersistentInputSurface) {
                        throw new AssertionError((Object)"Unexpectedly invoke onConfigured() in a STOPPING state when it's not waiting for a new surface.");
                    }
                    break;
                }
                case PAUSED: {
                    recordingPaused = true;
                }
                case RECORDING: {
                    Preconditions.checkState((boolean)this.isPersistentRecordingInProgress(), (String)"Unexpectedly invoke onConfigured() when there's a non-persistent in-progress recording");
                    continuePersistentRecording = true;
                    break;
                }
                case CONFIGURING: {
                    this.setState(State.IDLING);
                    break;
                }
                case ERROR: {
                    Logger.e((String)TAG, (String)"onConfigured() was invoked when the Recorder had encountered error");
                    break;
                }
                case PENDING_PAUSED: {
                    recordingPaused = true;
                }
                case PENDING_RECORDING: {
                    if (this.mActiveRecordingRecord != null) break;
                    if (this.mSourceState == VideoOutput.SourceState.INACTIVE) {
                        pendingRecordingToFinalize = this.mPendingRecordingRecord;
                        this.mPendingRecordingRecord = null;
                        this.restoreNonPendingState();
                        error = 4;
                        errorCause = PENDING_RECORDING_ERROR_CAUSE_SOURCE_INACTIVE;
                        break;
                    }
                    recordingToStart = this.makePendingRecordingActiveLocked(this.mState);
                }
            }
        }
        if (continuePersistentRecording) {
            this.updateEncoderCallbacks(this.mInProgressRecording, true);
            this.mVideoEncoder.start();
            if (this.mShouldSendResumeEvent) {
                this.mInProgressRecording.updateVideoRecordEvent(VideoRecordEvent.resume(this.mInProgressRecording.getOutputOptions(), this.getInProgressRecordingStats()));
                this.mShouldSendResumeEvent = false;
            }
            if (recordingPaused) {
                this.mVideoEncoder.pause();
            }
        } else if (recordingToStart != null) {
            this.startRecording(recordingToStart, recordingPaused);
        } else if (pendingRecordingToFinalize != null) {
            this.finalizePendingRecording(pendingRecordingToFinalize, error, errorCause);
        }
    }

    @NonNull
    private MediaSpec composeRecorderMediaSpec(@NonNull MediaSpec mediaSpec) {
        MediaSpec.Builder mediaSpecBuilder = mediaSpec.toBuilder();
        VideoSpec videoSpec = mediaSpec.getVideoSpec();
        if (videoSpec.getAspectRatio() == -1) {
            mediaSpecBuilder.configureVideo((Consumer<VideoSpec.Builder>)((Consumer)builder -> builder.setAspectRatio(VIDEO_SPEC_DEFAULT.getAspectRatio())));
        }
        return mediaSpecBuilder.build();
    }

    private static boolean isSameRecording(@NonNull Recording activeRecording, @Nullable RecordingRecord recordingRecord) {
        if (recordingRecord == null) {
            return false;
        }
        return activeRecording.getRecordingId() == recordingRecord.getRecordingId();
    }

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    private void setupAudio(@NonNull RecordingRecord recordingToStart) throws AudioSourceAccessException, InvalidConfigException {
        MediaSpec mediaSpec = this.getObservableData((StateObservable)this.mMediaSpec);
        AudioMimeInfo audioMimeInfo = AudioConfigUtil.resolveAudioMimeInfo(mediaSpec, this.mResolvedEncoderProfiles);
        Timebase audioSourceTimebase = Timebase.UPTIME;
        AudioSettings audioSettings = AudioConfigUtil.resolveAudioSettings(audioMimeInfo, mediaSpec.getAudioSpec());
        if (this.mAudioSource != null) {
            this.releaseCurrentAudioSource();
        }
        this.mAudioSource = this.setupAudioSource(recordingToStart, audioSettings);
        Logger.d((String)TAG, (String)String.format("Set up new audio source: 0x%x", this.mAudioSource.hashCode()));
        AudioEncoderConfig audioEncoderConfig = AudioConfigUtil.resolveAudioEncoderConfig(audioMimeInfo, audioSourceTimebase, audioSettings, mediaSpec.getAudioSpec());
        this.mAudioEncoder = this.mAudioEncoderFactory.createEncoder(this.mExecutor, audioEncoderConfig);
        Encoder.EncoderInput bufferProvider = this.mAudioEncoder.getInput();
        if (!(bufferProvider instanceof Encoder.ByteBufferInput)) {
            throw new AssertionError((Object)"The EncoderInput of audio isn't a ByteBufferInput.");
        }
        this.mAudioSource.setBufferProvider((Encoder.ByteBufferInput)bufferProvider);
    }

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    @NonNull
    private AudioSource setupAudioSource(@NonNull RecordingRecord recordingToStart, @NonNull AudioSettings audioSettings) throws AudioSourceAccessException {
        return recordingToStart.performOneTimeAudioSourceCreation(audioSettings, AUDIO_EXECUTOR);
    }

    private void releaseCurrentAudioSource() {
        if (this.mAudioSource == null) {
            throw new AssertionError((Object)"Cannot release null audio source.");
        }
        final AudioSource audioSource = this.mAudioSource;
        this.mAudioSource = null;
        Logger.d((String)TAG, (String)String.format("Releasing audio source: 0x%x", audioSource.hashCode()));
        Futures.addCallback(audioSource.release(), (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                Logger.d((String)Recorder.TAG, (String)String.format("Released audio source successfully: 0x%x", audioSource.hashCode()));
            }

            public void onFailure(@NonNull Throwable t) {
                Logger.d((String)Recorder.TAG, (String)String.format("An error occurred while attempting to release audio source: 0x%x", audioSource.hashCode()));
            }
        }, (Executor)CameraXExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onEncoderSetupError(@Nullable Throwable cause) {
        RecordingRecord pendingRecordingToFinalize = null;
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mState) {
                case PENDING_PAUSED: 
                case PENDING_RECORDING: {
                    pendingRecordingToFinalize = this.mPendingRecordingRecord;
                    this.mPendingRecordingRecord = null;
                }
                case CONFIGURING: {
                    this.setStreamId(-1);
                    this.setState(State.ERROR);
                    break;
                }
                case ERROR: {
                    break;
                }
                case PAUSED: 
                case RECORDING: 
                case RESETTING: 
                case STOPPING: 
                case IDLING: {
                    throw new AssertionError((Object)("Encountered encoder setup error while in unexpected state " + (Object)((Object)this.mState) + ": " + cause));
                }
            }
        }
        if (pendingRecordingToFinalize != null) {
            this.finalizePendingRecording(pendingRecordingToFinalize, 7, cause);
        }
    }

    void setupAndStartMediaMuxer(@NonNull RecordingRecord recordingToStart) {
        if (this.mMediaMuxer != null) {
            throw new AssertionError((Object)"Unable to set up media muxer when one already exists.");
        }
        if (this.isAudioEnabled() && this.mPendingAudioRingBuffer.isEmpty()) {
            throw new AssertionError((Object)"Audio is enabled but no audio sample is ready. Cannot start media muxer.");
        }
        if (this.mPendingFirstVideoData == null) {
            throw new AssertionError((Object)"Media muxer cannot be started without an encoded video frame.");
        }
        try (EncodedData videoDataToWrite = this.mPendingFirstVideoData;){
            Location location;
            MediaMuxer mediaMuxer;
            this.mPendingFirstVideoData = null;
            List<EncodedData> audioDataToWrite = this.getAudioDataToWriteAndClearCache(videoDataToWrite.getPresentationTimeUs());
            long firstDataSize = videoDataToWrite.size();
            for (EncodedData data : audioDataToWrite) {
                firstDataSize += data.size();
            }
            if (this.mFileSizeLimitInBytes != 0L && firstDataSize > this.mFileSizeLimitInBytes) {
                Logger.d((String)TAG, (String)String.format("Initial data exceeds file size limit %d > %d", firstDataSize, this.mFileSizeLimitInBytes));
                this.onInProgressRecordingInternalError(recordingToStart, 2, null);
                return;
            }
            try {
                MediaSpec mediaSpec = this.getObservableData((StateObservable)this.mMediaSpec);
                int muxerOutputFormat = mediaSpec.getOutputFormat() == -1 ? Recorder.supportedMuxerFormatOrDefaultFrom(this.mResolvedEncoderProfiles, MediaSpec.outputFormatToMuxerFormat(MEDIA_SPEC_DEFAULT.getOutputFormat())) : MediaSpec.outputFormatToMuxerFormat(mediaSpec.getOutputFormat());
                mediaMuxer = recordingToStart.performOneTimeMediaMuxerCreation(muxerOutputFormat, (Consumer<Uri>)((Consumer)uri -> {
                    this.mOutputUri = uri;
                }));
            }
            catch (IOException e) {
                this.onInProgressRecordingInternalError(recordingToStart, 5, e);
                if (videoDataToWrite != null) {
                    videoDataToWrite.close();
                }
                return;
            }
            SurfaceRequest.TransformationInfo transformationInfo = this.mSourceTransformationInfo;
            if (transformationInfo != null) {
                this.setInProgressTransformationInfo(transformationInfo);
                mediaMuxer.setOrientationHint(transformationInfo.getRotationDegrees());
            }
            if ((location = recordingToStart.getOutputOptions().getLocation()) != null) {
                try {
                    Pair<Double, Double> geoLocation = CorrectNegativeLatLongForMediaMuxer.adjustGeoLocation(location.getLatitude(), location.getLongitude());
                    mediaMuxer.setLocation((float)((Double)geoLocation.first).doubleValue(), (float)((Double)geoLocation.second).doubleValue());
                }
                catch (IllegalArgumentException e) {
                    mediaMuxer.release();
                    this.onInProgressRecordingInternalError(recordingToStart, 5, e);
                    if (videoDataToWrite != null) {
                        videoDataToWrite.close();
                    }
                    return;
                }
            }
            this.mVideoTrackIndex = mediaMuxer.addTrack(this.mVideoOutputConfig.getMediaFormat());
            if (this.isAudioEnabled()) {
                this.mAudioTrackIndex = mediaMuxer.addTrack(this.mAudioOutputConfig.getMediaFormat());
            }
            mediaMuxer.start();
            this.mMediaMuxer = mediaMuxer;
            this.writeVideoData(videoDataToWrite, recordingToStart);
            for (EncodedData data : audioDataToWrite) {
                this.writeAudioData(data, recordingToStart);
            }
        }
    }

    @NonNull
    private List<EncodedData> getAudioDataToWriteAndClearCache(long firstVideoDataTimeUs) {
        ArrayList<EncodedData> res = new ArrayList<EncodedData>();
        while (!this.mPendingAudioRingBuffer.isEmpty()) {
            EncodedData data = (EncodedData)this.mPendingAudioRingBuffer.dequeue();
            if (data.getPresentationTimeUs() < firstVideoDataTimeUs) continue;
            res.add(data);
        }
        return res;
    }

    @SuppressLint(value={"MissingPermission"})
    private void startInternal(@NonNull RecordingRecord recordingToStart) {
        if (this.mInProgressRecording != null) {
            throw new AssertionError((Object)"Attempted to start a new recording while another was in progress.");
        }
        if (recordingToStart.getOutputOptions().getFileSizeLimit() > 0L) {
            this.mFileSizeLimitInBytes = Math.round((double)recordingToStart.getOutputOptions().getFileSizeLimit() * 0.95);
            Logger.d((String)TAG, (String)("File size limit in bytes: " + this.mFileSizeLimitInBytes));
        } else {
            this.mFileSizeLimitInBytes = 0L;
        }
        if (recordingToStart.getOutputOptions().getDurationLimitMillis() > 0L) {
            this.mDurationLimitNs = TimeUnit.MILLISECONDS.toNanos(recordingToStart.getOutputOptions().getDurationLimitMillis());
            Logger.d((String)TAG, (String)("Duration limit in nanoseconds: " + this.mDurationLimitNs));
        } else {
            this.mDurationLimitNs = 0L;
        }
        this.mInProgressRecording = recordingToStart;
        switch (this.mAudioState) {
            case ERROR_ENCODER: 
            case ERROR_SOURCE: 
            case ENABLED: 
            case DISABLED: {
                throw new AssertionError((Object)("Incorrectly invoke startInternal in audio state " + (Object)((Object)this.mAudioState)));
            }
            case IDLING: {
                this.setAudioState(recordingToStart.hasAudioEnabled() ? AudioState.ENABLED : AudioState.DISABLED);
                break;
            }
            case INITIALIZING: {
                if (!recordingToStart.hasAudioEnabled()) break;
                if (!this.isAudioSupported()) {
                    throw new AssertionError((Object)"The Recorder doesn't support recording with audio");
                }
                try {
                    if (!this.mInProgressRecording.isPersistent() || this.mAudioEncoder == null) {
                        this.setupAudio(recordingToStart);
                    }
                    this.setAudioState(AudioState.ENABLED);
                    break;
                }
                catch (AudioSourceAccessException | InvalidConfigException e) {
                    Logger.e((String)TAG, (String)"Unable to create audio resource with error: ", (Throwable)e);
                    AudioState audioState = e instanceof InvalidConfigException ? AudioState.ERROR_ENCODER : AudioState.ERROR_SOURCE;
                    this.setAudioState(audioState);
                    this.mAudioErrorCause = e;
                }
            }
        }
        this.updateEncoderCallbacks(recordingToStart, false);
        if (this.isAudioEnabled()) {
            this.mAudioSource.start(recordingToStart.isMuted());
            this.mAudioEncoder.start();
        }
        this.mVideoEncoder.start();
        this.mInProgressRecording.updateVideoRecordEvent(VideoRecordEvent.start(this.mInProgressRecording.getOutputOptions(), this.getInProgressRecordingStats()));
    }

    private void updateEncoderCallbacks(final @NonNull RecordingRecord recordingToStart, boolean videoOnly) {
        if (!this.mEncodingFutures.isEmpty()) {
            ListenableFuture listFuture = Futures.allAsList(this.mEncodingFutures);
            if (!listFuture.isDone()) {
                listFuture.cancel(true);
            }
            this.mEncodingFutures.clear();
        }
        this.mEncodingFutures.add((ListenableFuture<Void>)CallbackToFutureAdapter.getFuture(completer -> {
            this.mVideoEncoder.setEncoderCallback(new EncoderCallback(){

                @Override
                public void onEncodeStart() {
                }

                @Override
                public void onEncodeStop() {
                    completer.set(null);
                }

                @Override
                public void onEncodeError(@NonNull EncodeException e) {
                    completer.setException((Throwable)e);
                }

                @Override
                public void onEncodedData(@NonNull EncodedData encodedData) {
                    if (Recorder.this.mMediaMuxer == null) {
                        if (!Recorder.this.mInProgressRecordingStopping) {
                            boolean cachedDataDropped = false;
                            if (Recorder.this.mPendingFirstVideoData != null) {
                                cachedDataDropped = true;
                                Recorder.this.mPendingFirstVideoData.close();
                                Recorder.this.mPendingFirstVideoData = null;
                            }
                            if (encodedData.isKeyFrame()) {
                                Recorder.this.mPendingFirstVideoData = encodedData;
                                if (!Recorder.this.isAudioEnabled() || !Recorder.this.mPendingAudioRingBuffer.isEmpty()) {
                                    Logger.d((String)Recorder.TAG, (String)"Received video keyframe. Starting muxer...");
                                    Recorder.this.setupAndStartMediaMuxer(recordingToStart);
                                } else if (cachedDataDropped) {
                                    Logger.d((String)Recorder.TAG, (String)"Replaced cached video keyframe with newer keyframe.");
                                } else {
                                    Logger.d((String)Recorder.TAG, (String)"Cached video keyframe while we wait for first audio sample before starting muxer.");
                                }
                            } else {
                                if (cachedDataDropped) {
                                    Logger.d((String)Recorder.TAG, (String)"Dropped cached keyframe since we have new video data and have not yet received audio data.");
                                }
                                Logger.d((String)Recorder.TAG, (String)"Dropped video data since muxer has not yet started and data is not a keyframe.");
                                Recorder.this.mVideoEncoder.requestKeyFrame();
                                encodedData.close();
                            }
                        } else {
                            Logger.d((String)Recorder.TAG, (String)"Drop video data since recording is stopping.");
                            encodedData.close();
                        }
                    } else {
                        try (EncodedData videoDataToWrite = encodedData;){
                            Recorder.this.writeVideoData(videoDataToWrite, recordingToStart);
                        }
                    }
                }

                @Override
                public void onOutputConfigUpdate(@NonNull OutputConfig outputConfig) {
                    Recorder.this.mVideoOutputConfig = outputConfig;
                }
            }, this.mSequentialExecutor);
            return "videoEncodingFuture";
        }));
        if (this.isAudioEnabled() && !videoOnly) {
            this.mEncodingFutures.add((ListenableFuture<Void>)CallbackToFutureAdapter.getFuture(completer -> {
                final Consumer audioErrorConsumer = throwable -> {
                    if (this.mAudioErrorCause == null) {
                        if (throwable instanceof EncodeException) {
                            this.setAudioState(AudioState.ERROR_ENCODER);
                        } else {
                            this.setAudioState(AudioState.ERROR_SOURCE);
                        }
                        this.mAudioErrorCause = throwable;
                        this.updateInProgressStatusEvent();
                        completer.set(null);
                    }
                };
                this.mAudioSource.setAudioSourceCallback(this.mSequentialExecutor, new AudioSource.AudioSourceCallback(){

                    @Override
                    public void onSilenceStateChanged(boolean silenced) {
                        if (Recorder.this.mIsAudioSourceSilenced != silenced) {
                            Recorder.this.mIsAudioSourceSilenced = silenced;
                            Recorder.this.updateInProgressStatusEvent();
                        } else {
                            Logger.w((String)Recorder.TAG, (String)("Audio source silenced transitions to the same state " + silenced));
                        }
                    }

                    @Override
                    public void onError(@NonNull Throwable throwable) {
                        Logger.e((String)Recorder.TAG, (String)"Error occurred after audio source started.", (Throwable)throwable);
                        if (throwable instanceof AudioSourceAccessException) {
                            audioErrorConsumer.accept((Object)throwable);
                        }
                    }

                    @Override
                    public void onAmplitudeValue(double maxAmplitude) {
                        Recorder.this.mAudioAmplitude = maxAmplitude;
                    }
                });
                this.mAudioEncoder.setEncoderCallback(new EncoderCallback(){

                    @Override
                    public void onEncodeStart() {
                    }

                    @Override
                    public void onEncodeStop() {
                        completer.set(null);
                    }

                    @Override
                    public void onEncodeError(@NonNull EncodeException e) {
                        if (Recorder.this.mAudioErrorCause == null) {
                            audioErrorConsumer.accept((Object)e);
                        }
                    }

                    @Override
                    public void onEncodedData(@NonNull EncodedData encodedData) {
                        if (Recorder.this.mAudioState == AudioState.DISABLED) {
                            encodedData.close();
                            throw new AssertionError((Object)"Audio is not enabled but audio encoded data is being produced.");
                        }
                        if (Recorder.this.mMediaMuxer == null) {
                            if (!Recorder.this.mInProgressRecordingStopping) {
                                Recorder.this.mPendingAudioRingBuffer.enqueue((Object)new BufferCopiedEncodedData(encodedData));
                                if (Recorder.this.mPendingFirstVideoData != null) {
                                    Logger.d((String)Recorder.TAG, (String)"Received audio data. Starting muxer...");
                                    Recorder.this.setupAndStartMediaMuxer(recordingToStart);
                                } else {
                                    Logger.d((String)Recorder.TAG, (String)"Cached audio data while we wait for video keyframe before starting muxer.");
                                }
                            } else {
                                Logger.d((String)Recorder.TAG, (String)"Drop audio data since recording is stopping.");
                            }
                            encodedData.close();
                        } else {
                            try (EncodedData audioDataToWrite = encodedData;){
                                Recorder.this.writeAudioData(audioDataToWrite, recordingToStart);
                            }
                        }
                    }

                    @Override
                    public void onOutputConfigUpdate(@NonNull OutputConfig outputConfig) {
                        Recorder.this.mAudioOutputConfig = outputConfig;
                    }
                }, this.mSequentialExecutor);
                return "audioEncodingFuture";
            }));
        }
        Futures.addCallback((ListenableFuture)Futures.allAsList(this.mEncodingFutures), (FutureCallback)new FutureCallback<List<Void>>(){

            public void onSuccess(@Nullable List<Void> result) {
                Logger.d((String)Recorder.TAG, (String)"Encodings end successfully.");
                Recorder.this.finalizeInProgressRecording(Recorder.this.mRecordingStopError, Recorder.this.mRecordingStopErrorCause);
            }

            public void onFailure(@NonNull Throwable t) {
                Preconditions.checkState((Recorder.this.mInProgressRecording != null ? 1 : 0) != 0, (String)"In-progress recording shouldn't be null");
                if (!Recorder.this.mInProgressRecording.isPersistent()) {
                    Logger.d((String)Recorder.TAG, (String)("Encodings end with error: " + t));
                    Recorder.this.finalizeInProgressRecording(Recorder.this.mMediaMuxer == null ? 8 : 6, t);
                }
            }
        }, (Executor)CameraXExecutors.directExecutor());
    }

    void writeVideoData(@NonNull EncodedData encodedData, @NonNull RecordingRecord recording) {
        if (this.mVideoTrackIndex == null) {
            throw new AssertionError((Object)"Video data comes before the track is added to MediaMuxer.");
        }
        long newRecordingBytes = this.mRecordingBytes + encodedData.size();
        if (this.mFileSizeLimitInBytes != 0L && newRecordingBytes > this.mFileSizeLimitInBytes) {
            Logger.d((String)TAG, (String)String.format("Reach file size limit %d > %d", newRecordingBytes, this.mFileSizeLimitInBytes));
            this.onInProgressRecordingInternalError(recording, 2, null);
            return;
        }
        long newRecordingDurationNs = 0L;
        long currentPresentationTimeUs = encodedData.getPresentationTimeUs();
        if (this.mFirstRecordingVideoDataTimeUs == Long.MAX_VALUE) {
            this.mFirstRecordingVideoDataTimeUs = currentPresentationTimeUs;
            Logger.d((String)TAG, (String)String.format("First video time: %d (%s)", this.mFirstRecordingVideoDataTimeUs, DebugUtils.readableUs(this.mFirstRecordingVideoDataTimeUs)));
        } else {
            newRecordingDurationNs = TimeUnit.MICROSECONDS.toNanos(currentPresentationTimeUs - Math.min(this.mFirstRecordingVideoDataTimeUs, this.mFirstRecordingAudioDataTimeUs));
            Preconditions.checkState((this.mPreviousRecordingVideoDataTimeUs != Long.MAX_VALUE ? 1 : 0) != 0, (String)"There should be a previous data for adjusting the duration.");
            long adjustedDurationNs = newRecordingDurationNs + TimeUnit.MICROSECONDS.toNanos(currentPresentationTimeUs - this.mPreviousRecordingVideoDataTimeUs);
            if (this.mDurationLimitNs != 0L && adjustedDurationNs > this.mDurationLimitNs) {
                Logger.d((String)TAG, (String)String.format("Video data reaches duration limit %d > %d", adjustedDurationNs, this.mDurationLimitNs));
                this.onInProgressRecordingInternalError(recording, 9, null);
                return;
            }
        }
        this.mMediaMuxer.writeSampleData(this.mVideoTrackIndex.intValue(), encodedData.getByteBuffer(), encodedData.getBufferInfo());
        this.mRecordingBytes = newRecordingBytes;
        this.mRecordingDurationNs = newRecordingDurationNs;
        this.mPreviousRecordingVideoDataTimeUs = currentPresentationTimeUs;
        this.updateInProgressStatusEvent();
    }

    void writeAudioData(@NonNull EncodedData encodedData, @NonNull RecordingRecord recording) {
        long newRecordingBytes = this.mRecordingBytes + encodedData.size();
        if (this.mFileSizeLimitInBytes != 0L && newRecordingBytes > this.mFileSizeLimitInBytes) {
            Logger.d((String)TAG, (String)String.format("Reach file size limit %d > %d", newRecordingBytes, this.mFileSizeLimitInBytes));
            this.onInProgressRecordingInternalError(recording, 2, null);
            return;
        }
        long newRecordingDurationNs = 0L;
        long currentPresentationTimeUs = encodedData.getPresentationTimeUs();
        if (this.mFirstRecordingAudioDataTimeUs == Long.MAX_VALUE) {
            this.mFirstRecordingAudioDataTimeUs = currentPresentationTimeUs;
            Logger.d((String)TAG, (String)String.format("First audio time: %d (%s)", this.mFirstRecordingAudioDataTimeUs, DebugUtils.readableUs(this.mFirstRecordingAudioDataTimeUs)));
        } else {
            newRecordingDurationNs = TimeUnit.MICROSECONDS.toNanos(currentPresentationTimeUs - Math.min(this.mFirstRecordingVideoDataTimeUs, this.mFirstRecordingAudioDataTimeUs));
            Preconditions.checkState((this.mPreviousRecordingAudioDataTimeUs != Long.MAX_VALUE ? 1 : 0) != 0, (String)"There should be a previous data for adjusting the duration.");
            long adjustedDurationNs = newRecordingDurationNs + TimeUnit.MICROSECONDS.toNanos(currentPresentationTimeUs - this.mPreviousRecordingAudioDataTimeUs);
            if (this.mDurationLimitNs != 0L && adjustedDurationNs > this.mDurationLimitNs) {
                Logger.d((String)TAG, (String)String.format("Audio data reaches duration limit %d > %d", adjustedDurationNs, this.mDurationLimitNs));
                this.onInProgressRecordingInternalError(recording, 9, null);
                return;
            }
        }
        this.mMediaMuxer.writeSampleData(this.mAudioTrackIndex.intValue(), encodedData.getByteBuffer(), encodedData.getBufferInfo());
        this.mRecordingBytes = newRecordingBytes;
        this.mPreviousRecordingAudioDataTimeUs = currentPresentationTimeUs;
    }

    private void pauseInternal(@NonNull RecordingRecord recordingToPause) {
        if (this.mInProgressRecording == recordingToPause && !this.mInProgressRecordingStopping) {
            if (this.isAudioEnabled()) {
                this.mAudioEncoder.pause();
            }
            this.mVideoEncoder.pause();
            this.mInProgressRecording.updateVideoRecordEvent(VideoRecordEvent.pause(this.mInProgressRecording.getOutputOptions(), this.getInProgressRecordingStats()));
        }
    }

    private void resumeInternal(@NonNull RecordingRecord recordingToResume) {
        if (this.mInProgressRecording == recordingToResume && !this.mInProgressRecordingStopping) {
            if (this.isAudioEnabled()) {
                this.mAudioEncoder.start();
            }
            if (this.mVideoEncoder != null) {
                this.mVideoEncoder.start();
                this.mInProgressRecording.updateVideoRecordEvent(VideoRecordEvent.resume(this.mInProgressRecording.getOutputOptions(), this.getInProgressRecordingStats()));
            } else {
                this.mShouldSendResumeEvent = true;
            }
        }
    }

    void stopInternal(@NonNull RecordingRecord recordingToStop, long explicitlyStopTime, int stopError, @Nullable Throwable errorCause) {
        if (this.mInProgressRecording == recordingToStop && !this.mInProgressRecordingStopping) {
            this.mInProgressRecordingStopping = true;
            this.mRecordingStopError = stopError;
            this.mRecordingStopErrorCause = errorCause;
            if (this.isAudioEnabled()) {
                this.clearPendingAudioRingBuffer();
                this.mAudioEncoder.stop(explicitlyStopTime);
            }
            if (this.mPendingFirstVideoData != null) {
                this.mPendingFirstVideoData.close();
                this.mPendingFirstVideoData = null;
            }
            if (this.mSourceState != VideoOutput.SourceState.ACTIVE_NON_STREAMING) {
                Encoder finalVideoEncoder = this.mVideoEncoder;
                this.mSourceNonStreamingTimeout = CameraXExecutors.mainThreadExecutor().schedule(() -> this.mSequentialExecutor.execute(() -> {
                    Logger.d((String)TAG, (String)"The source didn't become non-streaming before timeout. Waited 1000ms");
                    if (DeviceQuirks.get(DeactivateEncoderSurfaceBeforeStopEncoderQuirk.class) != null) {
                        Recorder.notifyEncoderSourceStopped(finalVideoEncoder);
                    }
                }), 1000L, TimeUnit.MILLISECONDS);
            } else {
                Recorder.notifyEncoderSourceStopped(this.mVideoEncoder);
            }
            this.mVideoEncoder.stop(explicitlyStopTime);
        }
    }

    private void muteInternal(@NonNull RecordingRecord recordingToMute, boolean muted) {
        if (recordingToMute.isMuted() == muted) {
            return;
        }
        recordingToMute.mute(muted);
        if (this.mInProgressRecording == recordingToMute && !this.mInProgressRecordingStopping && this.mAudioSource != null) {
            this.mAudioSource.mute(muted);
        }
    }

    static void notifyEncoderSourceStopped(@NonNull Encoder encoder) {
        if (encoder instanceof EncoderImpl) {
            ((EncoderImpl)encoder).signalSourceStopped();
        }
    }

    private void clearPendingAudioRingBuffer() {
        while (!this.mPendingAudioRingBuffer.isEmpty()) {
            this.mPendingAudioRingBuffer.dequeue();
        }
    }

    private void reset() {
        if (this.mAudioEncoder != null) {
            Logger.d((String)TAG, (String)"Releasing audio encoder.");
            this.mAudioEncoder.release();
            this.mAudioEncoder = null;
            this.mAudioOutputConfig = null;
        }
        if (this.mAudioSource != null) {
            this.releaseCurrentAudioSource();
        }
        this.setAudioState(AudioState.INITIALIZING);
        this.resetVideo();
    }

    private void tryReleaseVideoEncoder() {
        if (this.mVideoEncoderSessionToRelease != null) {
            Preconditions.checkState((this.mVideoEncoderSessionToRelease.getVideoEncoder() == this.mVideoEncoder ? 1 : 0) != 0);
            Logger.d((String)TAG, (String)("Releasing video encoder: " + this.mVideoEncoder));
            this.mVideoEncoderSessionToRelease.terminateNow();
            this.mVideoEncoderSessionToRelease = null;
            this.mVideoEncoder = null;
            this.mVideoOutputConfig = null;
            this.setLatestSurface(null);
        } else {
            this.safeToCloseVideoEncoder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResetVideo() {
        boolean shouldConfigure = true;
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mState) {
                case PENDING_PAUSED: 
                case PENDING_RECORDING: {
                    this.updateNonPendingState(State.CONFIGURING);
                    break;
                }
                case PAUSED: 
                case RECORDING: 
                case ERROR: {
                    if (this.isPersistentRecordingInProgress()) {
                        shouldConfigure = false;
                        break;
                    }
                }
                case RESETTING: 
                case STOPPING: 
                case IDLING: {
                    this.setState(State.CONFIGURING);
                    break;
                }
            }
        }
        this.mNeedsResetBeforeNextStart = false;
        if (shouldConfigure && this.mLatestSurfaceRequest != null && !this.mLatestSurfaceRequest.isServiced()) {
            this.configureInternal(this.mLatestSurfaceRequest, this.mVideoSourceTimebase);
        }
    }

    private void resetVideo() {
        if (this.mVideoEncoder != null) {
            Logger.d((String)TAG, (String)"Releasing video encoder.");
            this.tryReleaseVideoEncoder();
        }
        this.onResetVideo();
    }

    private int internalAudioStateToAudioStatsState(@NonNull AudioState audioState) {
        switch (audioState) {
            case DISABLED: 
            case INITIALIZING: {
                return 1;
            }
            case ENABLED: {
                if (this.mInProgressRecording != null && this.mInProgressRecording.isMuted()) {
                    return 5;
                }
                if (this.mIsAudioSourceSilenced) {
                    return 2;
                }
                return 0;
            }
            case ERROR_ENCODER: {
                return 3;
            }
            case ERROR_SOURCE: {
                return 4;
            }
        }
        throw new AssertionError((Object)("Invalid internal audio state: " + (Object)((Object)audioState)));
    }

    @NonNull
    private StreamInfo.StreamState internalStateToStreamState(@NonNull State state) {
        DeactivateEncoderSurfaceBeforeStopEncoderQuirk quirk = DeviceQuirks.get(DeactivateEncoderSurfaceBeforeStopEncoderQuirk.class);
        return state == State.RECORDING || state == State.STOPPING && quirk == null ? StreamInfo.StreamState.ACTIVE : StreamInfo.StreamState.INACTIVE;
    }

    boolean isAudioEnabled() {
        return this.mAudioState == AudioState.ENABLED;
    }

    void finalizeInProgressRecording(int error, @Nullable Throwable throwable) {
        if (this.mInProgressRecording == null) {
            throw new AssertionError((Object)"Attempted to finalize in-progress recording, but no recording is in progress.");
        }
        int errorToSend = error;
        if (this.mMediaMuxer != null) {
            block12: {
                try {
                    this.mMediaMuxer.stop();
                    this.mMediaMuxer.release();
                }
                catch (IllegalStateException e) {
                    Logger.e((String)TAG, (String)("MediaMuxer failed to stop or release with error: " + e.getMessage()));
                    if (errorToSend != 0) break block12;
                    errorToSend = 1;
                }
            }
            this.mMediaMuxer = null;
        } else if (errorToSend == 0) {
            errorToSend = 8;
        }
        this.mInProgressRecording.finalizeRecording(this.mOutputUri);
        OutputOptions outputOptions = this.mInProgressRecording.getOutputOptions();
        RecordingStats stats = this.getInProgressRecordingStats();
        OutputResults outputResults = OutputResults.of(this.mOutputUri);
        this.mInProgressRecording.updateVideoRecordEvent(errorToSend == 0 ? VideoRecordEvent.finalize(outputOptions, stats, outputResults) : VideoRecordEvent.finalizeWithError(outputOptions, stats, outputResults, errorToSend, throwable));
        RecordingRecord finalizedRecording = this.mInProgressRecording;
        this.mInProgressRecording = null;
        this.mInProgressRecordingStopping = false;
        this.mAudioTrackIndex = null;
        this.mVideoTrackIndex = null;
        this.mEncodingFutures.clear();
        this.mOutputUri = Uri.EMPTY;
        this.mRecordingBytes = 0L;
        this.mRecordingDurationNs = 0L;
        this.mFirstRecordingVideoDataTimeUs = Long.MAX_VALUE;
        this.mFirstRecordingAudioDataTimeUs = Long.MAX_VALUE;
        this.mPreviousRecordingVideoDataTimeUs = Long.MAX_VALUE;
        this.mPreviousRecordingAudioDataTimeUs = Long.MAX_VALUE;
        this.mRecordingStopError = 1;
        this.mRecordingStopErrorCause = null;
        this.mAudioErrorCause = null;
        this.mAudioAmplitude = 0.0;
        this.clearPendingAudioRingBuffer();
        this.setInProgressTransformationInfo(null);
        switch (this.mAudioState) {
            case IDLING: {
                throw new AssertionError((Object)"Incorrectly finalize recording when audio state is IDLING");
            }
            case INITIALIZING: {
                break;
            }
            case ENABLED: 
            case DISABLED: {
                this.setAudioState(AudioState.IDLING);
                this.mAudioSource.stop();
                break;
            }
            case ERROR_ENCODER: 
            case ERROR_SOURCE: {
                this.setAudioState(AudioState.INITIALIZING);
            }
        }
        this.onRecordingFinalized(finalizedRecording);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRecordingFinalized(@NonNull RecordingRecord finalizedRecording) {
        boolean needsReset = false;
        boolean startRecordingPaused = false;
        boolean needsConfigure = false;
        RecordingRecord recordingToStart = null;
        RecordingRecord pendingRecordingToFinalize = null;
        int error = 0;
        Exception errorCause = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mActiveRecordingRecord != finalizedRecording) {
                throw new AssertionError((Object)"Active recording did not match finalized recording on finalize.");
            }
            this.mActiveRecordingRecord = null;
            switch (this.mState) {
                case RESETTING: {
                    needsReset = true;
                    break;
                }
                case PAUSED: 
                case RECORDING: 
                case STOPPING: {
                    if (this.mEncoderNotUsePersistentInputSurface) {
                        this.mActiveSurface = null;
                        if (this.mLatestSurfaceRequest != null && !this.mLatestSurfaceRequest.isServiced()) {
                            needsConfigure = true;
                        }
                        this.setState(State.CONFIGURING);
                        break;
                    }
                    this.setState(State.IDLING);
                    break;
                }
                case PENDING_PAUSED: {
                    startRecordingPaused = true;
                }
                case PENDING_RECORDING: {
                    if (this.mSourceState == VideoOutput.SourceState.INACTIVE) {
                        pendingRecordingToFinalize = this.mPendingRecordingRecord;
                        this.mPendingRecordingRecord = null;
                        this.setState(State.CONFIGURING);
                        error = 4;
                        errorCause = PENDING_RECORDING_ERROR_CAUSE_SOURCE_INACTIVE;
                        break;
                    }
                    if (this.mEncoderNotUsePersistentInputSurface) {
                        this.mActiveSurface = null;
                        if (this.mLatestSurfaceRequest != null && !this.mLatestSurfaceRequest.isServiced()) {
                            needsConfigure = true;
                        }
                        this.updateNonPendingState(State.CONFIGURING);
                        break;
                    }
                    if (this.mVideoEncoder == null) break;
                    recordingToStart = this.makePendingRecordingActiveLocked(this.mState);
                    break;
                }
                case ERROR: {
                    break;
                }
                case CONFIGURING: {
                    break;
                }
                case IDLING: {
                    throw new AssertionError((Object)("Unexpected state on finalize of recording: " + (Object)((Object)this.mState)));
                }
            }
        }
        if (needsConfigure) {
            this.configureInternal(this.mLatestSurfaceRequest, this.mVideoSourceTimebase);
        } else if (needsReset) {
            this.reset();
        } else if (recordingToStart != null) {
            if (this.mEncoderNotUsePersistentInputSurface) {
                throw new AssertionError((Object)"Attempt to start a pending recording while the Recorder is waiting for a new surface request.");
            }
            this.startRecording(recordingToStart, startRecordingPaused);
        } else if (pendingRecordingToFinalize != null) {
            this.finalizePendingRecording(pendingRecordingToFinalize, error, errorCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onInProgressRecordingInternalError(@NonNull RecordingRecord recording, int error, @Nullable Throwable cause) {
        if (recording != this.mInProgressRecording) {
            throw new AssertionError((Object)"Internal error occurred on recording that is not the current in-progress recording.");
        }
        boolean needsStop = false;
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mState) {
                case PAUSED: 
                case RECORDING: {
                    this.setState(State.STOPPING);
                    needsStop = true;
                }
                case PENDING_PAUSED: 
                case PENDING_RECORDING: 
                case RESETTING: 
                case STOPPING: {
                    if (recording != this.mActiveRecordingRecord) {
                        throw new AssertionError((Object)"Internal error occurred for recording but it is not the active recording.");
                    }
                    break;
                }
                case CONFIGURING: 
                case ERROR: 
                case IDLING: {
                    throw new AssertionError((Object)("In-progress recording error occurred while in unexpected state: " + (Object)((Object)this.mState)));
                }
            }
        }
        if (needsStop) {
            this.stopInternal(recording, -1L, error, cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryServicePendingRecording() {
        boolean startRecordingPaused = false;
        RecordingRecord recordingToStart = null;
        RecordingRecord pendingRecordingToFinalize = null;
        int error = 0;
        Exception errorCause = null;
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mState) {
                case PENDING_PAUSED: {
                    startRecordingPaused = true;
                }
                case PENDING_RECORDING: {
                    if (this.mActiveRecordingRecord != null || this.mNeedsResetBeforeNextStart) break;
                    if (this.mSourceState == VideoOutput.SourceState.INACTIVE) {
                        pendingRecordingToFinalize = this.mPendingRecordingRecord;
                        this.mPendingRecordingRecord = null;
                        this.restoreNonPendingState();
                        error = 4;
                        errorCause = PENDING_RECORDING_ERROR_CAUSE_SOURCE_INACTIVE;
                        break;
                    }
                    if (this.mVideoEncoder == null) break;
                    recordingToStart = this.makePendingRecordingActiveLocked(this.mState);
                    break;
                }
            }
        }
        if (recordingToStart != null) {
            this.startRecording(recordingToStart, startRecordingPaused);
        } else if (pendingRecordingToFinalize != null) {
            this.finalizePendingRecording(pendingRecordingToFinalize, error, errorCause);
        }
    }

    @GuardedBy(value="mLock")
    @NonNull
    private RecordingRecord makePendingRecordingActiveLocked(@NonNull State state) {
        boolean startRecordingPaused = false;
        if (state == State.PENDING_PAUSED) {
            startRecordingPaused = true;
        } else if (state != State.PENDING_RECORDING) {
            throw new AssertionError((Object)"makePendingRecordingActiveLocked() can only be called from a pending state.");
        }
        if (this.mActiveRecordingRecord != null) {
            throw new AssertionError((Object)"Cannot make pending recording active because another recording is already active.");
        }
        if (this.mPendingRecordingRecord == null) {
            throw new AssertionError((Object)"Pending recording should exist when in a PENDING state.");
        }
        RecordingRecord recordingToStart = this.mActiveRecordingRecord = this.mPendingRecordingRecord;
        this.mPendingRecordingRecord = null;
        if (startRecordingPaused) {
            this.setState(State.PAUSED);
        } else {
            this.setState(State.RECORDING);
        }
        return recordingToStart;
    }

    private void startRecording(@NonNull RecordingRecord recordingToStart, boolean startRecordingPaused) {
        this.startInternal(recordingToStart);
        if (startRecordingPaused) {
            this.pauseInternal(recordingToStart);
        }
    }

    void updateInProgressStatusEvent() {
        if (this.mInProgressRecording != null) {
            this.mInProgressRecording.updateVideoRecordEvent(VideoRecordEvent.status(this.mInProgressRecording.getOutputOptions(), this.getInProgressRecordingStats()));
        }
    }

    @NonNull
    RecordingStats getInProgressRecordingStats() {
        return RecordingStats.of(this.mRecordingDurationNs, this.mRecordingBytes, AudioStats.of(this.internalAudioStateToAudioStatsState(this.mAudioState), this.mAudioErrorCause, this.mAudioAmplitude));
    }

    <T> T getObservableData(@NonNull StateObservable<T> observable) {
        ListenableFuture future = observable.fetchData();
        try {
            return (T)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    boolean isAudioSupported() {
        return this.getObservableData((StateObservable)this.mMediaSpec).getAudioSpec().getChannelCount() != 0;
    }

    @GuardedBy(value="mLock")
    void setState(@NonNull State state) {
        if (this.mState == state) {
            throw new AssertionError((Object)("Attempted to transition to state " + (Object)((Object)state) + ", but Recorder is already in state " + (Object)((Object)state)));
        }
        Logger.d((String)TAG, (String)("Transitioning Recorder internal state: " + (Object)((Object)this.mState) + " --> " + (Object)((Object)state)));
        StreamInfo.StreamState streamState = null;
        if (PENDING_STATES.contains((Object)state)) {
            if (!PENDING_STATES.contains((Object)this.mState)) {
                if (!VALID_NON_PENDING_STATES_WHILE_PENDING.contains((Object)this.mState)) {
                    throw new AssertionError((Object)("Invalid state transition. Should not be transitioning to a PENDING state from state " + (Object)((Object)this.mState)));
                }
                this.mNonPendingState = this.mState;
                streamState = this.internalStateToStreamState(this.mNonPendingState);
            }
        } else if (this.mNonPendingState != null) {
            this.mNonPendingState = null;
        }
        this.mState = state;
        if (streamState == null) {
            streamState = this.internalStateToStreamState(this.mState);
        }
        this.mStreamInfo.setState((Object)StreamInfo.of(this.mStreamId, streamState, this.mInProgressTransformationInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLatestSurface(@Nullable Surface surface) {
        if (this.mLatestSurface == surface) {
            return;
        }
        this.mLatestSurface = surface;
        Object object = this.mLock;
        synchronized (object) {
            this.setStreamId(surface != null ? surface.hashCode() : 0);
        }
    }

    @GuardedBy(value="mLock")
    private void setStreamId(int streamId) {
        if (this.mStreamId == streamId) {
            return;
        }
        Logger.d((String)TAG, (String)("Transitioning streamId: " + this.mStreamId + " --> " + streamId));
        this.mStreamId = streamId;
        this.mStreamInfo.setState((Object)StreamInfo.of(streamId, this.internalStateToStreamState(this.mState), this.mInProgressTransformationInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInProgressTransformationInfo(@Nullable SurfaceRequest.TransformationInfo transformationInfo) {
        Logger.d((String)TAG, (String)("Update stream transformation info: " + transformationInfo));
        this.mInProgressTransformationInfo = transformationInfo;
        Object object = this.mLock;
        synchronized (object) {
            this.mStreamInfo.setState((Object)StreamInfo.of(this.mStreamId, this.internalStateToStreamState(this.mState), transformationInfo));
        }
    }

    @GuardedBy(value="mLock")
    private void updateNonPendingState(@NonNull State state) {
        if (!PENDING_STATES.contains((Object)this.mState)) {
            throw new AssertionError((Object)("Can only updated non-pending state from a pending state, but state is " + (Object)((Object)this.mState)));
        }
        if (!VALID_NON_PENDING_STATES_WHILE_PENDING.contains((Object)state)) {
            throw new AssertionError((Object)("Invalid state transition. State is not a valid non-pending state while in a pending state: " + (Object)((Object)state)));
        }
        if (this.mNonPendingState != state) {
            this.mNonPendingState = state;
            this.mStreamInfo.setState((Object)StreamInfo.of(this.mStreamId, this.internalStateToStreamState(state), this.mInProgressTransformationInfo));
        }
    }

    @GuardedBy(value="mLock")
    private void restoreNonPendingState() {
        if (!PENDING_STATES.contains((Object)this.mState)) {
            throw new AssertionError((Object)("Cannot restore non-pending state when in state " + (Object)((Object)this.mState)));
        }
        this.setState(this.mNonPendingState);
    }

    void setAudioState(@NonNull AudioState audioState) {
        Logger.d((String)TAG, (String)("Transitioning audio state: " + (Object)((Object)this.mAudioState) + " --> " + (Object)((Object)audioState)));
        this.mAudioState = audioState;
    }

    private static int supportedMuxerFormatOrDefaultFrom(@Nullable VideoValidatedEncoderProfilesProxy profilesProxy, int defaultMuxerFormat) {
        if (profilesProxy != null) {
            switch (profilesProxy.getRecommendedFileFormat()) {
                case 2: {
                    return 0;
                }
                case 9: {
                    return 1;
                }
                case 1: {
                    if (Build.VERSION.SDK_INT < 26) {
                        return 0;
                    }
                    return 2;
                }
            }
        }
        return defaultMuxerFormat;
    }

    @NonNull
    public static VideoCapabilities getVideoCapabilities(@NonNull CameraInfo cameraInfo) {
        return Recorder.getVideoCapabilities(cameraInfo, 0);
    }

    @NonNull
    public static VideoCapabilities getVideoCapabilities(@NonNull CameraInfo cameraInfo, int videoCapabilitiesSource) {
        return new RecorderVideoCapabilities(videoCapabilitiesSource, (CameraInfoInternal)cameraInfo, VideoEncoderInfoImpl.FINDER);
    }

    static enum State {
        CONFIGURING,
        PENDING_RECORDING,
        PENDING_PAUSED,
        IDLING,
        RECORDING,
        PAUSED,
        STOPPING,
        RESETTING,
        ERROR;

    }

    @RequiresApi(value=21)
    @AutoValue
    static abstract class RecordingRecord
    implements AutoCloseable {
        private final CloseGuardHelper mCloseGuard = CloseGuardHelper.create();
        private final AtomicBoolean mInitialized = new AtomicBoolean(false);
        private final AtomicReference<MediaMuxerSupplier> mMediaMuxerSupplier = new AtomicReference<Object>(null);
        private final AtomicReference<AudioSourceSupplier> mAudioSourceSupplier = new AtomicReference<Object>(null);
        private final AtomicReference<Consumer<Uri>> mRecordingFinalizer = new AtomicReference<Consumer>(ignored -> {});
        private final AtomicBoolean mMuted = new AtomicBoolean(false);

        RecordingRecord() {
        }

        @NonNull
        static RecordingRecord from(@NonNull PendingRecording pendingRecording, long recordingId) {
            return new AutoValue_Recorder_RecordingRecord(pendingRecording.getOutputOptions(), pendingRecording.getListenerExecutor(), pendingRecording.getEventListener(), pendingRecording.isAudioEnabled(), pendingRecording.isPersistent(), recordingId);
        }

        @NonNull
        abstract OutputOptions getOutputOptions();

        @Nullable
        abstract Executor getCallbackExecutor();

        @Nullable
        abstract Consumer<VideoRecordEvent> getEventListener();

        abstract boolean hasAudioEnabled();

        abstract boolean isPersistent();

        abstract long getRecordingId();

        void initializeRecording(final @NonNull Context context) throws IOException {
            if (this.mInitialized.getAndSet(true)) {
                throw new AssertionError((Object)("Recording " + this + " has already been initialized"));
            }
            OutputOptions outputOptions = this.getOutputOptions();
            ParcelFileDescriptor dupedParcelFileDescriptor = outputOptions instanceof FileDescriptorOutputOptions ? ((FileDescriptorOutputOptions)outputOptions).getParcelFileDescriptor().dup() : null;
            this.mCloseGuard.open("finalizeRecording");
            MediaMuxerSupplier mediaMuxerSupplier = (muxerOutputFormat, outputUriCreatedCallback) -> {
                MediaMuxer mediaMuxer;
                Uri outputUri = Uri.EMPTY;
                if (outputOptions instanceof FileOutputOptions) {
                    FileOutputOptions fileOutputOptions = (FileOutputOptions)outputOptions;
                    File file = fileOutputOptions.getFile();
                    if (!OutputUtil.createParentFolder(file)) {
                        Logger.w((String)Recorder.TAG, (String)("Failed to create folder for " + file.getAbsolutePath()));
                    }
                    mediaMuxer = new MediaMuxer(file.getAbsolutePath(), muxerOutputFormat);
                    outputUri = Uri.fromFile((File)file);
                } else if (outputOptions instanceof FileDescriptorOutputOptions) {
                    if (Build.VERSION.SDK_INT < 26) throw new IOException("MediaMuxer doesn't accept FileDescriptor as output destination.");
                    mediaMuxer = Api26Impl.createMediaMuxer(dupedParcelFileDescriptor.getFileDescriptor(), muxerOutputFormat);
                } else {
                    if (!(outputOptions instanceof MediaStoreOutputOptions)) throw new AssertionError((Object)("Invalid output options type: " + outputOptions.getClass().getSimpleName()));
                    MediaStoreOutputOptions mediaStoreOutputOptions = (MediaStoreOutputOptions)outputOptions;
                    ContentValues contentValues = new ContentValues(mediaStoreOutputOptions.getContentValues());
                    if (Build.VERSION.SDK_INT >= 29) {
                        contentValues.put("is_pending", Integer.valueOf(1));
                    }
                    try {
                        outputUri = mediaStoreOutputOptions.getContentResolver().insert(mediaStoreOutputOptions.getCollectionUri(), contentValues);
                    }
                    catch (RuntimeException e) {
                        throw new IOException("Unable to create MediaStore entry by " + e, e);
                    }
                    if (outputUri == null) {
                        throw new IOException("Unable to create MediaStore entry.");
                    }
                    if (Build.VERSION.SDK_INT < 26) {
                        String path = OutputUtil.getAbsolutePathFromUri(mediaStoreOutputOptions.getContentResolver(), outputUri, Recorder.MEDIA_COLUMN);
                        if (path == null) {
                            throw new IOException("Unable to get path from uri " + outputUri);
                        }
                        if (!OutputUtil.createParentFolder(new File(path))) {
                            Logger.w((String)Recorder.TAG, (String)("Failed to create folder for " + path));
                        }
                        mediaMuxer = new MediaMuxer(path, muxerOutputFormat);
                    } else {
                        ParcelFileDescriptor fileDescriptor = mediaStoreOutputOptions.getContentResolver().openFileDescriptor(outputUri, "rw");
                        mediaMuxer = Api26Impl.createMediaMuxer(fileDescriptor.getFileDescriptor(), muxerOutputFormat);
                        fileDescriptor.close();
                    }
                }
                outputUriCreatedCallback.accept((Object)outputUri);
                return mediaMuxer;
            };
            this.mMediaMuxerSupplier.set(mediaMuxerSupplier);
            Consumer recordingFinalizer = null;
            if (this.hasAudioEnabled()) {
                AudioSourceSupplier audioSourceSupplier;
                if (Build.VERSION.SDK_INT >= 31) {
                    audioSourceSupplier = new AudioSourceSupplier(){

                        @Override
                        @NonNull
                        @RequiresPermission(value="android.permission.RECORD_AUDIO")
                        public AudioSource get(@NonNull AudioSettings settings, @NonNull Executor executor) throws AudioSourceAccessException {
                            return new AudioSource(settings, executor, context);
                        }
                    };
                    this.mAudioSourceSupplier.set(audioSourceSupplier);
                } else {
                    audioSourceSupplier = new AudioSourceSupplier(){

                        @Override
                        @NonNull
                        @RequiresPermission(value="android.permission.RECORD_AUDIO")
                        public AudioSource get(@NonNull AudioSettings settings, @NonNull Executor executor) throws AudioSourceAccessException {
                            return new AudioSource(settings, executor, null);
                        }
                    };
                    this.mAudioSourceSupplier.set(audioSourceSupplier);
                }
            }
            if (outputOptions instanceof MediaStoreOutputOptions) {
                MediaStoreOutputOptions mediaStoreOutputOptions = (MediaStoreOutputOptions)outputOptions;
                recordingFinalizer = Build.VERSION.SDK_INT >= 29 ? outputUri -> {
                    if (outputUri.equals((Object)Uri.EMPTY)) {
                        return;
                    }
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("is_pending", Integer.valueOf(0));
                    mediaStoreOutputOptions.getContentResolver().update(outputUri, contentValues, null, null);
                } : outputUri -> {
                    if (outputUri.equals((Object)Uri.EMPTY)) {
                        return;
                    }
                    String filePath = OutputUtil.getAbsolutePathFromUri(mediaStoreOutputOptions.getContentResolver(), outputUri, Recorder.MEDIA_COLUMN);
                    if (filePath != null) {
                        MediaScannerConnection.scanFile((Context)context, (String[])new String[]{filePath}, null, (path, uri) -> {
                            if (uri == null) {
                                Logger.e((String)Recorder.TAG, (String)String.format("File scanning operation failed [path: %s]", path));
                            } else {
                                Logger.d((String)Recorder.TAG, (String)String.format("File scan completed successfully [path: %s, URI: %s]", path, uri));
                            }
                        });
                    } else {
                        Logger.d((String)Recorder.TAG, (String)("Skipping media scanner scan. Unable to retrieve file path from URI: " + outputUri));
                    }
                };
            } else if (outputOptions instanceof FileDescriptorOutputOptions) {
                recordingFinalizer = ignored -> {
                    try {
                        dupedParcelFileDescriptor.close();
                    }
                    catch (IOException e) {
                        Logger.e((String)Recorder.TAG, (String)"Failed to close dup'd ParcelFileDescriptor", (Throwable)e);
                    }
                };
            }
            if (recordingFinalizer != null) {
                this.mRecordingFinalizer.set((Consumer<Uri>)recordingFinalizer);
            }
        }

        void updateVideoRecordEvent(@NonNull VideoRecordEvent event) {
            VideoRecordEvent.Finalize finalizeEvent;
            if (!Objects.equals(event.getOutputOptions(), this.getOutputOptions())) {
                throw new AssertionError((Object)("Attempted to update event listener with event from incorrect recording [Recording: " + event.getOutputOptions() + ", Expected: " + this.getOutputOptions() + "]"));
            }
            String message = "Sending VideoRecordEvent " + event.getClass().getSimpleName();
            if (event instanceof VideoRecordEvent.Finalize && (finalizeEvent = (VideoRecordEvent.Finalize)event).hasError()) {
                message = message + String.format(" [error: %s]", VideoRecordEvent.Finalize.errorToString(finalizeEvent.getError()));
            }
            Logger.d((String)Recorder.TAG, (String)message);
            if (this.getCallbackExecutor() != null && this.getEventListener() != null) {
                try {
                    this.getCallbackExecutor().execute(() -> this.getEventListener().accept((Object)event));
                }
                catch (RejectedExecutionException e) {
                    Logger.e((String)Recorder.TAG, (String)"The callback executor is invalid.", (Throwable)e);
                }
            }
        }

        @NonNull
        @RequiresPermission(value="android.permission.RECORD_AUDIO")
        AudioSource performOneTimeAudioSourceCreation(@NonNull AudioSettings settings, @NonNull Executor audioSourceExecutor) throws AudioSourceAccessException {
            if (!this.hasAudioEnabled()) {
                throw new AssertionError((Object)("Recording does not have audio enabled. Unable to create audio source for recording " + this));
            }
            AudioSourceSupplier audioSourceSupplier = this.mAudioSourceSupplier.getAndSet(null);
            if (audioSourceSupplier == null) {
                throw new AssertionError((Object)("One-time audio source creation has already occurred for recording " + this));
            }
            return audioSourceSupplier.get(settings, audioSourceExecutor);
        }

        @NonNull
        MediaMuxer performOneTimeMediaMuxerCreation(int muxerOutputFormat, @NonNull Consumer<Uri> outputUriCreatedCallback) throws IOException {
            if (!this.mInitialized.get()) {
                throw new AssertionError((Object)("Recording " + this + " has not been initialized"));
            }
            MediaMuxerSupplier mediaMuxerSupplier = this.mMediaMuxerSupplier.getAndSet(null);
            if (mediaMuxerSupplier == null) {
                throw new AssertionError((Object)("One-time media muxer creation has already occurred for recording " + this));
            }
            try {
                return mediaMuxerSupplier.get(muxerOutputFormat, outputUriCreatedCallback);
            }
            catch (RuntimeException e) {
                throw new IOException("Failed to create MediaMuxer by " + e, e);
            }
        }

        void finalizeRecording(@NonNull Uri uri) {
            if (!this.mInitialized.get()) {
                return;
            }
            this.finalizeRecordingInternal((Consumer<Uri>)((Consumer)this.mRecordingFinalizer.getAndSet(null)), uri);
        }

        void mute(boolean muted) {
            this.mMuted.set(muted);
        }

        boolean isMuted() {
            return this.mMuted.get();
        }

        @Override
        public void close() {
            this.finalizeRecording(Uri.EMPTY);
        }

        protected void finalize() throws Throwable {
            try {
                this.mCloseGuard.warnIfOpen();
                Consumer finalizer = this.mRecordingFinalizer.getAndSet(null);
                if (finalizer != null) {
                    this.finalizeRecordingInternal((Consumer<Uri>)finalizer, Uri.EMPTY);
                }
            }
            finally {
                super.finalize();
            }
        }

        private void finalizeRecordingInternal(@Nullable Consumer<Uri> finalizer, @NonNull Uri uri) {
            if (finalizer == null) {
                throw new AssertionError((Object)("Recording " + this + " has already been finalized"));
            }
            this.mCloseGuard.close();
            finalizer.accept((Object)uri);
        }

        private static interface MediaMuxerSupplier {
            @NonNull
            public MediaMuxer get(int var1, @NonNull Consumer<Uri> var2) throws IOException;
        }

        private static interface AudioSourceSupplier {
            @RequiresPermission(value="android.permission.RECORD_AUDIO")
            @NonNull
            public AudioSource get(@NonNull AudioSettings var1, @NonNull Executor var2) throws AudioSourceAccessException;
        }
    }

    static enum AudioState {
        INITIALIZING,
        IDLING,
        DISABLED,
        ENABLED,
        ERROR_ENCODER,
        ERROR_SOURCE;

    }

    @RequiresApi(value=21)
    public static final class Builder {
        private final MediaSpec.Builder mMediaSpecBuilder;
        private int mVideoCapabilitiesSource = 0;
        private Executor mExecutor = null;
        private EncoderFactory mVideoEncoderFactory = DEFAULT_ENCODER_FACTORY;
        private EncoderFactory mAudioEncoderFactory = DEFAULT_ENCODER_FACTORY;

        public Builder() {
            this.mMediaSpecBuilder = MediaSpec.builder();
        }

        @NonNull
        public Builder setExecutor(@NonNull Executor executor) {
            Preconditions.checkNotNull((Object)executor, (Object)"The specified executor can't be null.");
            this.mExecutor = executor;
            return this;
        }

        @NonNull
        public Builder setQualitySelector(@NonNull QualitySelector qualitySelector) {
            Preconditions.checkNotNull((Object)qualitySelector, (Object)"The specified quality selector can't be null.");
            this.mMediaSpecBuilder.configureVideo((Consumer<VideoSpec.Builder>)((Consumer)builder -> builder.setQualitySelector(qualitySelector)));
            return this;
        }

        @NonNull
        public Builder setVideoCapabilitiesSource(int videoCapabilitiesSource) {
            Preconditions.checkArgument((videoCapabilitiesSource == 0 || videoCapabilitiesSource == 1 ? 1 : 0) != 0, (Object)("Not a supported video capabilities source: " + videoCapabilitiesSource));
            this.mVideoCapabilitiesSource = videoCapabilitiesSource;
            return this;
        }

        @NonNull
        public Builder setTargetVideoEncodingBitRate(@IntRange(from=1L) int bitrate) {
            if (bitrate <= 0) {
                throw new IllegalArgumentException("The requested target bitrate " + bitrate + " is not supported. Target bitrate must be greater than 0.");
            }
            this.mMediaSpecBuilder.configureVideo((Consumer<VideoSpec.Builder>)((Consumer)builder -> builder.setBitrate((Range<Integer>)new Range((Comparable)Integer.valueOf(bitrate), (Comparable)Integer.valueOf(bitrate)))));
            return this;
        }

        @NonNull
        public Builder setAspectRatio(int aspectRatio) {
            this.mMediaSpecBuilder.configureVideo((Consumer<VideoSpec.Builder>)((Consumer)builder -> builder.setAspectRatio(aspectRatio)));
            return this;
        }

        @NonNull
        Builder setAudioSource(int source) {
            this.mMediaSpecBuilder.configureAudio((Consumer<AudioSpec.Builder>)((Consumer)builder -> builder.setSource(source)));
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        Builder setVideoEncoderFactory(@NonNull EncoderFactory videoEncoderFactory) {
            this.mVideoEncoderFactory = videoEncoderFactory;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        Builder setAudioEncoderFactory(@NonNull EncoderFactory audioEncoderFactory) {
            this.mAudioEncoderFactory = audioEncoderFactory;
            return this;
        }

        @NonNull
        public Recorder build() {
            return new Recorder(this.mExecutor, this.mMediaSpecBuilder.build(), this.mVideoCapabilitiesSource, this.mVideoEncoderFactory, this.mAudioEncoderFactory);
        }
    }
}

