/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.arch.core.util.Function;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.DynamicRanges;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.ResolutionValidatedEncoderProfilesProvider;
import androidx.camera.video.CapabilitiesByQuality;
import androidx.camera.video.Quality;
import androidx.camera.video.VideoCapabilities;
import androidx.camera.video.internal.BackupHdrProfileEncoderProfilesProvider;
import androidx.camera.video.internal.DynamicRangeMatchedEncoderProfilesProvider;
import androidx.camera.video.internal.QualityExploredEncoderProfilesProvider;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import androidx.camera.video.internal.compat.quirk.DeviceQuirks;
import androidx.camera.video.internal.encoder.VideoEncoderConfig;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import androidx.camera.video.internal.workaround.QualityAddedEncoderProfilesProvider;
import androidx.camera.video.internal.workaround.QualityResolutionModifiedEncoderProfilesProvider;
import androidx.camera.video.internal.workaround.QualityValidatedEncoderProfilesProvider;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RequiresApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class RecorderVideoCapabilities
implements VideoCapabilities {
    private final EncoderProfilesProvider mProfilesProvider;
    private final boolean mIsStabilizationSupported;
    private final Map<DynamicRange, CapabilitiesByQuality> mCapabilitiesMapForFullySpecifiedDynamicRange = new HashMap<DynamicRange, CapabilitiesByQuality>();
    private final Map<DynamicRange, CapabilitiesByQuality> mCapabilitiesMapForNonFullySpecifiedDynamicRange = new HashMap<DynamicRange, CapabilitiesByQuality>();

    RecorderVideoCapabilities(int videoCapabilitiesSource, @NonNull CameraInfoInternal cameraInfo, @NonNull Function<VideoEncoderConfig, VideoEncoderInfo> videoEncoderInfoFinder) {
        Preconditions.checkArgument((videoCapabilitiesSource == 0 || videoCapabilitiesSource == 1 ? 1 : 0) != 0, (Object)("Not a supported video capabilities source: " + videoCapabilitiesSource));
        EncoderProfilesProvider encoderProfilesProvider = cameraInfo.getEncoderProfilesProvider();
        Quirks deviceQuirks = DeviceQuirks.getAll();
        encoderProfilesProvider = new QualityAddedEncoderProfilesProvider(encoderProfilesProvider, deviceQuirks, cameraInfo, videoEncoderInfoFinder);
        if (videoCapabilitiesSource == 1) {
            encoderProfilesProvider = new QualityExploredEncoderProfilesProvider(encoderProfilesProvider, Quality.getSortedQualities(), Collections.singleton(DynamicRange.SDR), cameraInfo.getSupportedResolutions(34), videoEncoderInfoFinder);
        }
        encoderProfilesProvider = new QualityResolutionModifiedEncoderProfilesProvider(encoderProfilesProvider, deviceQuirks);
        if (RecorderVideoCapabilities.isHlg10SupportedByCamera(cameraInfo)) {
            encoderProfilesProvider = new BackupHdrProfileEncoderProfilesProvider(encoderProfilesProvider, videoEncoderInfoFinder);
        }
        Quirks cameraQuirks = cameraInfo.getCameraQuirks();
        encoderProfilesProvider = new ResolutionValidatedEncoderProfilesProvider(encoderProfilesProvider, cameraQuirks);
        this.mProfilesProvider = encoderProfilesProvider = new QualityValidatedEncoderProfilesProvider(encoderProfilesProvider, cameraInfo, deviceQuirks);
        for (DynamicRange dynamicRange : cameraInfo.getSupportedDynamicRanges()) {
            DynamicRangeMatchedEncoderProfilesProvider constrainedProvider = new DynamicRangeMatchedEncoderProfilesProvider(this.mProfilesProvider, dynamicRange);
            CapabilitiesByQuality capabilities = new CapabilitiesByQuality(constrainedProvider);
            if (capabilities.getSupportedQualities().isEmpty()) continue;
            this.mCapabilitiesMapForFullySpecifiedDynamicRange.put(dynamicRange, capabilities);
        }
        this.mIsStabilizationSupported = cameraInfo.isVideoStabilizationSupported();
    }

    @Override
    @NonNull
    public Set<DynamicRange> getSupportedDynamicRanges() {
        return this.mCapabilitiesMapForFullySpecifiedDynamicRange.keySet();
    }

    @Override
    @NonNull
    public List<Quality> getSupportedQualities(@NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities == null ? new ArrayList() : capabilities.getSupportedQualities();
    }

    @Override
    public boolean isQualitySupported(@NonNull Quality quality, @NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities != null && capabilities.isQualitySupported(quality);
    }

    @Override
    public boolean isStabilizationSupported() {
        return this.mIsStabilizationSupported;
    }

    @Override
    @Nullable
    public VideoValidatedEncoderProfilesProxy getProfiles(@NonNull Quality quality, @NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities == null ? null : capabilities.getProfiles(quality);
    }

    @Override
    @Nullable
    public VideoValidatedEncoderProfilesProxy findNearestHigherSupportedEncoderProfilesFor(@NonNull Size size, @NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities == null ? null : capabilities.findNearestHigherSupportedEncoderProfilesFor(size);
    }

    @Override
    @NonNull
    public Quality findNearestHigherSupportedQualityFor(@NonNull Size size, @NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities == null ? Quality.NONE : capabilities.findNearestHigherSupportedQualityFor(size);
    }

    @Nullable
    private CapabilitiesByQuality getCapabilities(@NonNull DynamicRange dynamicRange) {
        if (dynamicRange.isFullySpecified()) {
            return this.mCapabilitiesMapForFullySpecifiedDynamicRange.get(dynamicRange);
        }
        if (this.mCapabilitiesMapForNonFullySpecifiedDynamicRange.containsKey(dynamicRange)) {
            return this.mCapabilitiesMapForNonFullySpecifiedDynamicRange.get(dynamicRange);
        }
        CapabilitiesByQuality capabilities = this.generateCapabilitiesForNonFullySpecifiedDynamicRange(dynamicRange);
        this.mCapabilitiesMapForNonFullySpecifiedDynamicRange.put(dynamicRange, capabilities);
        return capabilities;
    }

    private static boolean isHlg10SupportedByCamera(@NonNull CameraInfoInternal cameraInfoInternal) {
        Set dynamicRanges = cameraInfoInternal.getSupportedDynamicRanges();
        for (DynamicRange dynamicRange : dynamicRanges) {
            Integer encoding = dynamicRange.getEncoding();
            int bitDepth = dynamicRange.getBitDepth();
            if (!encoding.equals(3) || bitDepth != 10) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private CapabilitiesByQuality generateCapabilitiesForNonFullySpecifiedDynamicRange(@NonNull DynamicRange dynamicRange) {
        if (!DynamicRanges.canResolve((DynamicRange)dynamicRange, this.getSupportedDynamicRanges())) {
            return null;
        }
        DynamicRangeMatchedEncoderProfilesProvider constrainedProvider = new DynamicRangeMatchedEncoderProfilesProvider(this.mProfilesProvider, dynamicRange);
        return new CapabilitiesByQuality(constrainedProvider);
    }
}

