/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.media.MediaCodec;
import android.os.SystemClock;
import android.util.Pair;
import android.util.Range;
import android.util.Size;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.arch.core.util.Function;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.Timebase;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.ThreadConfig;
import androidx.camera.core.internal.UseCaseEventConfig;
import androidx.camera.core.processing.DefaultSurfaceProcessor;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.SurfaceProcessorNode;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.video.MediaSpec;
import androidx.camera.video.Quality;
import androidx.camera.video.QualityRatioToResolutionsTable;
import androidx.camera.video.QualitySelector;
import androidx.camera.video.StreamInfo;
import androidx.camera.video.VideoCapabilities;
import androidx.camera.video.VideoOutput;
import androidx.camera.video.VideoSpec;
import androidx.camera.video.impl.VideoCaptureConfig;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import androidx.camera.video.internal.compat.quirk.DeviceQuirks;
import androidx.camera.video.internal.compat.quirk.ExtraSupportedResolutionQuirk;
import androidx.camera.video.internal.compat.quirk.ImageCaptureFailedWhenVideoCaptureIsBoundQuirk;
import androidx.camera.video.internal.compat.quirk.PreviewDelayWhenVideoCaptureIsBoundQuirk;
import androidx.camera.video.internal.compat.quirk.PreviewStretchWhenVideoCaptureIsBoundQuirk;
import androidx.camera.video.internal.compat.quirk.VideoQualityQuirk;
import androidx.camera.video.internal.config.VideoConfigUtil;
import androidx.camera.video.internal.config.VideoMimeInfo;
import androidx.camera.video.internal.encoder.VideoEncoderConfig;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import androidx.camera.video.internal.encoder.VideoEncoderInfoImpl;
import androidx.camera.video.internal.workaround.VideoEncoderInfoWrapper;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresApi(value=21)
public final class VideoCapture<T extends VideoOutput>
extends UseCase {
    private static final String TAG = "VideoCapture";
    private static final String SURFACE_UPDATE_KEY = "androidx.camera.video.VideoCapture.streamUpdate";
    private static final Defaults DEFAULT_CONFIG = new Defaults();
    @VisibleForTesting
    static boolean sEnableSurfaceProcessingByQuirk;
    private static final boolean USE_TEMPLATE_PREVIEW_BY_QUIRK;
    DeferrableSurface mDeferrableSurface;
    @Nullable
    private SurfaceEdge mCameraEdge;
    StreamInfo mStreamInfo = StreamInfo.STREAM_INFO_ANY_INACTIVE;
    @NonNull
    SessionConfig.Builder mSessionConfigBuilder = new SessionConfig.Builder();
    ListenableFuture<Void> mSurfaceUpdateFuture = null;
    private SurfaceRequest mSurfaceRequest;
    VideoOutput.SourceState mSourceState = VideoOutput.SourceState.INACTIVE;
    @Nullable
    private SurfaceProcessorNode mNode;
    @Nullable
    private VideoEncoderInfo mVideoEncoderInfo;
    @Nullable
    private Rect mCropRect;
    private int mRotationDegrees;
    private boolean mHasCompensatingTransformation = false;
    private final Observable.Observer<StreamInfo> mStreamInfoObserver = new Observable.Observer<StreamInfo>(){

        public void onNewData(@Nullable StreamInfo streamInfo) {
            if (streamInfo == null) {
                throw new IllegalArgumentException("StreamInfo can't be null");
            }
            if (VideoCapture.this.mSourceState == VideoOutput.SourceState.INACTIVE) {
                return;
            }
            Logger.d((String)VideoCapture.TAG, (String)("Stream info update: old: " + VideoCapture.this.mStreamInfo + " new: " + streamInfo));
            StreamInfo currentStreamInfo = VideoCapture.this.mStreamInfo;
            VideoCapture.this.mStreamInfo = streamInfo;
            StreamSpec attachedStreamSpec = (StreamSpec)Preconditions.checkNotNull((Object)VideoCapture.this.getAttachedStreamSpec());
            if (VideoCapture.this.isStreamIdChanged(currentStreamInfo.getId(), streamInfo.getId()) || VideoCapture.this.shouldResetCompensatingTransformation(currentStreamInfo, streamInfo)) {
                VideoCapture.this.resetPipeline(VideoCapture.this.getCameraId(), (VideoCaptureConfig)VideoCapture.this.getCurrentConfig(), (StreamSpec)Preconditions.checkNotNull((Object)VideoCapture.this.getAttachedStreamSpec()));
            } else if (currentStreamInfo.getId() != -1 && streamInfo.getId() == -1 || currentStreamInfo.getId() == -1 && streamInfo.getId() != -1) {
                VideoCapture.this.applyStreamInfoAndStreamSpecToSessionConfigBuilder(VideoCapture.this.mSessionConfigBuilder, streamInfo, attachedStreamSpec);
                VideoCapture.this.updateSessionConfig(VideoCapture.this.mSessionConfigBuilder.build());
                VideoCapture.this.notifyReset();
            } else if (currentStreamInfo.getStreamState() != streamInfo.getStreamState()) {
                VideoCapture.this.applyStreamInfoAndStreamSpecToSessionConfigBuilder(VideoCapture.this.mSessionConfigBuilder, streamInfo, attachedStreamSpec);
                VideoCapture.this.updateSessionConfig(VideoCapture.this.mSessionConfigBuilder.build());
                VideoCapture.this.notifyUpdated();
            }
        }

        public void onError(@NonNull Throwable t) {
            Logger.w((String)VideoCapture.TAG, (String)"Receive onError from StreamState observer", (Throwable)t);
        }
    };

    @NonNull
    public static <T extends VideoOutput> VideoCapture<T> withOutput(@NonNull T videoOutput) {
        return new Builder<VideoOutput>((VideoOutput)Preconditions.checkNotNull(videoOutput)).build();
    }

    VideoCapture(@NonNull VideoCaptureConfig<T> config) {
        super(config);
    }

    @NonNull
    public T getOutput() {
        return ((VideoCaptureConfig)this.getCurrentConfig()).getVideoOutput();
    }

    public int getTargetRotation() {
        return this.getTargetRotationInternal();
    }

    @NonNull
    public Range<Integer> getTargetFrameRate() {
        return this.getTargetFrameRateInternal();
    }

    public boolean isVideoStabilizationEnabled() {
        return this.getCurrentConfig().getVideoStabilizationMode() == 2;
    }

    public void setTargetRotation(int rotation) {
        if (this.setTargetRotationInternal(rotation)) {
            this.sendTransformationInfoIfReady();
        }
    }

    public int getMirrorMode() {
        return this.getMirrorModeInternal();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected StreamSpec onSuggestedStreamSpecUpdated(@NonNull StreamSpec suggestedStreamSpec) {
        Logger.d((String)TAG, (String)("onSuggestedStreamSpecUpdated: " + suggestedStreamSpec));
        VideoCaptureConfig config = (VideoCaptureConfig)this.getCurrentConfig();
        List customOrderedResolutions = config.getCustomOrderedResolutions(null);
        if (customOrderedResolutions != null && !customOrderedResolutions.contains(suggestedStreamSpec.getResolution())) {
            Logger.w((String)TAG, (String)("suggested resolution " + suggestedStreamSpec.getResolution() + " is not in custom ordered resolutions " + customOrderedResolutions));
        }
        return suggestedStreamSpec;
    }

    @NonNull
    public DynamicRange getDynamicRange() {
        return this.getCurrentConfig().hasDynamicRange() ? this.getCurrentConfig().getDynamicRange() : Defaults.DEFAULT_DYNAMIC_RANGE;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onStateAttached() {
        super.onStateAttached();
        Preconditions.checkNotNull((Object)this.getAttachedStreamSpec(), (Object)"The suggested stream specification should be already updated and shouldn't be null.");
        Preconditions.checkState((this.mSurfaceRequest == null ? 1 : 0) != 0, (String)"The surface request should be null when VideoCapture is attached.");
        StreamSpec attachedStreamSpec = (StreamSpec)Preconditions.checkNotNull((Object)this.getAttachedStreamSpec());
        this.mStreamInfo = VideoCapture.fetchObservableValue(this.getOutput().getStreamInfo(), StreamInfo.STREAM_INFO_ANY_INACTIVE);
        this.mSessionConfigBuilder = this.createPipeline(this.getCameraId(), (VideoCaptureConfig)this.getCurrentConfig(), attachedStreamSpec);
        this.applyStreamInfoAndStreamSpecToSessionConfigBuilder(this.mSessionConfigBuilder, this.mStreamInfo, attachedStreamSpec);
        this.updateSessionConfig(this.mSessionConfigBuilder.build());
        this.notifyActive();
        this.getOutput().getStreamInfo().addObserver((Executor)CameraXExecutors.mainThreadExecutor(), this.mStreamInfoObserver);
        this.setSourceState(VideoOutput.SourceState.ACTIVE_NON_STREAMING);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setViewPortCropRect(@NonNull Rect viewPortCropRect) {
        super.setViewPortCropRect(viewPortCropRect);
        this.sendTransformationInfoIfReady();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onStateDetached() {
        Preconditions.checkState((boolean)Threads.isMainThread(), (String)"VideoCapture can only be detached on the main thread.");
        this.setSourceState(VideoOutput.SourceState.INACTIVE);
        this.getOutput().getStreamInfo().removeObserver(this.mStreamInfoObserver);
        if (this.mSurfaceUpdateFuture != null && this.mSurfaceUpdateFuture.cancel(false)) {
            Logger.d((String)TAG, (String)"VideoCapture is detached from the camera. Surface update cancelled.");
        }
        this.clearPipeline();
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected StreamSpec onSuggestedStreamSpecImplementationOptionsUpdated(@NonNull Config config) {
        this.mSessionConfigBuilder.addImplementationOptions(config);
        this.updateSessionConfig(this.mSessionConfigBuilder.build());
        return this.getAttachedStreamSpec().toBuilder().setImplementationOptions(config).build();
    }

    @NonNull
    public String toString() {
        return "VideoCapture:" + this.getName();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(DEFAULT_CONFIG.getConfig().getCaptureType(), 1);
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs((Config)captureConfig, DEFAULT_CONFIG.getConfig());
        }
        return captureConfig == null ? null : this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        this.updateCustomOrderedResolutionsByQuality(cameraInfo, builder);
        return builder.getUseCaseConfig();
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return Builder.fromConfig(config);
    }

    private void sendTransformationInfoIfReady() {
        CameraInternal cameraInternal = this.getCamera();
        SurfaceEdge cameraEdge = this.mCameraEdge;
        if (cameraInternal != null && cameraEdge != null) {
            this.mRotationDegrees = this.adjustRotationWithInProgressTransformation(this.getRelativeRotation(cameraInternal, this.isMirroringRequired(cameraInternal)));
            cameraEdge.updateTransformation(this.mRotationDegrees, this.getAppTargetRotation());
        }
    }

    @NonNull
    private Rect adjustCropRectWithInProgressTransformation(@NonNull Rect cropRect, int rotationDegrees) {
        Rect adjustedCropRect = cropRect;
        if (this.shouldCompensateTransformation()) {
            adjustedCropRect = TransformUtils.sizeToRect((Size)TransformUtils.getRotatedSize((Rect)((SurfaceRequest.TransformationInfo)Preconditions.checkNotNull((Object)this.mStreamInfo.getInProgressTransformationInfo())).getCropRect(), (int)rotationDegrees));
        }
        return adjustedCropRect;
    }

    private int adjustRotationWithInProgressTransformation(int rotationDegrees) {
        int adjustedRotationDegrees = rotationDegrees;
        if (this.shouldCompensateTransformation()) {
            adjustedRotationDegrees = TransformUtils.within360((int)(rotationDegrees - this.mStreamInfo.getInProgressTransformationInfo().getRotationDegrees()));
        }
        return adjustedRotationDegrees;
    }

    @NonNull
    private Size adjustResolutionWithInProgressTransformation(@NonNull Size resolution, @NonNull Rect originalCropRect, @NonNull Rect targetCropRect) {
        Size nodeResolution = resolution;
        if (this.shouldCompensateTransformation() && !targetCropRect.equals((Object)originalCropRect)) {
            float targetRatio = (float)targetCropRect.height() / (float)originalCropRect.height();
            nodeResolution = new Size((int)Math.ceil((float)resolution.getWidth() * targetRatio), (int)Math.ceil((float)resolution.getHeight() * targetRatio));
        }
        return nodeResolution;
    }

    @VisibleForTesting
    @Nullable
    Rect getCropRect() {
        return this.mCropRect;
    }

    @VisibleForTesting
    int getRotationDegrees() {
        return this.mRotationDegrees;
    }

    @NonNull
    private Rect calculateCropRect(@NonNull Size surfaceResolution, @Nullable VideoEncoderInfo videoEncoderInfo) {
        Rect cropRect = this.getViewPortCropRect() != null ? this.getViewPortCropRect() : new Rect(0, 0, surfaceResolution.getWidth(), surfaceResolution.getHeight());
        if (videoEncoderInfo == null || videoEncoderInfo.isSizeSupported(cropRect.width(), cropRect.height())) {
            return cropRect;
        }
        return VideoCapture.adjustCropRectToValidSize(cropRect, surfaceResolution, videoEncoderInfo);
    }

    @SuppressLint(value={"WrongConstant"})
    @MainThread
    @NonNull
    private SessionConfig.Builder createPipeline(@NonNull String cameraId, @NonNull VideoCaptureConfig<T> config, @NonNull StreamSpec streamSpec) {
        Threads.checkMainThread();
        CameraInternal camera = (CameraInternal)Preconditions.checkNotNull((Object)this.getCamera());
        Size resolution = streamSpec.getResolution();
        Runnable onSurfaceInvalidated = () -> this.notifyReset();
        Range<Integer> expectedFrameRate = streamSpec.getExpectedFrameRateRange();
        if (Objects.equals(expectedFrameRate, StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
            expectedFrameRate = Defaults.DEFAULT_FPS_RANGE;
        }
        MediaSpec mediaSpec = Objects.requireNonNull(this.getMediaSpec());
        VideoCapabilities videoCapabilities = this.getVideoCapabilities(camera.getCameraInfo());
        DynamicRange dynamicRange = streamSpec.getDynamicRange();
        VideoEncoderInfo videoEncoderInfo = this.getVideoEncoderInfo(config.getVideoEncoderInfoFinder(), videoCapabilities, dynamicRange, mediaSpec, resolution, expectedFrameRate);
        this.mRotationDegrees = this.adjustRotationWithInProgressTransformation(this.getRelativeRotation(camera, this.isMirroringRequired(camera)));
        Rect originalCropRect = this.calculateCropRect(resolution, videoEncoderInfo);
        this.mCropRect = this.adjustCropRectWithInProgressTransformation(originalCropRect, this.mRotationDegrees);
        Size nodeResolution = this.adjustResolutionWithInProgressTransformation(resolution, originalCropRect, this.mCropRect);
        if (this.shouldCompensateTransformation()) {
            this.mHasCompensatingTransformation = true;
        }
        this.mNode = this.createNodeIfNeeded(camera, this.mCropRect, resolution, dynamicRange);
        Timebase timebase = this.mNode != null || !camera.getHasTransform() ? camera.getCameraInfoInternal().getTimebase() : Timebase.UPTIME;
        Logger.d((String)TAG, (String)("camera timebase = " + camera.getCameraInfoInternal().getTimebase() + ", processing timebase = " + timebase));
        StreamSpec updatedStreamSpec = streamSpec.toBuilder().setResolution(nodeResolution).setExpectedFrameRateRange(expectedFrameRate).build();
        Preconditions.checkState((this.mCameraEdge == null ? 1 : 0) != 0);
        this.mCameraEdge = new SurfaceEdge(2, 34, updatedStreamSpec, this.getSensorToBufferTransformMatrix(), camera.getHasTransform(), this.mCropRect, this.mRotationDegrees, this.getAppTargetRotation(), this.shouldMirror(camera));
        this.mCameraEdge.addOnInvalidatedListener(onSurfaceInvalidated);
        if (this.mNode != null) {
            SurfaceProcessorNode.OutConfig outConfig = SurfaceProcessorNode.OutConfig.of((SurfaceEdge)this.mCameraEdge);
            SurfaceProcessorNode.In nodeInput = SurfaceProcessorNode.In.of((SurfaceEdge)this.mCameraEdge, Collections.singletonList(outConfig));
            SurfaceProcessorNode.Out nodeOutput = this.mNode.transform(nodeInput);
            SurfaceEdge appEdge = Objects.requireNonNull((SurfaceEdge)nodeOutput.get((Object)outConfig));
            appEdge.addOnInvalidatedListener(() -> this.onAppEdgeInvalidated(appEdge, camera, config, timebase));
            this.mSurfaceRequest = appEdge.createSurfaceRequest(camera);
            DeferrableSurface latestDeferrableSurface = this.mDeferrableSurface = this.mCameraEdge.getDeferrableSurface();
            this.mDeferrableSurface.getTerminationFuture().addListener(() -> {
                if (latestDeferrableSurface == this.mDeferrableSurface) {
                    this.clearPipeline();
                }
            }, (Executor)CameraXExecutors.mainThreadExecutor());
        } else {
            this.mSurfaceRequest = this.mCameraEdge.createSurfaceRequest(camera);
            this.mDeferrableSurface = this.mSurfaceRequest.getDeferrableSurface();
        }
        config.getVideoOutput().onSurfaceRequested(this.mSurfaceRequest, timebase);
        this.sendTransformationInfoIfReady();
        this.mDeferrableSurface.setContainerClass(MediaCodec.class);
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config, (Size)streamSpec.getResolution());
        sessionConfigBuilder.setExpectedFrameRateRange(streamSpec.getExpectedFrameRateRange());
        sessionConfigBuilder.setVideoStabilization(config.getVideoStabilizationMode());
        sessionConfigBuilder.addErrorListener((sessionConfig, error) -> this.resetPipeline(cameraId, config, streamSpec));
        if (USE_TEMPLATE_PREVIEW_BY_QUIRK) {
            sessionConfigBuilder.setTemplateType(1);
        }
        if (streamSpec.getImplementationOptions() != null) {
            sessionConfigBuilder.addImplementationOptions(streamSpec.getImplementationOptions());
        }
        return sessionConfigBuilder;
    }

    private void onAppEdgeInvalidated(@NonNull SurfaceEdge appEdge, @NonNull CameraInternal camera, @NonNull VideoCaptureConfig<T> config, @NonNull Timebase timebase) {
        if (camera == this.getCamera()) {
            this.mSurfaceRequest = appEdge.createSurfaceRequest(camera);
            config.getVideoOutput().onSurfaceRequested(this.mSurfaceRequest, timebase);
            this.sendTransformationInfoIfReady();
        }
    }

    @MainThread
    private void clearPipeline() {
        Threads.checkMainThread();
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
            this.mDeferrableSurface = null;
        }
        if (this.mNode != null) {
            this.mNode.release();
            this.mNode = null;
        }
        if (this.mCameraEdge != null) {
            this.mCameraEdge.close();
            this.mCameraEdge = null;
        }
        this.mVideoEncoderInfo = null;
        this.mCropRect = null;
        this.mSurfaceRequest = null;
        this.mStreamInfo = StreamInfo.STREAM_INFO_ANY_INACTIVE;
        this.mRotationDegrees = 0;
        this.mHasCompensatingTransformation = false;
    }

    @MainThread
    void resetPipeline(@NonNull String cameraId, @NonNull VideoCaptureConfig<T> config, @NonNull StreamSpec streamSpec) {
        this.clearPipeline();
        if (this.isCurrentCamera(cameraId)) {
            this.mSessionConfigBuilder = this.createPipeline(cameraId, config, streamSpec);
            this.applyStreamInfoAndStreamSpecToSessionConfigBuilder(this.mSessionConfigBuilder, this.mStreamInfo, streamSpec);
            this.updateSessionConfig(this.mSessionConfigBuilder.build());
            this.notifyReset();
        }
    }

    @Nullable
    @VisibleForTesting
    SurfaceEdge getCameraEdge() {
        return this.mCameraEdge;
    }

    @Nullable
    private MediaSpec getMediaSpec() {
        return VideoCapture.fetchObservableValue(this.getOutput().getMediaSpec(), null);
    }

    @NonNull
    private VideoCapabilities getVideoCapabilities(@NonNull CameraInfo cameraInfo) {
        return this.getOutput().getMediaCapabilities(cameraInfo);
    }

    @MainThread
    void applyStreamInfoAndStreamSpecToSessionConfigBuilder(@NonNull SessionConfig.Builder sessionConfigBuilder, @NonNull StreamInfo streamInfo, @NonNull StreamSpec streamSpec) {
        boolean isStreamActive;
        boolean isStreamError = streamInfo.getId() == -1;
        boolean bl = isStreamActive = streamInfo.getStreamState() == StreamInfo.StreamState.ACTIVE;
        if (isStreamError && isStreamActive) {
            throw new IllegalStateException("Unexpected stream state, stream is error but active");
        }
        sessionConfigBuilder.clearSurfaces();
        DynamicRange dynamicRange = streamSpec.getDynamicRange();
        if (!isStreamError && this.mDeferrableSurface != null) {
            if (isStreamActive) {
                sessionConfigBuilder.addSurface(this.mDeferrableSurface, dynamicRange);
            } else {
                sessionConfigBuilder.addNonRepeatingSurface(this.mDeferrableSurface, dynamicRange);
            }
        }
        this.setupSurfaceUpdateNotifier(sessionConfigBuilder, isStreamActive);
    }

    @Nullable
    private SurfaceProcessorNode createNodeIfNeeded(@NonNull CameraInternal camera, @NonNull Rect cropRect, @NonNull Size resolution, @NonNull DynamicRange dynamicRange) {
        if (this.getEffect() != null || VideoCapture.shouldEnableSurfaceProcessingByQuirk(camera) || VideoCapture.shouldCrop(cropRect, resolution) || this.shouldMirror(camera) || this.shouldCompensateTransformation()) {
            Logger.d((String)TAG, (String)"Surface processing is enabled.");
            return new SurfaceProcessorNode(Objects.requireNonNull(this.getCamera()), this.getEffect() != null ? this.getEffect().createSurfaceProcessorInternal() : DefaultSurfaceProcessor.Factory.newInstance((DynamicRange)dynamicRange));
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    SurfaceProcessorNode getNode() {
        return this.mNode;
    }

    @NonNull
    private static Rect adjustCropRectToValidSize(@NonNull Rect cropRect, @NonNull Size resolution, @NonNull VideoEncoderInfo videoEncoderInfo) {
        Logger.d((String)TAG, (String)String.format("Adjust cropRect %s by width/height alignment %d/%d and supported widths %s / supported heights %s", TransformUtils.rectToString((Rect)cropRect), videoEncoderInfo.getWidthAlignment(), videoEncoderInfo.getHeightAlignment(), videoEncoderInfo.getSupportedWidths(), videoEncoderInfo.getSupportedHeights()));
        int widthAlignment = videoEncoderInfo.getWidthAlignment();
        int heightAlignment = videoEncoderInfo.getHeightAlignment();
        Range<Integer> supportedWidths = videoEncoderInfo.getSupportedWidths();
        Range<Integer> supportedHeights = videoEncoderInfo.getSupportedHeights();
        int widthAlignedDown = VideoCapture.alignDown(cropRect.width(), widthAlignment, supportedWidths);
        int widthAlignedUp = VideoCapture.alignUp(cropRect.width(), widthAlignment, supportedWidths);
        int heightAlignedDown = VideoCapture.alignDown(cropRect.height(), heightAlignment, supportedHeights);
        int heightAlignedUp = VideoCapture.alignUp(cropRect.height(), heightAlignment, supportedHeights);
        HashSet<Size> candidateSet = new HashSet<Size>();
        VideoCapture.addBySupportedSize(candidateSet, widthAlignedDown, heightAlignedDown, resolution, videoEncoderInfo);
        VideoCapture.addBySupportedSize(candidateSet, widthAlignedDown, heightAlignedUp, resolution, videoEncoderInfo);
        VideoCapture.addBySupportedSize(candidateSet, widthAlignedUp, heightAlignedDown, resolution, videoEncoderInfo);
        VideoCapture.addBySupportedSize(candidateSet, widthAlignedUp, heightAlignedUp, resolution, videoEncoderInfo);
        if (candidateSet.isEmpty()) {
            Logger.w((String)TAG, (String)"Can't find valid cropped size");
            return cropRect;
        }
        ArrayList<Size> candidatesList = new ArrayList<Size>(candidateSet);
        Logger.d((String)TAG, (String)("candidatesList = " + candidatesList));
        Collections.sort(candidatesList, (s1, s2) -> Math.abs(s1.getWidth() - cropRect.width()) + Math.abs(s1.getHeight() - cropRect.height()) - (Math.abs(s2.getWidth() - cropRect.width()) + Math.abs(s2.getHeight() - cropRect.height())));
        Logger.d((String)TAG, (String)("sorted candidatesList = " + candidatesList));
        Size newSize = (Size)candidatesList.get(0);
        int newWidth = newSize.getWidth();
        int newHeight = newSize.getHeight();
        if (newWidth == cropRect.width() && newHeight == cropRect.height()) {
            Logger.d((String)TAG, (String)"No need to adjust cropRect because crop size is valid.");
            return cropRect;
        }
        Preconditions.checkState((newWidth % 2 == 0 && newHeight % 2 == 0 && newWidth <= resolution.getWidth() && newHeight <= resolution.getHeight() ? 1 : 0) != 0);
        Rect newCropRect = new Rect(cropRect);
        if (newWidth != cropRect.width()) {
            newCropRect.left = Math.max(0, cropRect.centerX() - newWidth / 2);
            newCropRect.right = newCropRect.left + newWidth;
            if (newCropRect.right > resolution.getWidth()) {
                newCropRect.right = resolution.getWidth();
                newCropRect.left = newCropRect.right - newWidth;
            }
        }
        if (newHeight != cropRect.height()) {
            newCropRect.top = Math.max(0, cropRect.centerY() - newHeight / 2);
            newCropRect.bottom = newCropRect.top + newHeight;
            if (newCropRect.bottom > resolution.getHeight()) {
                newCropRect.bottom = resolution.getHeight();
                newCropRect.top = newCropRect.bottom - newHeight;
            }
        }
        Logger.d((String)TAG, (String)String.format("Adjust cropRect from %s to %s", TransformUtils.rectToString((Rect)cropRect), TransformUtils.rectToString((Rect)newCropRect)));
        return newCropRect;
    }

    private static void addBySupportedSize(@NonNull Set<Size> candidates, int width, int height, @NonNull Size resolution, @NonNull VideoEncoderInfo videoEncoderInfo) {
        if (width > resolution.getWidth() || height > resolution.getHeight()) {
            return;
        }
        try {
            Range<Integer> supportedHeights = videoEncoderInfo.getSupportedHeightsFor(width);
            candidates.add(new Size(width, ((Integer)supportedHeights.clamp((Comparable)Integer.valueOf(height))).intValue()));
        }
        catch (IllegalArgumentException e) {
            Logger.w((String)TAG, (String)("No supportedHeights for width: " + width), (Throwable)e);
        }
        try {
            Range<Integer> supportedWidths = videoEncoderInfo.getSupportedWidthsFor(height);
            candidates.add(new Size(((Integer)supportedWidths.clamp((Comparable)Integer.valueOf(width))).intValue(), height));
        }
        catch (IllegalArgumentException e) {
            Logger.w((String)TAG, (String)("No supportedWidths for height: " + height), (Throwable)e);
        }
    }

    boolean isStreamIdChanged(int currentId, int newId) {
        return !StreamInfo.NON_SURFACE_STREAM_ID.contains(currentId) && !StreamInfo.NON_SURFACE_STREAM_ID.contains(newId) && currentId != newId;
    }

    boolean shouldResetCompensatingTransformation(@NonNull StreamInfo currentStreamInfo, @NonNull StreamInfo streamInfo) {
        return this.mHasCompensatingTransformation && currentStreamInfo.getInProgressTransformationInfo() != null && streamInfo.getInProgressTransformationInfo() == null;
    }

    private boolean shouldMirror(@NonNull CameraInternal camera) {
        return camera.getHasTransform() && this.isMirroringRequired(camera);
    }

    private boolean shouldCompensateTransformation() {
        return this.mStreamInfo.getInProgressTransformationInfo() != null;
    }

    private static boolean shouldCrop(@NonNull Rect cropRect, @NonNull Size resolution) {
        return resolution.getWidth() != cropRect.width() || resolution.getHeight() != cropRect.height();
    }

    private static boolean shouldEnableSurfaceProcessingByQuirk(@NonNull CameraInternal camera) {
        return camera.getHasTransform() && sEnableSurfaceProcessingByQuirk;
    }

    private static int alignDown(int length, int alignment, @NonNull Range<Integer> supportedLength) {
        return VideoCapture.align(true, length, alignment, supportedLength);
    }

    private static int alignUp(int length, int alignment, @NonNull Range<Integer> supportedRange) {
        return VideoCapture.align(false, length, alignment, supportedRange);
    }

    private static int align(boolean alignDown, int length, int alignment, @NonNull Range<Integer> supportedRange) {
        int remainder = length % alignment;
        int newLength = remainder == 0 ? length : (alignDown ? length - remainder : length + (alignment - remainder));
        return (Integer)supportedRange.clamp((Comparable)Integer.valueOf(newLength));
    }

    @MainThread
    @Nullable
    private VideoEncoderInfo getVideoEncoderInfo(@NonNull Function<VideoEncoderConfig, VideoEncoderInfo> videoEncoderInfoFinder, @NonNull VideoCapabilities videoCapabilities, @NonNull DynamicRange dynamicRange, @NonNull MediaSpec mediaSpec, @NonNull Size resolution, @NonNull Range<Integer> expectedFrameRate) {
        if (this.mVideoEncoderInfo != null) {
            return this.mVideoEncoderInfo;
        }
        VideoValidatedEncoderProfilesProxy encoderProfiles = videoCapabilities.findNearestHigherSupportedEncoderProfilesFor(resolution, dynamicRange);
        VideoEncoderInfo videoEncoderInfo = VideoCapture.resolveVideoEncoderInfo(videoEncoderInfoFinder, encoderProfiles, mediaSpec, resolution, dynamicRange, expectedFrameRate);
        if (videoEncoderInfo == null) {
            Logger.w((String)TAG, (String)"Can't find videoEncoderInfo");
            return null;
        }
        Size profileSize = encoderProfiles != null ? new Size(encoderProfiles.getDefaultVideoProfile().getWidth(), encoderProfiles.getDefaultVideoProfile().getHeight()) : null;
        this.mVideoEncoderInfo = videoEncoderInfo = VideoEncoderInfoWrapper.from(videoEncoderInfo, profileSize);
        return this.mVideoEncoderInfo;
    }

    @Nullable
    private static VideoEncoderInfo resolveVideoEncoderInfo(@NonNull Function<VideoEncoderConfig, VideoEncoderInfo> videoEncoderInfoFinder, @Nullable VideoValidatedEncoderProfilesProxy encoderProfiles, @NonNull MediaSpec mediaSpec, @NonNull Size resolution, @NonNull DynamicRange dynamicRange, @NonNull Range<Integer> expectedFrameRate) {
        VideoMimeInfo videoMimeInfo = VideoConfigUtil.resolveVideoMimeInfo(mediaSpec, dynamicRange, encoderProfiles);
        VideoEncoderConfig videoEncoderConfig = VideoConfigUtil.resolveVideoEncoderConfig(videoMimeInfo, Timebase.UPTIME, mediaSpec.getVideoSpec(), resolution, dynamicRange, expectedFrameRate);
        return (VideoEncoderInfo)videoEncoderInfoFinder.apply((Object)videoEncoderConfig);
    }

    @MainThread
    private void setupSurfaceUpdateNotifier(final @NonNull SessionConfig.Builder sessionConfigBuilder, final boolean isStreamActive) {
        if (this.mSurfaceUpdateFuture != null && this.mSurfaceUpdateFuture.cancel(false)) {
            Logger.d((String)TAG, (String)"A newer surface update is requested. Previous surface update cancelled.");
        }
        final ListenableFuture surfaceUpdateFuture = this.mSurfaceUpdateFuture = CallbackToFutureAdapter.getFuture(completer -> {
            sessionConfigBuilder.addTag(SURFACE_UPDATE_KEY, (Object)completer.hashCode());
            final AtomicBoolean surfaceUpdateComplete = new AtomicBoolean(false);
            CameraCaptureCallback cameraCaptureCallback = new CameraCaptureCallback(){
                private boolean mIsFirstCaptureResult = true;

                public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
                    Object tag;
                    super.onCaptureCompleted(cameraCaptureResult);
                    if (this.mIsFirstCaptureResult) {
                        this.mIsFirstCaptureResult = false;
                        Logger.d((String)VideoCapture.TAG, (String)("cameraCaptureResult timestampNs = " + cameraCaptureResult.getTimestamp() + ", current system uptimeMs = " + SystemClock.uptimeMillis() + ", current system realtimeMs = " + SystemClock.elapsedRealtime()));
                    }
                    if (!surfaceUpdateComplete.get() && (tag = cameraCaptureResult.getTagBundle().getTag(VideoCapture.SURFACE_UPDATE_KEY)) != null && ((Integer)tag).intValue() == completer.hashCode() && completer.set(null) && !surfaceUpdateComplete.getAndSet(true)) {
                        CameraXExecutors.mainThreadExecutor().execute(() -> sessionConfigBuilder.removeCameraCaptureCallback((CameraCaptureCallback)this));
                    }
                }
            };
            completer.addCancellationListener(() -> {
                Preconditions.checkState((boolean)Threads.isMainThread(), (String)"Surface update cancellation should only occur on main thread.");
                surfaceUpdateComplete.set(true);
                sessionConfigBuilder.removeCameraCaptureCallback(cameraCaptureCallback);
            }, CameraXExecutors.directExecutor());
            sessionConfigBuilder.addRepeatingCameraCaptureCallback(cameraCaptureCallback);
            return String.format("%s[0x%x]", SURFACE_UPDATE_KEY, completer.hashCode());
        });
        Futures.addCallback((ListenableFuture)surfaceUpdateFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                if (surfaceUpdateFuture == VideoCapture.this.mSurfaceUpdateFuture && VideoCapture.this.mSourceState != VideoOutput.SourceState.INACTIVE) {
                    VideoCapture.this.setSourceState(isStreamActive ? VideoOutput.SourceState.ACTIVE_STREAMING : VideoOutput.SourceState.ACTIVE_NON_STREAMING);
                }
            }

            public void onFailure(@NonNull Throwable t) {
                if (!(t instanceof CancellationException)) {
                    Logger.e((String)VideoCapture.TAG, (String)"Surface update completed with unexpected exception", (Throwable)t);
                }
            }
        }, (Executor)CameraXExecutors.mainThreadExecutor());
    }

    private void updateCustomOrderedResolutionsByQuality(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) throws IllegalArgumentException {
        MediaSpec mediaSpec = this.getMediaSpec();
        Preconditions.checkArgument((mediaSpec != null ? 1 : 0) != 0, (Object)"Unable to update target resolution by null MediaSpec.");
        DynamicRange requestedDynamicRange = this.getDynamicRange();
        VideoCapabilities videoCapabilities = this.getVideoCapabilities((CameraInfo)cameraInfo);
        List<Quality> supportedQualities = videoCapabilities.getSupportedQualities(requestedDynamicRange);
        if (supportedQualities.isEmpty()) {
            Logger.w((String)TAG, (String)"Can't find any supported quality on the device.");
            return;
        }
        VideoSpec videoSpec = mediaSpec.getVideoSpec();
        QualitySelector qualitySelector = videoSpec.getQualitySelector();
        List<Quality> selectedQualities = qualitySelector.getPrioritizedQualities(supportedQualities);
        Logger.d((String)TAG, (String)("Found selectedQualities " + selectedQualities + " by " + qualitySelector));
        if (selectedQualities.isEmpty()) {
            throw new IllegalArgumentException("Unable to find supported quality by QualitySelector");
        }
        int aspectRatio = videoSpec.getAspectRatio();
        Map<Quality, Size> sizeMap = QualitySelector.getQualityToResolutionMap(videoCapabilities, requestedDynamicRange);
        QualityRatioToResolutionsTable qualityRatioTable = new QualityRatioToResolutionsTable(cameraInfo.getSupportedResolutions(this.getImageFormat()), sizeMap);
        ArrayList<Size> customOrderedResolutions = new ArrayList<Size>();
        for (Quality selectedQuality : selectedQualities) {
            customOrderedResolutions.addAll(qualityRatioTable.getResolutions(selectedQuality, aspectRatio));
        }
        Logger.d((String)TAG, (String)("Set custom ordered resolutions = " + customOrderedResolutions));
        builder.getMutableConfig().insertOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS, customOrderedResolutions);
    }

    private static boolean hasVideoQualityQuirkAndWorkaroundBySurfaceProcessing() {
        List<VideoQualityQuirk> quirks = DeviceQuirks.getAll(VideoQualityQuirk.class);
        for (VideoQualityQuirk quirk : quirks) {
            if (!quirk.workaroundBySurfaceProcessing()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static <T> T fetchObservableValue(@NonNull Observable<T> observable, @Nullable T valueIfMissing) {
        ListenableFuture future = observable.fetchData();
        if (!future.isDone()) {
            return valueIfMissing;
        }
        try {
            return (T)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @MainThread
    void setSourceState(@NonNull VideoOutput.SourceState newState) {
        VideoOutput.SourceState oldState = this.mSourceState;
        if (newState != oldState) {
            this.mSourceState = newState;
            this.getOutput().onSourceStateChanged(newState);
        }
    }

    @VisibleForTesting
    @NonNull
    SurfaceRequest getSurfaceRequest() {
        return Objects.requireNonNull(this.mSurfaceRequest);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Set<Integer> getSupportedEffectTargets() {
        HashSet<Integer> targets = new HashSet<Integer>();
        targets.add(2);
        return targets;
    }

    static {
        boolean hasPreviewStretchQuirk = DeviceQuirks.get(PreviewStretchWhenVideoCaptureIsBoundQuirk.class) != null;
        boolean hasPreviewDelayQuirk = DeviceQuirks.get(PreviewDelayWhenVideoCaptureIsBoundQuirk.class) != null;
        boolean hasImageCaptureFailedQuirk = DeviceQuirks.get(ImageCaptureFailedWhenVideoCaptureIsBoundQuirk.class) != null;
        boolean hasVideoQualityQuirkAndWorkaroundBySurfaceProcessing = VideoCapture.hasVideoQualityQuirkAndWorkaroundBySurfaceProcessing();
        boolean hasExtraSupportedResolutionQuirk = DeviceQuirks.get(ExtraSupportedResolutionQuirk.class) != null;
        USE_TEMPLATE_PREVIEW_BY_QUIRK = hasPreviewStretchQuirk || hasPreviewDelayQuirk || hasImageCaptureFailedQuirk;
        sEnableSurfaceProcessingByQuirk = hasPreviewDelayQuirk || hasImageCaptureFailedQuirk || hasVideoQualityQuirkAndWorkaroundBySurfaceProcessing || hasExtraSupportedResolutionQuirk;
    }

    @RequiresApi(value=21)
    public static final class Builder<T extends VideoOutput>
    implements UseCaseConfig.Builder<VideoCapture<T>, VideoCaptureConfig<T>, Builder<T>>,
    ImageOutputConfig.Builder<Builder<T>>,
    ImageInputConfig.Builder<Builder<T>>,
    ThreadConfig.Builder<Builder<T>> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder(@NonNull T videoOutput) {
            this(Builder.createInitialBundle(videoOutput));
        }

        private Builder(@NonNull MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            if (!this.mMutableConfig.containsOption(VideoCaptureConfig.OPTION_VIDEO_OUTPUT)) {
                throw new IllegalArgumentException("VideoOutput is required");
            }
            Class oldConfigClass = (Class)mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(VideoCapture.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setCaptureType(UseCaseConfigFactory.CaptureType.VIDEO_CAPTURE);
            this.setTargetClass(VideoCapture.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        static Builder<? extends VideoOutput> fromConfig(@NonNull Config configuration) {
            return new Builder(MutableOptionsBundle.from((Config)configuration));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static <T extends VideoOutput> Builder<T> fromConfig(@NonNull VideoCaptureConfig<T> configuration) {
            return new Builder<T>(MutableOptionsBundle.from(configuration));
        }

        @NonNull
        private static <T extends VideoOutput> MutableOptionsBundle createInitialBundle(@NonNull T videoOutput) {
            MutableOptionsBundle bundle = MutableOptionsBundle.create();
            bundle.insertOption(VideoCaptureConfig.OPTION_VIDEO_OUTPUT, videoOutput);
            return bundle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public VideoCaptureConfig<T> getUseCaseConfig() {
            return new VideoCaptureConfig(OptionsBundle.from((Config)this.mMutableConfig));
        }

        @NonNull
        Builder<T> setVideoEncoderInfoFinder(@NonNull Function<VideoEncoderConfig, VideoEncoderInfo> videoEncoderInfoFinder) {
            this.getMutableConfig().insertOption(VideoCaptureConfig.OPTION_VIDEO_ENCODER_INFO_FINDER, videoEncoderInfoFinder);
            return this;
        }

        @NonNull
        public VideoCapture<T> build() {
            return new VideoCapture(this.getUseCaseConfig());
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setTargetClass(@NonNull Class<VideoCapture<T>> targetClass) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(TargetConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_NAME, (Object)targetName);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setTargetAspectRatio(int aspectRatio) {
            throw new UnsupportedOperationException("setTargetAspectRatio is not supported.");
        }

        @NonNull
        public Builder<T> setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ROTATION, (Object)rotation);
            return this;
        }

        @NonNull
        public Builder<T> setMirrorMode(int mirrorMode) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_MIRROR_MODE, (Object)mirrorMode);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setTargetResolution(@NonNull Size resolution) {
            throw new UnsupportedOperationException("setTargetResolution is not supported.");
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, (Object)resolution);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_MAX_RESOLUTION, (Object)resolution);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setCustomOrderedResolutions(@NonNull List<Size> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS, resolutions);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setResolutionSelector(@NonNull ResolutionSelector resolutionSelector) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR, (Object)resolutionSelector);
            return this;
        }

        @NonNull
        public Builder<T> setDynamicRange(@NonNull DynamicRange dynamicRange) {
            this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_DYNAMIC_RANGE, (Object)dynamicRange);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setBackgroundExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(ThreadConfig.OPTION_BACKGROUND_EXECUTOR, (Object)executor);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_SESSION_CONFIG, (Object)sessionConfig);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_CAPTURE_CONFIG, (Object)captureConfig);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SESSION_CONFIG_UNPACKER, (Object)optionUnpacker);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_CONFIG_UNPACKER, (Object)optionUnpacker);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, (Object)priority);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(UseCaseEventConfig.OPTION_USE_CASE_EVENT_CALLBACK, (Object)useCaseEventCallback);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setZslDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, (Object)disabled);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setHighResolutionDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_HIGH_RESOLUTION_DISABLED, (Object)disabled);
            return this;
        }

        @NonNull
        public Builder<T> setTargetFrameRate(@NonNull Range<Integer> targetFrameRate) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_TARGET_FRAME_RATE, targetFrameRate);
            return this;
        }

        @NonNull
        public Builder<T> setVideoStabilizationEnabled(boolean enabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_VIDEO_STABILIZATION_MODE, (Object)(enabled ? 2 : 1));
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder<T> setCaptureType(@NonNull UseCaseConfigFactory.CaptureType captureType) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_TYPE, (Object)captureType);
            return this;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<VideoCaptureConfig<?>> {
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 5;
        private static final VideoOutput DEFAULT_VIDEO_OUTPUT = SurfaceRequest::willNotProvideSurface;
        private static final VideoCaptureConfig<?> DEFAULT_CONFIG;
        private static final Function<VideoEncoderConfig, VideoEncoderInfo> DEFAULT_VIDEO_ENCODER_INFO_FINDER;
        static final Range<Integer> DEFAULT_FPS_RANGE;
        static final DynamicRange DEFAULT_DYNAMIC_RANGE;

        @NonNull
        public VideoCaptureConfig<?> getConfig() {
            return DEFAULT_CONFIG;
        }

        static {
            DEFAULT_VIDEO_ENCODER_INFO_FINDER = VideoEncoderInfoImpl.FINDER;
            DEFAULT_FPS_RANGE = new Range((Comparable)Integer.valueOf(30), (Comparable)Integer.valueOf(30));
            DEFAULT_DYNAMIC_RANGE = DynamicRange.SDR;
            Object builder = ((Builder)new Builder<VideoOutput>(DEFAULT_VIDEO_OUTPUT).setSurfaceOccupancyPriority(5)).setVideoEncoderInfoFinder(DEFAULT_VIDEO_ENCODER_INFO_FINDER).setDynamicRange(DEFAULT_DYNAMIC_RANGE);
            DEFAULT_CONFIG = ((Builder)builder).getUseCaseConfig();
        }
    }
}

