/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.compat.quirk;

import android.os.Build;
import android.util.Size;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Quirk;

@RequiresApi(value=21)
public class StretchedVideoResolutionQuirk
implements Quirk {
    static boolean load() {
        return StretchedVideoResolutionQuirk.isMotoE5Play();
    }

    private static boolean isMotoE5Play() {
        return "motorola".equalsIgnoreCase(Build.BRAND) && "moto e5 play".equalsIgnoreCase(Build.MODEL);
    }

    @Nullable
    public Size getAlternativeResolution(int quality) {
        switch (quality) {
            case 4: {
                return new Size(640, 480);
            }
            case 5: {
                return new Size(960, 720);
            }
            case 6: {
                return new Size(1440, 1080);
            }
        }
        return null;
    }
}

