/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.workaround;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.Quirks;
import androidx.camera.video.Quality;
import androidx.camera.video.internal.compat.quirk.VideoQualityQuirk;
import java.util.HashMap;
import java.util.Map;

@RequiresApi(value=21)
public class QualityValidatedEncoderProfilesProvider
implements EncoderProfilesProvider {
    private static final Map<Integer, Quality> CAMCORDER_TO_VIDEO_QUALITY_MAP = new HashMap<Integer, Quality>();
    @NonNull
    private final EncoderProfilesProvider mProvider;
    @NonNull
    private final CameraInfoInternal mCameraInfo;
    @NonNull
    private final Quirks mQuirks;

    public QualityValidatedEncoderProfilesProvider(@NonNull EncoderProfilesProvider provider, @NonNull CameraInfoInternal cameraInfo, @NonNull Quirks quirks) {
        this.mProvider = provider;
        this.mCameraInfo = cameraInfo;
        this.mQuirks = quirks;
    }

    public boolean hasProfile(int quality) {
        return this.mProvider.hasProfile(quality) && this.isDeviceValidQuality(quality);
    }

    @Nullable
    public EncoderProfilesProxy getAll(int quality) {
        if (!this.hasProfile(quality)) {
            return null;
        }
        return this.mProvider.getAll(quality);
    }

    private boolean isDeviceValidQuality(int quality) {
        Quality videoQuality = CAMCORDER_TO_VIDEO_QUALITY_MAP.get(quality);
        if (videoQuality != null) {
            for (VideoQualityQuirk quirk : this.mQuirks.getAll(VideoQualityQuirk.class)) {
                if (quirk == null || !quirk.isProblematicVideoQuality(this.mCameraInfo, videoQuality) || quirk.workaroundBySurfaceProcessing()) continue;
                return false;
            }
        }
        return true;
    }

    static {
        CAMCORDER_TO_VIDEO_QUALITY_MAP.put(1, Quality.HIGHEST);
        CAMCORDER_TO_VIDEO_QUALITY_MAP.put(8, Quality.UHD);
        CAMCORDER_TO_VIDEO_QUALITY_MAP.put(6, Quality.FHD);
        CAMCORDER_TO_VIDEO_QUALITY_MAP.put(5, Quality.HD);
        CAMCORDER_TO_VIDEO_QUALITY_MAP.put(4, Quality.SD);
        CAMCORDER_TO_VIDEO_QUALITY_MAP.put(0, Quality.LOWEST);
    }
}

