/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.os.Handler;
import android.os.Looper;
import android.view.Display;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ExperimentalUseCaseGroup;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.VideoCapture;
import androidx.camera.core.ViewPort;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.ForwardingLiveData;
import androidx.camera.view.SensorRotationListener;
import androidx.camera.view.video.ExperimentalVideo;
import androidx.camera.view.video.OnVideoSavedCallback;
import androidx.camera.view.video.OutputFileOptions;
import androidx.camera.view.video.OutputFileResults;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class CameraController {
    private static final String TAG = "CameraController";
    private static final String CAMERA_NOT_INITIALIZED = "Camera not initialized.";
    private static final String PREVIEW_VIEW_NOT_ATTACHED = "PreviewView not attached.";
    private static final String CAMERA_NOT_ATTACHED = "Use cases not attached to camera.";
    private static final String IMAGE_CAPTURE_DISABLED = "ImageCapture disabled.";
    private static final String VIDEO_CAPTURE_DISABLED = "VideoCapture disabled.";
    private static final float AF_SIZE = 0.16666667f;
    private static final float AE_SIZE = 0.25f;
    public static final int IMAGE_CAPTURE = 1;
    public static final int IMAGE_ANALYSIS = 2;
    @ExperimentalVideo
    public static final int VIDEO_CAPTURE = 4;
    CameraSelector mCameraSelector = CameraSelector.DEFAULT_BACK_CAMERA;
    private int mEnabledUseCases = 3;
    @NonNull
    final Preview mPreview;
    @NonNull
    final ImageCapture mImageCapture;
    @Nullable
    private Executor mAnalysisExecutor;
    @Nullable
    private ImageAnalysis.Analyzer mAnalysisAnalyzer;
    @NonNull
    private ImageAnalysis mImageAnalysis;
    @NonNull
    final VideoCapture mVideoCapture;
    @NonNull
    final AtomicBoolean mVideoIsRecording = new AtomicBoolean(false);
    @Nullable
    Camera mCamera;
    @Nullable
    ProcessCameraProvider mCameraProvider;
    @Nullable
    ViewPort mViewPort;
    @Nullable
    Preview.SurfaceProvider mSurfaceProvider;
    @Nullable
    Display mPreviewDisplay;
    @NonNull
    final SensorRotationListener mSensorRotationListener;
    @Nullable
    private final DisplayRotationListener mDisplayRotationListener;
    private boolean mPinchToZoomEnabled = true;
    private boolean mTapToFocusEnabled = true;
    private final ForwardingLiveData<ZoomState> mZoomState = new ForwardingLiveData();
    private final ForwardingLiveData<Integer> mTorchState = new ForwardingLiveData();
    private final Context mAppContext;
    @NonNull
    private final ListenableFuture<Void> mInitializationFuture;

    CameraController(@NonNull Context context) {
        this.mAppContext = context.getApplicationContext();
        this.mPreview = new Preview.Builder().build();
        this.mImageCapture = new ImageCapture.Builder().build();
        this.mImageAnalysis = new ImageAnalysis.Builder().build();
        this.mVideoCapture = new VideoCapture.Builder().build();
        this.mInitializationFuture = Futures.transform((ListenableFuture)ProcessCameraProvider.getInstance((Context)this.mAppContext), provider -> {
            this.mCameraProvider = provider;
            this.startCameraAndTrackStates();
            return null;
        }, (Executor)CameraXExecutors.mainThreadExecutor());
        this.mDisplayRotationListener = new DisplayRotationListener();
        this.mSensorRotationListener = new SensorRotationListener(this.mAppContext){

            @Override
            public void onRotationChanged(int rotation) {
                CameraController.this.mImageCapture.setTargetRotation(rotation);
                CameraController.this.mVideoCapture.setTargetRotation(rotation);
            }
        };
    }

    @NonNull
    public ListenableFuture<Void> getInitializationFuture() {
        return this.mInitializationFuture;
    }

    @Nullable
    abstract Camera startCamera();

    private boolean isCameraInitialized() {
        return this.mCameraProvider != null;
    }

    private boolean isPreviewViewAttached() {
        return this.mSurfaceProvider != null && this.mViewPort != null && this.mPreviewDisplay != null;
    }

    private boolean isCameraAttached() {
        return this.mCamera != null;
    }

    @MainThread
    @UseExperimental(markerClass=ExperimentalVideo.class)
    public void setEnabledUseCases(int enabledUseCases) {
        Threads.checkMainThread();
        if (enabledUseCases == this.mEnabledUseCases) {
            return;
        }
        int oldEnabledUseCases = this.mEnabledUseCases;
        this.mEnabledUseCases = enabledUseCases;
        if (!this.isVideoCaptureEnabled()) {
            this.stopRecording();
        }
        this.startCameraAndTrackStates(() -> {
            this.mEnabledUseCases = oldEnabledUseCases;
        });
    }

    private boolean isUseCaseEnabled(int useCaseMask) {
        return (this.mEnabledUseCases & useCaseMask) != 0;
    }

    @UseExperimental(markerClass=ExperimentalVideo.class)
    private boolean isVideoCaptureEnabledInternal() {
        return this.isVideoCaptureEnabled();
    }

    @SuppressLint(value={"MissingPermission", "WrongConstant"})
    @MainThread
    @UseExperimental(markerClass=ExperimentalUseCaseGroup.class)
    void attachPreviewSurface(@NonNull Preview.SurfaceProvider surfaceProvider, @NonNull ViewPort viewPort, @NonNull Display display) {
        Threads.checkMainThread();
        if (this.mSurfaceProvider != surfaceProvider) {
            this.mSurfaceProvider = surfaceProvider;
            this.mPreview.setSurfaceProvider(surfaceProvider);
        }
        this.mViewPort = viewPort;
        this.mPreviewDisplay = display;
        this.startListeningToRotationEvents();
        this.startCameraAndTrackStates();
    }

    @MainThread
    void clearPreviewSurface() {
        Threads.checkMainThread();
        if (this.mCameraProvider != null) {
            this.mCameraProvider.unbindAll();
        }
        this.mPreview.setSurfaceProvider(null);
        this.mCamera = null;
        this.mSurfaceProvider = null;
        this.mViewPort = null;
        this.mPreviewDisplay = null;
        this.stopListeningToRotationEvents();
    }

    private void startListeningToRotationEvents() {
        this.getDisplayManager().registerDisplayListener((DisplayManager.DisplayListener)this.mDisplayRotationListener, new Handler(Looper.getMainLooper()));
        if (this.mSensorRotationListener.canDetectOrientation()) {
            this.mSensorRotationListener.enable();
        }
    }

    private void stopListeningToRotationEvents() {
        this.getDisplayManager().unregisterDisplayListener((DisplayManager.DisplayListener)this.mDisplayRotationListener);
        this.mSensorRotationListener.disable();
    }

    private DisplayManager getDisplayManager() {
        return (DisplayManager)this.mAppContext.getSystemService("display");
    }

    @MainThread
    public boolean isImageCaptureEnabled() {
        Threads.checkMainThread();
        return this.isUseCaseEnabled(1);
    }

    @MainThread
    public int getImageCaptureFlashMode() {
        Threads.checkMainThread();
        return this.mImageCapture.getFlashMode();
    }

    @MainThread
    public void setImageCaptureFlashMode(int flashMode) {
        Threads.checkMainThread();
        this.mImageCapture.setFlashMode(flashMode);
    }

    @MainThread
    public void takePicture(@NonNull ImageCapture.OutputFileOptions outputFileOptions, @NonNull Executor executor, @NonNull ImageCapture.OnImageSavedCallback imageSavedCallback) {
        Threads.checkMainThread();
        Preconditions.checkState((boolean)this.isCameraInitialized(), (String)CAMERA_NOT_INITIALIZED);
        Preconditions.checkState((boolean)this.isImageCaptureEnabled(), (String)IMAGE_CAPTURE_DISABLED);
        this.updateMirroringFlagInOutputFileOptions(outputFileOptions);
        this.mImageCapture.takePicture(outputFileOptions, executor, imageSavedCallback);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void updateMirroringFlagInOutputFileOptions(@NonNull ImageCapture.OutputFileOptions outputFileOptions) {
        if (this.mCameraSelector.getLensFacing() != null && !outputFileOptions.getMetadata().isReversedHorizontalSet()) {
            outputFileOptions.getMetadata().setReversedHorizontal(this.mCameraSelector.getLensFacing() == 0);
        }
    }

    @MainThread
    public void takePicture(@NonNull Executor executor, @NonNull ImageCapture.OnImageCapturedCallback callback) {
        Threads.checkMainThread();
        Preconditions.checkState((boolean)this.isCameraInitialized(), (String)CAMERA_NOT_INITIALIZED);
        Preconditions.checkState((boolean)this.isImageCaptureEnabled(), (String)IMAGE_CAPTURE_DISABLED);
        this.mImageCapture.takePicture(executor, callback);
    }

    @MainThread
    public boolean isImageAnalysisEnabled() {
        Threads.checkMainThread();
        return this.isUseCaseEnabled(2);
    }

    @MainThread
    public void setImageAnalysisAnalyzer(@NonNull Executor executor, @NonNull ImageAnalysis.Analyzer analyzer) {
        Threads.checkMainThread();
        if (this.mAnalysisAnalyzer == analyzer && this.mAnalysisExecutor == executor) {
            return;
        }
        this.mAnalysisExecutor = executor;
        this.mAnalysisAnalyzer = analyzer;
        this.mImageAnalysis.setAnalyzer(executor, analyzer);
    }

    @MainThread
    public void clearImageAnalysisAnalyzer() {
        Threads.checkMainThread();
        this.mAnalysisExecutor = null;
        this.mAnalysisAnalyzer = null;
        this.mImageAnalysis.clearAnalyzer();
    }

    @MainThread
    public int getImageAnalysisBackpressureStrategy() {
        Threads.checkMainThread();
        return this.mImageAnalysis.getBackpressureStrategy();
    }

    @MainThread
    public void setImageAnalysisBackpressureStrategy(int strategy) {
        Threads.checkMainThread();
        if (this.mImageAnalysis.getBackpressureStrategy() == strategy) {
            return;
        }
        this.unbindImageAnalysisAndRecreate(strategy, this.mImageAnalysis.getImageQueueDepth());
        this.startCameraAndTrackStates();
    }

    @MainThread
    public void setImageAnalysisImageQueueDepth(int depth) {
        Threads.checkMainThread();
        if (this.mImageAnalysis.getImageQueueDepth() == depth) {
            return;
        }
        this.unbindImageAnalysisAndRecreate(this.mImageAnalysis.getBackpressureStrategy(), depth);
        this.startCameraAndTrackStates();
    }

    @MainThread
    public int getImageAnalysisImageQueueDepth() {
        Threads.checkMainThread();
        return this.mImageAnalysis.getImageQueueDepth();
    }

    private void unbindImageAnalysisAndRecreate(int strategy, int imageQueueDepth) {
        if (this.isCameraInitialized()) {
            this.mCameraProvider.unbind(new UseCase[]{this.mImageAnalysis});
        }
        this.mImageAnalysis = new ImageAnalysis.Builder().setBackpressureStrategy(strategy).setImageQueueDepth(imageQueueDepth).build();
        if (this.mAnalysisExecutor != null && this.mAnalysisAnalyzer != null) {
            this.mImageAnalysis.setAnalyzer(this.mAnalysisExecutor, this.mAnalysisAnalyzer);
        }
    }

    @ExperimentalVideo
    @MainThread
    public boolean isVideoCaptureEnabled() {
        Threads.checkMainThread();
        return this.isUseCaseEnabled(4);
    }

    @ExperimentalVideo
    @MainThread
    public void startRecording(@NonNull OutputFileOptions outputFileOptions, @NonNull Executor executor, final @NonNull OnVideoSavedCallback callback) {
        Threads.checkMainThread();
        Preconditions.checkState((boolean)this.isCameraInitialized(), (String)CAMERA_NOT_INITIALIZED);
        Preconditions.checkState((boolean)this.isVideoCaptureEnabled(), (String)VIDEO_CAPTURE_DISABLED);
        this.mVideoCapture.startRecording(outputFileOptions.toVideoCaptureOutputFileOptions(), executor, new VideoCapture.OnVideoSavedCallback(){

            public void onVideoSaved(@NonNull VideoCapture.OutputFileResults outputFileResults) {
                CameraController.this.mVideoIsRecording.set(false);
                callback.onVideoSaved(OutputFileResults.create(outputFileResults.getSavedUri()));
            }

            public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
                CameraController.this.mVideoIsRecording.set(false);
                callback.onError(videoCaptureError, message, cause);
            }
        });
        this.mVideoIsRecording.set(true);
    }

    @ExperimentalVideo
    @MainThread
    public void stopRecording() {
        Threads.checkMainThread();
        if (this.mVideoIsRecording.get()) {
            this.mVideoCapture.stopRecording();
        }
    }

    @ExperimentalVideo
    @MainThread
    public boolean isRecording() {
        Threads.checkMainThread();
        return this.mVideoIsRecording.get();
    }

    @MainThread
    public void setCameraSelector(@NonNull CameraSelector cameraSelector) {
        Threads.checkMainThread();
        if (this.mCameraSelector == cameraSelector) {
            return;
        }
        if (this.mCameraProvider == null) {
            return;
        }
        this.mCameraProvider.unbindAll();
        CameraSelector oldCameraSelector = this.mCameraSelector;
        this.mCameraSelector = cameraSelector;
        this.startCameraAndTrackStates(() -> {
            this.mCameraSelector = oldCameraSelector;
        });
    }

    @NonNull
    @MainThread
    public CameraSelector getCameraSelector() {
        Threads.checkMainThread();
        return this.mCameraSelector;
    }

    @MainThread
    public boolean isPinchToZoomEnabled() {
        Threads.checkMainThread();
        return this.mPinchToZoomEnabled;
    }

    @MainThread
    public void setPinchToZoomEnabled(boolean enabled) {
        Threads.checkMainThread();
        this.mPinchToZoomEnabled = enabled;
    }

    void onPinchToZoom(float pinchToZoomScale) {
        if (!this.isCameraAttached()) {
            Logger.w((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return;
        }
        if (!this.mPinchToZoomEnabled) {
            Logger.d((String)TAG, (String)"Pinch to zoom disabled.");
            return;
        }
        Logger.d((String)TAG, (String)("Pinch to zoom with scale: " + pinchToZoomScale));
        ZoomState zoomState = (ZoomState)this.getZoomState().getValue();
        if (zoomState == null) {
            return;
        }
        float clampedRatio = zoomState.getZoomRatio() * this.speedUpZoomBy2X(pinchToZoomScale);
        clampedRatio = Math.min(Math.max(clampedRatio, zoomState.getMinZoomRatio()), zoomState.getMaxZoomRatio());
        this.setZoomRatio(clampedRatio);
    }

    private float speedUpZoomBy2X(float scaleFactor) {
        if (scaleFactor > 1.0f) {
            return 1.0f + (scaleFactor - 1.0f) * 2.0f;
        }
        return 1.0f - (1.0f - scaleFactor) * 2.0f;
    }

    void onTapToFocus(MeteringPointFactory meteringPointFactory, float x, float y) {
        if (!this.isCameraAttached()) {
            Logger.w((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return;
        }
        if (!this.mTapToFocusEnabled) {
            Logger.d((String)TAG, (String)"Tap to focus disabled. ");
            return;
        }
        Logger.d((String)TAG, (String)("Tap to focus: " + x + ", " + y));
        MeteringPoint afPoint = meteringPointFactory.createPoint(x, y, 0.16666667f);
        MeteringPoint aePoint = meteringPointFactory.createPoint(x, y, 0.25f);
        this.mCamera.getCameraControl().startFocusAndMetering(new FocusMeteringAction.Builder(afPoint, 1).addPoint(aePoint, 2).build());
    }

    @MainThread
    public boolean isTapToFocusEnabled() {
        Threads.checkMainThread();
        return this.mTapToFocusEnabled;
    }

    @MainThread
    public void setTapToFocusEnabled(boolean enabled) {
        Threads.checkMainThread();
        this.mTapToFocusEnabled = enabled;
    }

    @NonNull
    @MainThread
    public LiveData<ZoomState> getZoomState() {
        Threads.checkMainThread();
        return this.mZoomState;
    }

    @NonNull
    @MainThread
    public ListenableFuture<Void> setZoomRatio(float zoomRatio) {
        Threads.checkMainThread();
        if (!this.isCameraAttached()) {
            Logger.w((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return Futures.immediateFuture(null);
        }
        return this.mCamera.getCameraControl().setZoomRatio(zoomRatio);
    }

    @NonNull
    @MainThread
    public ListenableFuture<Void> setLinearZoom(float linearZoom) {
        Threads.checkMainThread();
        if (!this.isCameraAttached()) {
            Logger.w((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return Futures.immediateFuture(null);
        }
        return this.mCamera.getCameraControl().setLinearZoom(linearZoom);
    }

    @NonNull
    @MainThread
    public LiveData<Integer> getTorchState() {
        Threads.checkMainThread();
        return this.mTorchState;
    }

    @NonNull
    @MainThread
    public ListenableFuture<Void> enableTorch(boolean torchEnabled) {
        Threads.checkMainThread();
        if (!this.isCameraAttached()) {
            Logger.w((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return Futures.immediateFuture(null);
        }
        return this.mCamera.getCameraControl().enableTorch(torchEnabled);
    }

    void startCameraAndTrackStates() {
        this.startCameraAndTrackStates(null);
    }

    void startCameraAndTrackStates(@Nullable Runnable restoreStateRunnable) {
        try {
            this.mCamera = this.startCamera();
        }
        catch (IllegalArgumentException exception) {
            if (restoreStateRunnable != null) {
                restoreStateRunnable.run();
            }
            String errorMessage = "The selected camera does not support the enabled use cases. Please disable use case and/or select a different camera. e.g. #setVideoCaptureEnabled(false)";
            throw new IllegalStateException(errorMessage, exception);
        }
        if (!this.isCameraAttached()) {
            Logger.d((String)TAG, (String)CAMERA_NOT_ATTACHED);
            return;
        }
        this.mZoomState.setSource((LiveData<ZoomState>)this.mCamera.getCameraInfo().getZoomState());
        this.mTorchState.setSource((LiveData<Integer>)this.mCamera.getCameraInfo().getTorchState());
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UseExperimental(markerClass=ExperimentalUseCaseGroup.class)
    protected UseCaseGroup createUseCaseGroup() {
        if (!this.isCameraInitialized()) {
            Logger.d((String)TAG, (String)CAMERA_NOT_INITIALIZED);
            return null;
        }
        if (!this.isPreviewViewAttached()) {
            Logger.d((String)TAG, (String)PREVIEW_VIEW_NOT_ATTACHED);
            return null;
        }
        UseCaseGroup.Builder builder = new UseCaseGroup.Builder().addUseCase((UseCase)this.mPreview);
        if (this.isImageCaptureEnabled()) {
            builder.addUseCase((UseCase)this.mImageCapture);
        } else {
            this.mCameraProvider.unbind(new UseCase[]{this.mImageCapture});
        }
        if (this.isImageAnalysisEnabled()) {
            builder.addUseCase((UseCase)this.mImageAnalysis);
        } else {
            this.mCameraProvider.unbind(new UseCase[]{this.mImageAnalysis});
        }
        if (this.isVideoCaptureEnabledInternal()) {
            builder.addUseCase((UseCase)this.mVideoCapture);
        } else {
            this.mCameraProvider.unbind(new UseCase[]{this.mVideoCapture});
        }
        builder.setViewPort(this.mViewPort);
        return builder.build();
    }

    class DisplayRotationListener
    implements DisplayManager.DisplayListener {
        DisplayRotationListener() {
        }

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        @SuppressLint(value={"WrongConstant"})
        @UseExperimental(markerClass=ExperimentalUseCaseGroup.class)
        public void onDisplayChanged(int displayId) {
            if (CameraController.this.mPreviewDisplay != null && CameraController.this.mPreviewDisplay.getDisplayId() == displayId) {
                CameraController.this.mPreview.setTargetRotation(CameraController.this.mPreviewDisplay.getRotation());
            }
        }
    }
}

